package fuku.eb4j.util;

/**
 * ӥ桼ƥƥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class CompareUtil {

    /**
     * 󥹥ȥ饯
     *
     */
    private CompareUtil() {
        super();
    }


    /**
     * ȥѥХͤӤޤ
     *
     * @param key 
     * @param pattern ѥ
     * @param exact פӤ뤫פӤ뤫
     *              (פξ硢ѥ˰פƱȤߤʤ)
     * @return ѥƱ0
     *         ѥ礭1ʾ塢
     *         ѥ꾮-1ʲ
     */
    public static int compareToCanonical(byte[] key, byte[] pattern, boolean exact) {
        int klen = key.length;
        int plen = pattern.length;
        int kByte, pByte;
        for (int i=0; i<klen; i++) {
            if (i >= plen) {
                return key[i] & 0xff;
            }
            if (key[i] == '\0') {
                if (exact) {
                    while (i < plen && (pattern[i] == '\0')) {
                        i++;
                    }
                    return i - plen;
                } else {
                    return 0;
                }
            }

            kByte = key[i] & 0xff;
            pByte = pattern[i] & 0xff;
            if (kByte != pByte) {
                return kByte - pByte;
            }
        }
        if (klen < plen && exact) {
            return - (pattern[klen] & 0xff);
        }
        return 0;
    }

    /**
     * ȥѥISO 8859-1ʸåȤӤޤ
     *
     * @param key  (ISO 8859-1)
     * @param pattern ѥ (ISO 8859-1)
     * @param exact פӤ뤫פӤ뤫
     *              (פξ硢ѥ˰פƱȤߤʤ)
     * @return ѥƱ0
     *         ѥ礭1ʾ塢
     *         ѥ꾮-1ʲ
     */
    public static int compareToLatin(byte[] key, byte[] pattern, boolean exact) {
        int klen = key.length;
        int plen = pattern.length;
        int kByte, pByte;
        for (int i=0; i<klen; i++) {
            if (i >= plen) {
                return key[i] & 0xff;
            }
            if (key[i] == '\0') {
                if (exact) {
                    while (i < plen && (pattern[i] == ' ' || pattern[i] == '\0')) {
                        i++;
                    }
                    return i - plen;
                } else {
                    return 0;
                }
            }

            kByte = key[i] & 0xff;
            pByte = pattern[i] & 0xff;
            if (kByte != pByte) {
                return kByte - pByte;
            }
        }
        if (klen < plen && exact) {
            return - (pattern[klen] & 0xff);
        }
        return 0;
    }

    /**
     * ȥѥJIS X 0208ʸåȤӤޤ
     *
     * @param key  (JIS X 0208)
     * @param pattern ѥ (JIS X 0208)
     * @param exact פӤ뤫פӤ뤫
     *              (פξ硢ѥ˰פƱȤߤʤ)
     * @return ѥƱ0
     *         ѥ礭1ʾ塢
     *         ѥ꾮-1ʲ
     */
    public static int compareTo(byte[] key, byte[] pattern, boolean exact) {
        int klen = key.length;
        int plen = pattern.length;
        int kByte, pByte;
        for (int i=0; i<klen; i+=2) {
            if (i >= plen) {
                return key[i] & 0xff;
            }
            if (key[i] == '\0') {
                if (exact) {
                    return - (pattern[i] & 0xff);
                } else {
                    return 0;
                }
            }
            if (i+1 >= klen || i+1 >= plen) {
                return (key[i] & 0xff) - (pattern[i] & 0xff);
            }

            kByte = key[i] & 0xff;
            pByte = pattern[i] & 0xff;
            if (kByte != pByte) {
                return kByte - pByte;
            }
            kByte = key[i+1] & 0xff;
            pByte = pattern[i+1] & 0xff;
            if (kByte != pByte) {
                return kByte - pByte;
            }
        }
        if (klen < plen && exact) {
            return - (pattern[klen] & 0xff);
        }
        return 0;
     }
}

// end of CompareUtil.java
