package fuku.eb4j.util;

import java.awt.*;
import java.util.zip.*;

/**
 * ᡼桼ƥƥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class ImageUtil {

    /** PNGإå */
    private static final byte[] PNG_HEADER = {
        /* PNGե륷ͥ */
        (byte)0x89, 'P', 'N', 'G', 0x0d, 0x0a, 0x1a, 0x0a,

        /* ᡼إå */
        // ǡĹ
        0x00, 0x00, 0x00, 0x0d,
        // ֥å (᡼إå)
        'I', 'H', 'D', 'R',
        // ᡼
        0x00, 0x00, 0x00, 0x00,
        // ᡼ι⤵
        0x00, 0x00, 0x00, 0x00,
        // ӥåȿ顼
        0x08, 0x06,
        // ե륿󥿥졼
        0x00, 0x00, 0x00,
        // CRC
        0x00, 0x00, 0x00, 0x00
    };

    /** PNGեå */
    private static final byte[] PNG_FOOTER = {
        // ǡĹ
        0x00, 0x00, 0x00, 0x00,
        // ֥å (᡼ü)
        'I', 'E', 'N', 'D',
        // CRC
        (byte)0xae, 0x42, 0x60, (byte)0x82
    };


    /**
     * 󥹥ȥ饯
     *
     */
    private ImageUtil() {
        super();
    }


    /**
     * ǥեȤΰ̥٥롢ʿطʿ̵Ʃ
     * ӥåȥޥåץ᡼PNG (Portable Network Graphics) Ѵޤ
     *
     * @param b ӥåȥޥåץǡ
     * @param width 
     * @param height ι⤵
     * @return PNGǡ
     */
    public static byte[] bitmapToPNG(byte[] b, int width, int height) {
        return bitmapToPNG(b, width, height,
                           Color.BLACK, Color.WHITE,
                           false, Deflater.DEFAULT_COMPRESSION);
    }

    /**
     * ǥեȤΰ̥٥롢ꤵ줿ʿꤵ줿طʿ
     * ӥåȥޥåץ᡼PNG (Portable Network Graphics) Ѵޤ
     *
     * @param b ӥåȥޥåץǡ
     * @param width 
     * @param height ι⤵
     * @param foreground ʿ
     * @param background طʿ
     * @param transparent طʤƩᤵ뤫ɤ
     * @return PNGǡ
     */
    public static byte[] bitmapToPNG(byte[] b, int width, int height,
                                     Color foreground, Color background,
                                     boolean transparent) {
        return bitmapToPNG(b, width, height,
                           foreground, background,
                           transparent, Deflater.DEFAULT_COMPRESSION);
    }

    /**
     * ꤵ줿̥٥롢ꤵ줿ʿꤵ줿طʿ
     * ӥåȥޥåץ᡼PNG (Portable Network Graphics) Ѵޤ
     *
     * @param b ӥåȥޥåץǡ
     * @param width 
     * @param height ι⤵
     * @param foreground ʿ
     * @param background طʿ
     * @param transparent طʤƩᤵ뤫ɤ
     * @param level ̥٥ (0-9)
     * @return PNGǡ
     */
    public static byte[] bitmapToPNG(byte[] b, int width, int height,
                                     Color foreground, Color background,
                                     boolean transparent, int level) {
        byte[] fRGB = new byte[4];
        fRGB[0] = (byte)foreground.getRed();
        fRGB[1] = (byte)foreground.getGreen();
        fRGB[2] = (byte)foreground.getBlue();
        fRGB[3] = (byte)0xff;
        byte[] bRGB = new byte[4];
        bRGB[0] = (byte)background.getRed();
        bRGB[1] = (byte)background.getGreen();
        bRGB[2] = (byte)background.getBlue();
        if (transparent) {
            bRGB[3] = (byte)0x00;
        } else {
            bRGB[3] = (byte)0xff;
        }

        // ᡼ǡκ
        byte[] image = new byte[(width*4+1)*height];

        int offi = 0;
        int offb = 0;
        byte[] c = null;
        for (int i=0; i<height; i++) {
            image[offi++] = 0x00; // filter type
            for (int j=0; j<width; j+=8) {
                int cnt = 8;
                if (j+8 > width) {
                    cnt = width - j;
                }
                int mask = 0x80;
                for (int k=0; k<cnt; k++) {
                    if ((b[offb] & mask) > 0) {
                        c = fRGB;
                    } else {
                        c = bRGB;
                    }
                    image[offi++] = c[0]; // R
                    image[offi++] = c[1]; // G
                    image[offi++] = c[2]; // B
                    image[offi++] = c[3]; // alpha
                    mask = mask >>> 1;
                }
                offb++;
            }
        }

        return _encodePNG(width, height, image, level);
    }

    /**
     * ǥեȤΰ̥٥DIB (Device Independent Bitmaps) 
     * PNG (Portable Network Graphics) Ѵޤ
     *
     * @param b DIBǡ
     * @return PNGǡ (̵DIBǡξnull)
     */
    public static byte[] dibToPNG(byte[] b) {
        return dibToPNG(b, Deflater.DEFAULT_COMPRESSION);
    }

    /**
     * ꤵ줿̥٥DIB (Device Independent Bitmaps) 
     * PNG (Portable Network Graphics) Ѵޤ
     *
     * @param b DIBǡ
     * @param level ̥٥ (0-9)
     * @return PNGǡ (̵DIBǡξnull)
     */
    public static byte[] dibToPNG(byte[] b, int level) {
        if ((b[0] & 0xff) != 'B' || (b[1] & 0xff) != 'M') {
            return null;
        }

        int off = (int)ByteUtil.getLongLE4(b, 10);
        int width = (int)ByteUtil.getLongLE4(b, 18);
        int height = (int)ByteUtil.getLongLE4(b, 22);
        int bitCount = ByteUtil.getIntLE2(b, 28);
        int compress = (int)ByteUtil.getLongLE4(b, 30);

        // 1ԤΥХȿλ
        int lineBytes = (width * bitCount + 31) / 32 * 4;

        // RLEοĥ
        byte[] dib = b;
        if (compress > 0) {
            if ((compress == 1 && bitCount == 8)
                || (compress == 2 && bitCount == 4)) {
                dib = _expandRLE(b, off, compress, lineBytes, height);
            } else {
                return null;
            }
        }

        byte[] line = new byte[lineBytes];

        // ᡼ǡκ
        byte[] image = new byte[(width*4+1)*height];
        int idx = 0;
        switch (bitCount) {
            case 1:
                for (int i=height-1; i>=0; i--) {
                    image[idx++] = 0x00; // filter type
                    System.arraycopy(dib, off+lineBytes*i, line, 0, lineBytes);
                    for (int j=0; j<width; j+=8) {
                        int cnt = 8;
                        if (j+8 > width) {
                            cnt = width - j;
                        }
                        int mask = 0x80;
                        for (int k=0; k<cnt; k++) {
                            int pallet = 54;
                            if ((line[j/8] & mask) > 0) {
                                pallet += 4;
                            }
                            image[idx++] = dib[pallet+2]; // R
                            image[idx++] = dib[pallet+1]; // G
                            image[idx++] = dib[pallet];   // B
                            image[idx++] = (byte)0xff;    // alpha
                            mask = mask >>> 1;
                        }
                    }
                }
                break;
            case 4:
                for (int i=height-1; i>=0; i--) {
                    image[idx++] = 0x00; // filter type
                    System.arraycopy(dib, off+lineBytes*i, line, 0, lineBytes);
                    int shift = 0;
                    for (int j=0; j<width; j+=2) {
                        int pallet = 54 + ((line[j/2] >>> 4) & 0x0f) * 4;
                        image[idx++] = dib[pallet+2]; // R
                        image[idx++] = dib[pallet+1]; // G
                        image[idx++] = dib[pallet];   // B
                        image[idx++] = (byte)0xff;    // alpha
                        if (width - j > 1) {
                            pallet = 54 + (line[j/2] & 0x0f) * 4;
                            image[idx++] = dib[pallet+2]; // R
                            image[idx++] = dib[pallet+1]; // G
                            image[idx++] = dib[pallet];   // B
                            image[idx++] = (byte)0xff;    // alpha
                        }
                    }
                }
                break;
            case 8:
                for (int i=height-1; i>=0; i--) {
                    image[idx++] = 0x00; // filter type
                    System.arraycopy(dib, off+lineBytes*i, line, 0, lineBytes);
                    for (int j=0; j<width; j++) {
                        int pallet = 54 + (line[j] & 0xff) * 4;
                        image[idx++] = dib[pallet+2]; // R
                        image[idx++] = dib[pallet+1]; // G
                        image[idx++] = dib[pallet];   // B
                        image[idx++] = (byte)0xff;    // alpha
                    }
                }
                break;
            case 24:
                for (int i=height-1; i>=0; i--) {
                    image[idx++] = 0x00; // filter type
                    System.arraycopy(dib, off+lineBytes*i, line, 0, lineBytes);
                    for (int j=0; j<width*3; j+=3) {
                        image[idx++] = line[j+2];   // R
                        image[idx++] = line[j+1];   // G
                        image[idx++] = line[j];     // B
                        image[idx++] = (byte)0xff;  // alpha
                    }
                }
                break;
            default:
                return null;
        }

        return _encodePNG(width, height, image, level);
    }

    /**
     * 󥰥󥳡ɤ줿DIBǡĥޤ
     *
     * @param rle RLE-DIBǡ
     * @param off ᡼ǡΰ
     * @param type ̥
     * @param line 1ԤΥӥåȿ
     * @param height ⤵
     * @return ĥDIBǡ (إåϤΤޤ)
     */
    private static byte[] _expandRLE(byte[] rle, int off, int type,
                                     int line, int height) {
        int len = off + line * height;
        byte[] dib = new byte[len];
        System.arraycopy(rle, 0, dib, 0, off);
        int idx1 = off;
        int idx2 = off;
        int abs = 0;
        int pad = 0;
        int code1, code2;
        if (type == 1) {
            for (int i=off; i<len; i+=2) {
                code1 = rle[idx2++] & 0xff;
                code2 = rle[idx2++] & 0xff;
                // Х⡼
                if (abs > 0) {
                    dib[idx1++] = (byte)code1;
                    abs--;
                    if (abs > 0) {
                        dib[idx1] = (byte)code2;
                    }
                    continue;
                }
                // ץ
                if (code1 == 0x00) {
                    switch (code2) {
                        case 0x00: // end of line
                        case 0x01: // end of block
                            if (pad <= 0) {
                                pad = 3 - ((idx1 - off + 3) % 4);
                            }
                            for (int j=0; j<pad; j++) {
                                dib[idx1++] = 0x00;
                            }
                            if (code2 == 0x01) {
                                return dib;
                            }
                            break;
                        case 0x02: // skip
                            break;
                        default: // absolute mode
                            abs = code2;
                            break;
                    }
                    continue;
                }
                for (int j=0; j<code1; j++) {
                    dib[idx1++] = (byte)code2;
                }
            }
        } else {
            boolean high = false;
            for (int i=off; i<len; i+=2) {
                code1 = rle[idx2++] & 0xff;
                code2 = rle[idx2++] & 0xff;
                // Х⡼
                if (abs > 0) {
                    if (high) {
                        dib[idx1] = (byte)(dib[idx1] | code1 >>> 4);
                        idx1++;
                    } else {
                        dib[idx1] = (byte)(code1 & 0xf0);
                    }
                    abs--;
                    high = !high;
                    if (abs > 0) {
                        if (high) {
                            dib[idx1] = (byte)(dib[idx1] | (code1 & 0x0f));
                            idx1++;
                        } else {
                            dib[idx1] = (byte)(code1 << 4);
                        }
                        abs--;
                        high = !high;
                    }
                    if (abs > 0) {
                        if (high) {
                            dib[idx1] = (byte)(dib[idx1] | code2 >>> 4);
                            idx1++;
                        } else {
                            dib[idx1] = (byte)(code2 & 0xf0);
                        }
                        abs--;
                        high = !high;
                    }
                    if (abs > 0) {
                        if (high) {
                            dib[idx1] = (byte)(dib[idx1] | (code2 & 0x0f));
                            idx1++;
                        } else {
                            dib[idx1] = (byte)(code2 << 4);
                        }
                        abs--;
                        high = !high;
                    }
                    continue;
                }
                // ץ
                if (code1 == 0x00) {
                    switch (code2) {
                        case 0x00: // end of line
                        case 0x01: // end of block
                            if (pad <= 0) {
                                pad = 3 - ((idx1 - off + 3) % 4);
                            }
                            for (int j=0; j<pad; j++) {
                                dib[idx1++] = 0x00;
                            }
                            if (code2 == 0x01) {
                                return dib;
                            }
                            break;
                        case 0x02: // skip
                            break;
                        default: // absolute mode
                            abs = code2;
                            break;
                    }
                    continue;
                }
                for (int j=0; j<code1/2; j++) {
                    if (high) {
                        dib[idx1] = (byte)(dib[idx1] | code2 >>> 4);
                        idx1++;
                        dib[idx1] = (byte)(code2 << 4);
                    } else {
                        dib[idx1++] = (byte)code2;
                    }
                }
                if ((code1 % 2) > 0) {
                    if (high) {
                        dib[idx1] = (byte)(dib[idx1] | code2 >>> 4);
                        idx1++;
                    } else {
                        dib[idx1] = (byte)(code2 & 0xf0);
                    }
                    high = !high;
                }
            }
        }
        return dib;
    }

    /**
     * ᡼ǡPNG˥󥳡ɤޤ
     *
     * @param width 
     * @param height ⤵
     * @param image ᡼ǡ
     * @param level ̥٥
     * @return PNGǡ
     */
    private static byte[] _encodePNG(int width, int height,
                                     byte[] image, int level) {
        // ᡼ǡΰ
        byte[] buf = new byte[image.length+62];
        Deflater def = new Deflater(level);
        def.setInput(image, 0, image.length);
        def.finish();
        int len = 0;
        while (!def.needsInput()) {
            int n = def.deflate(buf, len, buf.length-len);
            len += n;
        }
        def.end();

        // PNGǡκ
        int size = PNG_HEADER.length + len + 12 + PNG_FOOTER.length;
        byte[] png = new byte[size];

        // ե륷ͥ㡢IHDR֥å
        System.arraycopy(PNG_HEADER, 0, png, 0, PNG_HEADER.length);

        // ᡼
        png[16] = (byte)((width >>> 24) & 0xff);
        png[17] = (byte)((width >>> 16) & 0xff);
        png[18] = (byte)((width >>> 8) & 0xff);
        png[19] = (byte)(width & 0xff);
        // ᡼ι⤵
        png[20] = (byte)((height >>> 24) & 0xff);
        png[21] = (byte)((height >>> 16) & 0xff);
        png[22] = (byte)((height >>> 8) & 0xff);
        png[23] = (byte)(height & 0xff);
        // IHDR֥åCRC
        CRC32 crc = new CRC32();
        crc.update(png, 12, 17);
        long c = crc.getValue();
        png[29] = (byte)((c >>> 24) & 0xff);
        png[30] = (byte)((c >>> 16) & 0xff);
        png[31] = (byte)((c >>> 8) & 0xff);
        png[32] = (byte)(c & 0xff);

        // IDAT֥å
        int off = PNG_HEADER.length;
        // ǡĹ
        png[off++] = (byte)((len >>> 24) & 0xff);
        png[off++] = (byte)((len >>> 16) & 0xff);
        png[off++] = (byte)((len >>> 8) & 0xff);
        png[off++] = (byte)(len & 0xff);
        // ֥å (᡼ǡ)
        png[off++] = 'I';
        png[off++] = 'D';
        png[off++] = 'A';
        png[off++] = 'T';
        // ̤᡼ǡ
        System.arraycopy(buf, 0, png, off, len);
        // IDAT֥åCRC
        crc.reset();
        crc.update(png, off-4, len+4);
        c = crc.getValue();
        off += len;
        png[off++] = (byte)((c >>> 24) & 0xff);
        png[off++] = (byte)((c >>> 16) & 0xff);
        png[off++] = (byte)((c >>> 8) & 0xff);
        png[off++] = (byte)(c & 0xff);

        // IEND֥å
        System.arraycopy(PNG_FOOTER, 0, png, off, PNG_FOOTER.length);

        return png;
    }
}

// end of ImageUtil.java
