package fuku.player;

import java.awt.*;
import java.net.*;
import java.io.*;
import javax.swing.*;

import javax.media.*;

/**
 * ưץåȡ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class VideoPlayerApplet
    extends JApplet implements ControllerListener {

    /** ץ쥤 */
    private Player _player = null;
    /** ץ쥹С */
    private Component _progressBar = null;
    /** ɽݡͥ */
    private Component _visualComp = null;
    /** ȥ饳ݡͥ */
    private Component _controlComp = null;


    /**
     * ΥץåȤޤ
     *
     */
    public void init() {
        getContentPane().setLayout(new BorderLayout(0, 0));

        try {
            URL url = new URL(getDocumentBase(), getParameter("file"));
            _player = Manager.createPlayer(url);
            _player.addControllerListener(this);
        } catch (MalformedURLException e) {
            System.err.println(e.getMessage());
        } catch (IOException e) {
            System.err.println(e.getMessage());
        } catch (NoPlayerException e) {
            System.err.println(e.getMessage());
        }
    }

    /**
     * ץåȤϤȸƤӽФޤ
     *
     */
    public void start() {
        if (_player != null) {
            _player.start();
        }
    }

    /**
     * ץåȤߤȸƤӽФޤ
     *
     */
    public void stop() {
        if (_player != null) {
            _player.stop();
            _player.deallocate();
        }
    }

    /**
     * ٤ƤΥ꥽ޤ
     *
     */
    public void destroy() {
        getContentPane().removeAll();
        _progressBar = null;
        _visualComp = null;
        _controlComp = null;
        if (_player != null) {
            _player.close();
            _player = null;
        }
    }

    /**
     * ȥ饤٥ȤȯȸƤӽФޤ
     *
     * @param evt ȥ饤٥
     */
    public synchronized void controllerUpdate(ControllerEvent evt) {
        if (_player == null) {
            return;
        }
        if (evt instanceof RealizeCompleteEvent) {
            _player.stop();
            if (_visualComp == null) {
                // ɽݡͥȤɲ
                _visualComp = _player.getVisualComponent();
                if (_visualComp != null) {
                    getContentPane().add(_visualComp, BorderLayout.CENTER);
                }
            }
            if (_controlComp == null) {
                // ȥ饳ݡͥȤɲ
                _controlComp = _player.getControlPanelComponent();
                if (_controlComp != null) {
                    getContentPane().add(_controlComp, BorderLayout.SOUTH);
                }
            }
            validate();
        } else if (evt instanceof CachingControlEvent) {
            CachingControlEvent e = (CachingControlEvent)evt;
            CachingControl cc = e.getCachingControl();
            if (_progressBar == null) {
                // ɾץ쥹Сɽ
                _progressBar = cc.getProgressBarComponent();
                if (_progressBar != null) {
                    getContentPane().add(_progressBar, BorderLayout.NORTH);
                    validate();
                }
            }
            if (_progressBar != null) {
                // ɤλ
                if (e.getContentProgress() == cc.getContentLength()) {
                    getContentPane().remove(_progressBar);
                    _progressBar = null;
                    validate();
                }
            }
        } else if (evt instanceof EndOfMediaEvent) {
            _player.setMediaTime(new Time(0));
        } else if (evt instanceof ControllerErrorEvent) {
            ControllerErrorEvent e = (ControllerErrorEvent)evt;
            System.err.println(e.getMessage());
        }
    }
}

// end of VideoPlayerApplet.java
