package fuku.webbook;

import java.awt.*;
import java.io.*;
import java.util.*;

import fuku.eb4j.SubBook;
import fuku.eb4j.hook.HookAdapter;
import fuku.eb4j.util.ByteUtil;

/**
 * HTMLѥץ󥹲ù饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class HTMLHook extends HookAdapter {

    /** ǥץ쥤䥢ץå */
    private static final String AUDIO_PLAYER = "fuku.player.AudioPlayerApplet";
    /** ӥǥץ쥤䥢ץå */
    private static final String VIDEO_PLAYER = "fuku.player.VideoPlayerApplet";
    /** ץåȤJARե */
    private static final String ARCHIVE = "player.jar";
    /** ץåȤ (ǥ) */
    private static final String AUDIO_WIDTH = "32";
    /** ץåȤι⤵ (ǥ) */
    private static final String AUDIO_HEIGHT = "16";

    /** ϹԿ */
    private static final int MAX_LINE = 500;

    /** ȾɽϤƤ뤫ɤ򼨤ե饰 */
    private boolean _narrow = false;
    /** ǥ */
    private int _indent = 0;
    /** ͥѥå */
    private Stack _stack = new Stack();

    /** Կ */
    private int _line = 0;

    /** ǥեȤʿ */
    private Color _default = Color.BLACK;
    /** ɽʿ */
    private Color _keyword = Color.RED;
    /** 󥫡ɽʿ */
    private Color _anchor = Color.BLUE;

    /** ߤʿ */
    private Color _foreground = _default;
    /** ߤطʿ */
    private Color _background = Color.WHITE;

    /**  */
    private SubBook _sub = null;

    /** HTMLǡ */
    private StringBuffer _html = new StringBuffer(2048);
    /** ʸХåե */
    private StringBuffer _buf = new StringBuffer(256);
    /** ϥХåե */
    private StringBuffer _output = _html;

    /** HTMLХåեȾѳϰ */
    private int _position = 0;

    /** ȻURL */
    private String _href = null;
    /** ХʥǡեURL */
    private String _base = "./";
    /** URN쥯URL */
    private String _urn = null;

    /** Υ饤ɽ */
    private boolean _inline = false;
    /** ץåȤλ */
    private boolean _applet = false;

    /** Υ/ư */
    private int _width = -1;
    /** Υ/ưι⤵ */
    private int _height = -1;
    /** 顼ΰ */
    private long _imgPos = -1L;
    /** 顼 */
    private int _imgFormat = -1;
    /** ʸ */
    private int _decoration = 0;

    /** ץåȥѥ᡼ */
    private StringBuffer _file = new StringBuffer(128);


    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     * @param href ȻURL
     * @param base ХʥǡΥ١URL
     * @param urn URN쥯URL
     */
    public HTMLHook(SubBook sub, String href, String base, String  urn) {
        super();
        _sub = sub;
        _href = href;
        _urn = urn;

        if (base == null) {
            _base = "./";
        } else {
            if (!base.endsWith("/")) {
                _base = base + "/";
            } else {
                _base = base;
            }
        }
    }

    /**
     * Υ饤ɽꤷޤ
     *
     * @param inline 򥤥饤ɽtureǤʤfalse
     */
    public void setInline(boolean inline) {
        _inline = inline;
    }

    /**
     * ץåȤλѤꤷޤ
     *
     * @param applet ץåȤѤtureǤʤfalse
     */
    public void setApplet(boolean applet) {
        _applet = applet;
    }

    /**
     * ǥեȤʿꤷޤ
     *
     * @param color ꤹ뿧
     */
    public void setForegroundColor(Color color) {
        if (color != null) {
            if (_foreground.equals(_default)) {
                _foreground = color;
            }
            _default = color;
        }
    }

    /**
     * طʿꤷޤ
     *
     * @param color ꤹ뿧
     */
    public void setBackgroundColor(Color color) {
        if (color != null) {
            _background = color;
        }
    }

    /**
     * ɳϻʿꤷޤ
     *
     * @param color ꤹ뿧
     */
    public void setKeywordColor(Color color) {
        if (color != null) {
            if (_foreground.equals(_keyword)) {
                _foreground = color;
            }
            _keyword = color;
        }
    }

    /**
     * ȳϻʿꤷޤ
     *
     * @param color ꤹ뿧
     */
    public void setAnchorColor(Color color) {
        if (color != null) {
            if (_foreground.equals(_anchor)) {
                _foreground = color;
            }
            _anchor = color;
        }
    }

    /**
     * ٤ƤϤ򥯥ꥢޤ
     *
     */
    public void clear() {
        _html.delete(0, _html.length());
        _buf.delete(0, _buf.length());
        _narrow = false;
        _indent = 0;
        _line = 0;
    }

    /**
     * եåˤäƲù줿֥Ȥ֤ޤ
     *
     * @return HTMLʸ
     */
    public Object getObject() {
        if (!_stack.empty()) {
            _html.append("</DD></DL>");
            _indent = ((Integer)_stack.pop()).intValue();
            while (!_stack.empty()) {
                _html.append("</DD></DL>");
                _indent = ((Integer)_stack.pop()).intValue();
            }
        }
        return _html.toString();
    }

    /**
     * Ϥǽɤ֤ޤ
     *
     * @return ޤϤĤtrueǤʤfalse
     */
    public boolean isMoreInput() {
        if (_line >= MAX_LINE) {
            return false;
        }
        return true;
    }

    /**
     * ʸɲäޤ
     *
     * @param str ʸ
     */
    public void append(String str) {
        if (_narrow) {
            str = ByteUtil.wideToNarrow(str);
        }
        _output.append(HTMLUtil.encode(str));
    }

    /**
     * ɲäޤ
     *
     * @param code ʸ
     */
    public void append(int code) {
        // ϥե̾
        int fore = _foreground.getRGB() | 0xff000000;
        int back = _background.getRGB() | 0xff000000;
        String height = Integer.toString(_sub.getFont().getFontHeight());
        String width = null;
        String prefix = null;
        if (_narrow) {
            prefix = "N";
            width = Integer.toString(_sub.getFont().getNarrowFontWidth());
        } else {
            prefix = "W";
            width = Integer.toString(_sub.getFont().getWideFontWidth());
        }
        String alt = prefix + height
            + "-" + Integer.toHexString(code).toUpperCase();

        // HTMLɲ
        _output.append("<IMG class=\"gaiji\" src=\"");
        _output.append(_base).append(alt);
        _output.append("_F-");
        _output.append(Integer.toHexString(fore).substring(2).toUpperCase());
        _output.append("_B-");
        _output.append(Integer.toHexString(back).substring(2).toUpperCase());
        _output.append(".png\"");
        _output.append(" width=\"").append(width).append("\"");
        _output.append(" height=\"").append(height).append("\"");
        _output.append(" alt=\"[").append(alt).append("]\">");
    }

    /**
     * ȾɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginNarrow() {
        _narrow = true;
        _position = _html.length();
    }

    /**
     * Ⱦɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endNarrow() {
        _narrow = false;
        _addLink();
    }

    /**
     * դɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginSubscript() {
        _output.append("<SUB>");
    }

    /**
     * դɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endSubscript() {
        _output.append("</SUB>");
    }

    /**
     * դɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginSuperscript() {
        _output.append("<SUP>");
    }

    /**
     * դɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endSuperscript() {
        _output.append("</SUP>");
    }

    /**
     * Ƭλɽץ󥹤ФեåǤ
     *
     * @param indent 
     */
    public void setIndent(int indent) {
        if (indent < 0) {
            return;
        }
        if (_output.length() <= 0) {
            _indent = indent;
            return;
        }
        if (indent > _indent) {
            _stack.push(new Integer(_indent));
            _indent = indent;
            _output.append("<DL><DT></DT><DD>");
        } else {
            while (indent < _indent) {
                if (_stack.empty()) {
                    break;
                }
                _output.append("</DD></DL>");
                _indent = ((Integer)_stack.pop()).intValue();
            }
        }
    }

    /**
     * Ԥɽץ󥹤ФեåǤ
     *
     */
    public void newLine() {
        _output.append("<BR>");
        _line++;
    }

    /**
     * ԶػߤγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginNoNewLine() {
        _output.append("<NOBR>");
    }

    /**
     * Զػߤνλɽץ󥹤ФեåǤ
     *
     */
    public void endNoNewLine() {
        _output.append("</NOBR>");
    }

    /**
     * ĴɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginEmphasis() {
        _output.append("<EM>");
    }

    /**
     * Ĵɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endEmphasis() {
        _output.append("</EM>");
    }

    /**
     * ʸγϤɽץ󥹤ФեåǤ
     *
     * @param type ʸ
     * @see #BOLD
     * @see #ITALIC
     */
    public void beginDecoration(int type) {
        _decoration = type;
        switch (_decoration) {
            case BOLD:
                _output.append("<I>");
                break;
            case ITALIC:
                _output.append("<B>");
                break;
            default:
                _output.append("<U>");
                break;
        }
    }

    /**
     * ʸνλɽץ󥹤ФեåǤ
     *
     */
    public void endDecoration() {
        switch (_decoration) {
            case 1:
                _output.append("</I>");
                break;
            case 3:
                _output.append("</B>");
                break;
            default:
                _output.append("</U>");
                break;
        }
    }

    /**
     * ʣ縡θȤʤγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginCandidate() {
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * ʣ縡θȤʤνλɽץ󥹤ФեåǤ<BR>
     * ȤʤϤ˺٤ʬƤ뤳Ȥ򼨤ޤ
     *
     * @param pos γؤθǡΰ
     */
    public void endCandidateGroup(long pos) {
        _output = _html;
        if (_href != null) {
            _output.append("<A href=\"").append(_href);
            _output.append("&pos=").append(Long.toHexString(pos));
            _output.append("\">").append(_buf).append("</A>");
        }
    }

    /**
     * ʣ縡θȤʤνλɽץ󥹤ФեåǤ<BR>
     * Ȥʤ줬ºݤ˸ϸȤƻȤΤǤ뤳Ȥ򼨤ޤ
     *
     */
    public void endCandidateLeaf() {
        _output = _html;
        _output.append(_buf);
    }

    /**
     * ̰֤ΥƥȥǡλȳϤɽץ󥹤ФեåǤ
     *
     */
    public void beginReference() {
        _foreground = _anchor;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * ̰֤ΥƥȥǡλȽλɽץ󥹤ФեåǤ
     *
     * @param pos ΰ
     */
    public void endReference(long pos) {
        _output = _html;
        if (_href != null) {
            _output.append("<A href=\"").append(_href);
            _output.append("&pos=").append(Long.toHexString(pos));
            _output.append("\">").append(_buf).append("</A>");
        }
        _foreground = _default;
    }

    /**
     * ɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginKeyword() {
        _foreground = _keyword;
        _output.append("<SPAN class=\"keyword\">");
    }

    /**
     * ɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endKeyword() {
        _foreground = _default;
        _output.append("</SPAN>");
    }

    /**
     * ΥλȳϤɽץ󥹤ФեåǤ
     *
     * @param width 
     * @param height ι⤵
     */
    public void beginMonoGraphic(int width, int height) {
        _width = width;
        _height = height;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * ΥλȽλɽץ󥹤ФեåǤ
     *
     * @param pos ǡΰ
     */
    public void endMonoGraphic(long pos) {
        _output = _html;
        if (_width >= 0 && _height >= 0) {
            int len = _output.length();
            if (len >= 4 && _output.lastIndexOf("<BR>") == len-4) {
                _output.append("<BR>");
            }
            if (_inline || _buf.length() <= 0) {
                boolean flag = false;
                if (_buf.length() > 0) {
                    _output.append(_buf).append("<BR>");
                    flag = true;
                }
                _output.append("<IMG src=\"");
                _output.append(_base).append("M-");
                _output.append(Long.toHexString(pos).toUpperCase());
                _output.append("_W-");
                _output.append(Integer.toHexString(_width).toUpperCase());
                _output.append("_H-");
                _output.append(Integer.toHexString(_height).toUpperCase());
                _output.append(".png\"");
                _output.append(" width=\"").append(Integer.toString(_width)).append("\"");
                _output.append(" height=\"").append(Integer.toString(_height)).append("\"");
                _output.append(" alt=\"").append(_buf).append("\">");
                if (flag) {
                    _output.append("<BR>");
                }
            } else {
                _output.append("<A href=\"");
                _output.append(_base).append("M-");
                _output.append(Long.toHexString(pos).toUpperCase());
                _output.append("_W-");
                _output.append(Integer.toHexString(_width).toUpperCase());
                _output.append("_H-");
                _output.append(Integer.toHexString(_height).toUpperCase());
                _output.append(".png\">").append(_buf).append("</A>");
            }
        }
    }

    /**
     * 饤󥫥顼λȳϤɽץ󥹤ФեåǤ
     *
     * @param format 
     * @param pos ǡΰ
     * @see #DIB
     * @see #JPEG
     */
    public void beginInlineColorGraphic(int format, long pos) {
        _imgFormat = format;
        _imgPos = pos;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * 饤󥫥顼λȽλɽץ󥹤ФեåǤ
     *
     */
    public void endInlineColorGraphic() {
        _output = _html;
        if (_imgPos >= 0) {
            String suffix = null;
            if (_imgFormat == JPEG) {
                suffix = ".jpeg";
            } else {
                suffix = ".png";
            }
            int len = _output.length();
            if (len >= 4 && _output.lastIndexOf("<BR>") == len-4) {
                _output.append("<BR>");
            }
            boolean flag = false;
            if (_buf.length() > 0) {
                _output.append(_buf).append("<BR>");
                flag = true;
            }
            _output.append("<IMG src=\"");
            _output.append(_base).append("C-");
            _output.append(Long.toHexString(_imgPos).toUpperCase());
            _output.append(suffix).append("\"");
            _output.append(" alt=\"").append(_buf).append("\">");
            if (flag) {
                _output.append("<BR>");
            }
        }
    }

    /**
     * 顼λȳϤɽץ󥹤ФեåǤ
     *
     * @param format 
     * @param pos ǡΰ
     */
    public void beginColorGraphic(int format, long pos) {
        _imgFormat = format;
        _imgPos = pos;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * 顼λȽλɽץ󥹤ФեåǤ
     *
     */
    public void endColorGraphic() {
        _output = _html;
        if (_imgPos >= 0) {
            String suffix = null;
            if (_imgFormat == JPEG) {
                suffix = ".jpeg";
            } else {
                suffix = ".png";
            }
            int len = _output.length();
            if (len >= 4 && _output.lastIndexOf("<BR>") == len-4) {
                _output.append("<BR>");
            }
            if (_inline || _buf.length() <= 0) {
                boolean flag = false;
                if (_buf.length() > 0) {
                    _output.append(_buf).append("<BR>");
                    flag = true;
                }
                _output.append("<IMG src=\"");
                _output.append(_base).append("C-");
                _output.append(Long.toHexString(_imgPos).toUpperCase());
                _output.append(suffix).append("\"");
                _output.append(" alt=\"").append(_buf).append("\">");
                if (flag) {
                    _output.append("<BR>");
                }
            } else {
                _output.append("<A href=\"");
                _output.append(_base).append("C-");
                _output.append(Long.toHexString(_imgPos).toUpperCase());
                _output.append(suffix).append("\">").append(_buf).append("</A>");
            }
        }
    }

    /**
     * γϤɽץ󥹤ФեåǤ
     *
     * @param format 
     * @param start ǡγϰ
     * @param end ǡνλ
     * @see #WAVE
     * @see #MIDI
     */
    public void beginSound(int format, long start, long end) {
        _foreground = _anchor;
        _file.delete(0, _file.length());
        _file.append(_base).append("S-");
        _file.append(Long.toHexString(start).toUpperCase());
        _file.append("_E-");
        _file.append(Long.toHexString(end).toUpperCase());
        if (format == MIDI) {
            _file.append(".mid");
        } else {
            _file.append(".wav");
        }

        // HTMLɲ
        _output.append("<A href=\"").append(_file).append("\">");
    }

    /**
     * νλɽץ󥹤ФեåǤ
     *
     */
    public void endSound() {
        _output.append("</A>");
        if (_applet) {
            _output.append("<APPLET");
            _output.append(" code=\"").append(AUDIO_PLAYER).append("\"");
            _output.append(" archive=\"").append(ARCHIVE).append("\"");
            _output.append(" align=\"absbottom\"");
            _output.append(" width=\"").append(AUDIO_WIDTH).append("\"");
            _output.append(" height=\"").append(AUDIO_HEIGHT).append("\">");
            _output.append("<PARAM name=\"file\"");
            _output.append(" value=\"").append(_file).append("\">");
            _output.append("</APPLET>");
        }
        _foreground = _default;
    }

    /**
     * ưγϤɽץ󥹤ФեåǤ
     *
     * @param format ư
     * @param width ư
     * @param height ưι⤵
     * @param filename ưե̾
     */
    public void beginMovie(int format, int width, int height, String filename) {
        File mpeg = _sub.getMovieFile(filename);
        if (mpeg == null) {
            return;
        }
        _width = width;
        if (_width <= 0) {
            _width = 320;
        }
        _height = height;
        if (_height <= 0) {
            _height = 240;
        }
        _foreground = _anchor;

        _file.delete(0, _file.length());
        _file.append(_base).append(mpeg.getName()).append(".mpeg");

        // HTMLɲ
        _output.append("<A href=\"").append(_file).append("\">");
    }

    /**
     * ưνλɽץ󥹤ФեåǤ
     *
     */
    public void endMovie() {
        if (_foreground.equals(_anchor)) {
            _output.append("</A>");
            if (_applet) {
                _output.append("<BR><APPLET");
                _output.append(" code=\"").append(VIDEO_PLAYER).append("\"");
                _output.append(" archive=\"").append(ARCHIVE).append("\"");
                _output.append(" width=\"").append(Integer.toString(_width)).append("\"");
                _output.append(" height=\"").append(Integer.toString(_height+20)).append("\">");
                _output.append("<PARAM name=\"file\"");
                _output.append(" value=\"").append(_file).append("\">");
                _output.append("</APPLET><BR>");
            }
            _foreground = _default;
        }
    }

    /**
     * ϥѡ󥯤ɲäޤ
     *
     */
    private void _addLink() {
        /*
         *   name@host        ->  mailto:name@host
         *   method://string  ->  method://string
         *   www.host.name    ->  http://www.host.name
         *   ftp.host.name    ->  ftp://ftp.host.name
         *   urn:string       ->  _urn + urn:string
         */
        int[] pos = new int[5];
        pos[0] = _html.indexOf("@", _position+1);
        pos[1] = _html.indexOf("://", _position+1);
        pos[2] = _html.indexOf("www.", _position);
        pos[3] = _html.indexOf("ftp.", _position);
        pos[4] = _html.indexOf("urn:", _position);
        int index = -1;
        for (int i=0; i<pos.length; i++) {
            if (pos[i] >= 0 && (index < 0 || pos[i] < pos[index])) {
                index = i;
            }
        }
        int len, idx1, idx2, off1, off2, mark;
        char ch;
        String anchor = null;
        StringBuffer href = new StringBuffer();
        while (index >= 0) {
            href.delete(0, href.length());
            idx1 = -1;
            idx2 = -1;
            off1 = 0;
            off2 = 0;
            switch (index) {
                case 0: // mailto
                    href.append("@");
                    off1 = 1;
                    off2 = 1;
                    idx1 = pos[index];
                    while (idx1 > 0) { // 
                        ch = _html.charAt(idx1-1);
                        if ((ch >= 'a' && ch <= 'z')
                            || (ch >= 'A' && ch <= 'Z')
                            || (ch >= '0' && ch <= '9')
                            || ch == '!' || ch == '%' || ch == '+'
                            || ch == '-' || ch == '.' || ch == '_') {
                            idx1--;
                            href.insert(0, ch);
                        } else {
                            break;
                        }
                    }
                    idx2 = pos[index] + off2;
                    len = _html.length();
                    mark = 0;
                    while (idx2 < len) { // 
                        ch = _html.charAt(idx2);
                        if ((ch >= 'a' && ch <= 'z')
                            || (ch >= 'A' && ch <= 'Z')
                            || (ch >= '0' && ch <= '9')
                            || ch == '+' || ch == '-' || ch == '.' || ch == '_') {
                            idx2++;
                            href.append(ch);
                            if (ch == '.') {
                                mark++;
                            }
                        } else {
                            break;
                        }
                    }
                    if (mark > 0) {
                        href.insert(0, "mailto:");
                    } else {
                        idx1 = -1;
                    }
                    break;
                case 1: // url
                    href.append("://");
                    off1 = 1;
                    off2 = 3;
                    idx1 = pos[index];
                    while (idx1 > 0) { // 
                        ch = _html.charAt(idx1-1);
                        if (ch < 'a' || ch > 'z') {
                            break;
                        }
                        idx1--;
                        href.insert(0, ch);
                    }
                    idx2 = pos[index] + off2;
                    len = _html.length();
                    while (idx2 < len) { // 
                        ch = _html.charAt(idx2);
                        if ((ch >= 'a' && ch <= 'z')
                            || (ch >= 'A' && ch <= 'Z')
                            || (ch >= '0' && ch <= '9')
                            || ch == '#' || ch == '%' || ch == '(' || ch == ')'
                            || ch == '+' || ch == ',' || ch == '-' || ch == '.'
                            || ch == '/' || ch == ':' || ch == '=' || ch == '?'
                            || ch == '@' || ch == '_' || ch == '~') {
                            idx2++;
                            href.append(ch);
                        } else if (ch == '&'
                                   && _html.indexOf("&amp;", idx2) == idx2) {
                            idx2 += 5;
                            href.append(ch);
                        } else {
                            break;
                        }
                    }
                    break;
                case 2: // www
                case 3: // ftp
                case 4: // urn
                    if (index == 2) {
                        href.append("http://www.");
                    } else if (index == 3) {
                        href.append("ftp://ftp.");
                    } else {
                        href.append(_urn).append("urn:");
                    }
                    off1 = 0;
                    off2 = 4;
                    idx1 = pos[index];
                    if (idx1 > 0) {
                        ch = _html.charAt(idx1-1);
                        if ((ch >= 'a' && ch <= 'z')
                            || (ch >= 'A' && ch <= 'Z')
                            || (ch >= '0' && ch <= '9')
                            || ch == '#' || ch == '%' || ch == '(' || ch == ')'
                            || ch == '+' || ch == ',' || ch == '-' || ch == '.'
                            || ch == '/' || ch == ':' || ch == '=' || ch == '?'
                            || ch == '@' || ch == '_' || ch == '~') {
                            idx1 = -1;
                        }
                    }
                    idx2 = pos[index] + off2;
                    len = _html.length();
                    mark = 0;
                    while (idx2 < len) { // 
                        ch = _html.charAt(idx2);
                        if ((ch >= 'a' && ch <= 'z')
                            || (ch >= 'A' && ch <= 'Z')
                            || (ch >= '0' && ch <= '9')
                            || ch == '#' || ch == '%' || ch == '(' || ch == ')'
                            || ch == '+' || ch == ',' || ch == '-' || ch == '.'
                            || ch == '/' || ch == ':' || ch == '=' || ch == '?'
                            || ch == '@' || ch == '_' || ch == '~') {
                            idx2++;
                            href.append(ch);
                            if (ch == ':') {
                                mark++;
                            }
                        } else if (ch == '&'
                                   && _html.indexOf("&amp;", idx2) == idx2) {
                            idx2 += 5;
                            href.append(ch);
                        } else {
                            break;
                        }
                    }
                    if (index == 4 && mark == 0) {
                        // urn:xxx:xxx ηǤʤΤ̵
                        idx1 = -1;
                    }
                    break;
                default:
                    break;
            }
            if (idx1 >= 0 && idx2 >= 0
                && idx1 <= pos[index]-off1 && idx2 > pos[index]+off2) {
                if (index > 0) {
                    anchor = "<A href=\"" + href.toString() + "\" target=\"_top\">";
                } else {
                    anchor = "<A href=\"" + href.toString() + "\">";
                }
                _html.insert(idx1, anchor);
                idx2 += anchor.length();
                _html.insert(idx2, "</A>");
                idx2 += 4;
            }
            pos[0] = _html.indexOf("@", idx2+1);
            pos[1] = _html.indexOf("://", idx2+1);
            pos[2] = _html.indexOf("www.", idx2);
            pos[3] = _html.indexOf("ftp.", idx2);
            pos[4] = _html.indexOf("urn:", idx2);
            index = -1;
            for (int i=0; i<pos.length; i++) {
                if (pos[i] >= 0 && (index < 0 || pos[i] < pos[index])) {
                    index = i;
                }
            }
        }
    }
}

// end of HTMLHook.java
