package fuku.webbook;

import java.net.*;
import java.util.*;

/**
 * ۥȥꥹȥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class Hosts {

    /** ۥȥꥹȤĥꥹȤݥꥹȤ򼨤ե饰 */
    private boolean _allow = true;

    /** ۥȥꥹ(IPɥ쥹) */
    private List _addrList = new ArrayList();


    /**
     * 󥹥ȥ饯
     *
     * @param allow ꤵ줿ꥹȤĤtrueǤʤfalse
     * @param list ۥȤΥꥹ
     */
    public Hosts(boolean allow, String list) {
        super();
        _allow = allow;
        String[] hostList = StringUtil.split(list, ',', false);
        String host, mask;
        byte[][] bits;
        int i, j, n, m, b;
        int len = hostList.length;
        for (i=0; i<len; i++) {
            host = hostList[i].trim();
            n = host.indexOf("/");
            if (n >= 0) {
                try {
                    bits = new byte[2][];
                    mask = host.substring(n+1);
                    host = host.substring(0, n);
                    bits[0] = InetAddress.getByName(host).getAddress();
                    try {
                        // x.x.x.x/n 
                        m = Integer.parseInt(mask);
                        b = 0;
                        for (j=0; j<m; j++) {
                            b = (b >>> 1) | 0x80000000;
                        }
                        bits[1] = new byte[4];
                        for (j=0; j<4; j++) {
                            bits[1][j] = (byte)((b >>> (8 * (3 - j))) & 0xff);
                        }
                    } catch (NumberFormatException e) {
                        // x.x.x.x/y.y.y.y 
                        bits[1] = InetAddress.getByName(mask).getAddress();
                    }
                    _addrList.add(bits);
                } catch (UnknownHostException e) {
                }
            } else {
                try {
                    // x.x.x.x
                    bits = new byte[2][];
                    bits[0] = InetAddress.getByName(host).getAddress();
                    bits[1] = new byte[4];
                    bits[1][0] = (byte)0xff;
                    bits[1][1] = (byte)0xff;
                    bits[1][2] = (byte)0xff;
                    bits[1][3] = (byte)0xff;
                    _addrList.add(bits);
                } catch (UnknownHostException e) {
                }
            }
        }
    }

    /**
     * ꤵ줿ۥȤĤƤ뤫ɤȽꤷޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @return ĤƤtrueǤʤfalse
     */
    public boolean isAllowed(String host) {
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(host);
        } catch (UnknownHostException e) {
            return false;
        }

        boolean match = false;
        if (ia instanceof Inet4Address) {
            int i, j, addr, mask;
            byte[][] bits;

            int target = 0;
            byte[] b = ia.getAddress();
            for (i=0; i<4; i++) {
                target = (target << 8) | (b[i] & 0xff);
            }

            int size = _addrList.size();
            for (i=0; i<size; i++) {
                bits = (byte[][])_addrList.get(i);
                addr = 0;
                for (j=0; j<4; j++) {
                    addr = (addr << 8) | (bits[0][j] & 0xff);
                }
                mask = 0;
                for (j=0; j<4; j++) {
                    mask = (mask << 8) | (bits[1][j] & 0xff);
                }
                addr = (target ^ addr) & mask;
                if (addr == 0) {
                    match = true;
                    break;
                }
            }
        }

        return !(match ^ _allow);
    }
}

// end of Hosts.java
