package fuku.webbook;

import java.util.*;

/**
 * ʸ桼ƥƥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class StringUtil {

    /**
     * 󥹥ȥ饯
     *
     */
    private StringUtil() {
        super();
    }


    /**
     * ʸbooleanѴޤ<BR>
     * ʸ "true""on""yes" 
     * (ʸȾʸ϶̤ʤ) 硢ޤϡ
     * ͤȤ 0 ʾξtrue֤ޤ
     *
     * @param str ʸ
     * @return boolean
     */
    public static boolean toBoolean(String str) {
        if (str == null) {
            return false;
        }
        boolean ret = false;
        if (str.equalsIgnoreCase("true")) {
            ret = true;
        } else if (str.equalsIgnoreCase("yes")) {
            ret = true;
        } else if (str.equalsIgnoreCase("on")) {
            ret = true;
        } else {
            try {
                if (Integer.parseInt(str) > 0) {
                    ret = true;
                }
            } catch (NumberFormatException e) {
            }
        }
        return ret;
    }

    /**
     * ꤵ줿ǥߥʸڤޤ
     *
     * @param str ʸ
     * @param delim ǥߥ
     * @return ʸ
     */
    public static String[] split(String str, char delim) {
        return split(str, delim, true);
    }

    /**
     * ꤵ줿ǥߥʸڤޤ
     *
     * @param str ʸ
     * @param delim ǥߥ
     * @param empty Ǥɤ
     * @return ʸ
     */
    public static String[] split(String str, char delim, boolean empty) {
        if (str == null || str.length() <= 0) {
            return new String[0];
        }
        String sep = Character.toString(delim);
        StringBuffer buf = new StringBuffer(str);
        ArrayList list = new ArrayList();
        int idx1 = 0;
        int idx2 = buf.indexOf(sep, idx1);
        String s;
        while (idx2 >= 0) {
            if (idx2 > 0 && buf.charAt(idx2-1) == '\\') {
                buf.deleteCharAt(idx2-1);
                idx2--;
            } else {
                s = buf.substring(idx1, idx2);
                if (s.length() > 0 || empty) {
                    list.add(s);
                }
            }
            idx1 = idx2 + 1;
            idx2 = buf.indexOf(sep, idx1);
        }
        s = buf.substring(idx1, buf.length());
        if (s.length() > 0 || empty) {
            list.add(s);
        }
        return (String[])list.toArray(new String[0]);
    }
}

// end of StringUtil.java
