package fuku.webbook;

import java.io.*;
import java.net.*;
import java.util.*;

import fuku.eb4j.Book;
import fuku.eb4j.SubBook;
import fuku.eb4j.ExtFont;
import fuku.eb4j.Result;
import fuku.eb4j.EBException;

/**
 * Ҵ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class WebBook {

    /** ׸ */
    private static final int WORD = 0;
    /** ׸ */
    private static final int ENDWORD = 1;
    /** ׸ */
    private static final int EXACT = 2;
    /** ︡ */
    private static final int KEYWORD = 3;

    /** ̤ʸɽ */
    public static final String[] SEARCH_NAME = {
        "׸",
        "׸",
        "׸",
        "︡"
    };

    /** ꥽ǥ쥯ȥ̾ */
    private static final String RES_DIR = "resources/";

    /** ٤Ƥ */
    private SubBook[] _subs = null;
    /** եå */
    private HTMLHook[] _hooks = null;

    /**  */
    private WebBookConfig _config = null;


    /**
     * 󥹥ȥ饯
     *
     */
    public WebBook() {
        super();
    }


    /**
     * Υ֥Ȥꤷޤ
     *
     * @param conf Υ֥Ȥ
     * @exception EBException
     */
    public void setConfig(WebBookConfig conf) throws EBException {
        _subs = null;
        _hooks = null;
        _config = conf;

        String[] bookList = conf.getBookList();
        String[] appendixList = conf.getAppendixList();
        if (bookList != null) {
            String href = "detail.jsp?book=";
            ArrayList subList = new ArrayList(8);
            ArrayList hookList = new ArrayList(8);
            // Ҥμ
            int len = bookList.length;
            Book[] books = new Book[len];
            for (int i=0; i<len; i++) {
                books[i] = new Book(bookList[i], appendixList[i]);
                SubBook[] sb = books[i].getSubBooks();
                int sblen = sb.length;
                for (int j=0; j<sblen; j++) {
                    // 
                    if (sb[j].getFont(ExtFont.FONT_16).hasFont()) {
                        sb[j].setFont(ExtFont.FONT_16);
                    }
                    subList.add(sb[j]);
                    String param = null;
                    try {
                        param = URLEncoder.encode(sb[j].getName(), "UTF-8");
                    } catch (UnsupportedEncodingException e) {
                    }
                    HTMLHook hook =
                        new HTMLHook(sb[j], href + param,
                                     RES_DIR + sb[j].getName(),
                                     conf.getURNRedirectURL());
                    hook.setForegroundColor(_config.getForegroundColor());
                    hook.setBackgroundColor(_config.getBackgroundColor());
                    hook.setAnchorColor(_config.getAnchorColor());
                    hook.setKeywordColor(_config.getKeywordColor());
                    hookList.add(hook);
                }
            }
            if (!subList.isEmpty()) {
                _subs = (SubBook[])subList.toArray(new SubBook[0]);
                _hooks = (HTMLHook[])hookList.toArray(new HTMLHook[0]);
            }
        }
    }

    /**
     * å̵֤ͭޤ
     *
     * @return å̵ͭ
     */
    public boolean isGaijiCache() {
        if (_config == null) {
            return false;
        }
        return _config.isGaijiCache();
    }

    /**
     * å̵֤ͭޤ
     *
     * @return å̵ͭ
     */
    public boolean isImageCache() {
        if (_config == null) {
            return false;
        }
        return _config.isImageCache();
    }

    /**
     * å̵֤ͭޤ
     *
     * @return å̵ͭ
     */
    public boolean isSoundCache() {
        if (_config == null) {
            return false;
        }
        return _config.isSoundCache();
    }

    /**
     * åǥ쥯ȥ֤ޤ
     *
     * @return åǥ쥯ȥ
     */
    public File getCacheDirectory() {
        if (_config == null) {
            return null;
        }
        return _config.getCacheDirectory();
    }

    /**
     * ꤵ줿ܤؤΥĤƤ뤫ɤȽꤷޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name ̾
     * @return ĤƤtrueǤʤfalse
     */
    public boolean isAllowed(String host, String name) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0) {
            return false;
        }
        return true;
    }

    /**
     * ꤵ줿ۥȤ饢ǽܤΰ֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @return ܤΰ
     */
    public SubBook[] getSubBooks(String host) {
        ArrayList list = new ArrayList();
        if (_subs != null) {
            for (int i=0; i<_subs.length; i++) {
                String path = _subs[i].getBook().getPath();
                if (_config.isAllowed(host, path)) {
                    list.add(_subs[i]);
                }
            }
        }
        return (SubBook[])list.toArray(new SubBook[0]);
    }

    /**
     * ꤵ줿ܤ֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name ̾
     * @return 
     */
    public SubBook getSubBook(String host, String name) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0) {
            return null;
        }
        return _subs[idx];
    }

    /**
     * ꤵ줿ܤΥǥåֹ֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name ̾
     * @return ǥåֹ
     */
    private int _getSubBookIndex(String host, String name) {
        if (_subs == null || name == null) {
            return -1;
        }
        int len = _subs.length;
        for (int i=0; i<len; i++) {
            if (_subs[i].getName().equals(name)) {
                String path = _subs[i].getBook().getPath();
                if (_config.isAllowed(host, path)) {
                    return i;
                } else {
                    return -1;
                }
            }
        }
        return -1;
    }

    /**
     * ꤵ줿ˡǸԤޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾ (nullޤ϶ʸξϤ٤Ƥ)
     * @param word 
     * @param method ˡ
     * @param max 縡̿
     * @return  (̤ʤnull)
     */
    public synchronized Result[][] search(String host, String name,
                                          String word, int method, int max) {
        if (_subs == null || max <= 0) {
            return null;
        }
        SubBook[] subs = null;
        if (name == null || name.length() <= 0) {
            subs = getSubBooks(host);
            if (subs.length <= 0) {
                return null;
            }
        } else {
            subs = new SubBook[1];
            subs[0] = getSubBook(host, name);
            if (subs[0] == null) {
                return null;
            }
        }

        int len = subs.length;
        Result[][] results = new Result[len][];
        ArrayList list = new ArrayList(max);
        for (int i=0; i<len; i++) {
            try {
                switch (method) {
                    case WORD:
                        subs[i].searchWord(word);
                        break;
                    case ENDWORD:
                        subs[i].searchEndword(word);
                        break;
                    case EXACT:
                        subs[i].searchExactword(word);
                        break;
                    case KEYWORD:
                        word = word.replace('\t', ' ');
                        word = word.replace((char)0x3000, ' ');
                        StringTokenizer st = new StringTokenizer(word);
                        int tokens = st.countTokens();
                        String[] key = new String[tokens];
                        for (int j=0; j<tokens; j++) {
                            key[j] = st.nextToken();
                        }
                        subs[i].searchKeyword(key);
                        break;
                    default:
                        return null;
                }
                for (int j=0; j<max; j++) {
                    Result result = subs[i].getNextResult();
                    if (result == null) {
                        break;
                    }
                    if (_duplicateCheck(list, result)) {
                        j--;
                    } else {
                        list.add(result);
                    }
                }
                results[i] = (Result[])list.toArray(new Result[0]);
                list.clear();
            } catch (EBException e) {
                results[i] = new Result[0];
            }
        }
        return results;
    }

    /**
     * ʣ縡Ԥޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾
     * @param multiIndex ʣ縡Υǥå
     * @param keys 
     * @return 
     */
    public synchronized Result[][] search(String host, String name,
                                          int multiIndex, String[] keys) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0 || !_subs[idx].hasMultiSearch()) {
            return null;
        }

        Result[][] results = new Result[1][];
        ArrayList list = new ArrayList(10);
        try {
            _subs[idx].searchMulti(multiIndex, keys);
            Result result = _subs[idx].getNextResult();
            while (result != null) {
                if (!_duplicateCheck(list, result)) {
                    list.add(result);
                }
                result = _subs[idx].getNextResult();
            }
            results[0] = (Result[])list.toArray(new Result[0]);
        } catch (EBException e) {
            results[0] = new Result[0];
        } catch (IllegalArgumentException e) {
            results[0] = new Result[0];
        }
        return results;
    }

    /**
     * ̤νʣåޤ
     *
     * @param list ̤Υꥹ
     * @param result 
     * @return ̤ʣƤtrueǤʤfalse
     */
    private boolean _duplicateCheck(List list, Result result) {
        long pos1 = result.getTextPosition();
        int size = list.size();
        for (int i=0; i<size; i++) {
            Result item = (Result)list.get(i);
            if (pos1 == item.getTextPosition()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Ф֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾
     * @param result 
     * @return Ф
     */
    public String getHeading(String host, String name, Result result) {
        return getHeading(host, name, result.getHeadingPosition());
    }

    /**
     * Ф֤ޤ
     *
     * @param name оݤ̾
     * @param host ۥ̾ޤIPɥ쥹
     * @param pos Фΰ
     * @return Ф
     */
    public synchronized String getHeading(String host, String name, long pos) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0) {
            return "";
        }
        String heading = null;
        try {
            _hooks[idx].setForegroundColor(_config.getAnchorColor());
            _hooks[idx].setInline(false);
            _hooks[idx].setApplet(false);
            heading = (String)_subs[idx].getHeading(pos, _hooks[idx]);
        } catch (EBException e) {
        } finally {
            _hooks[idx].setForegroundColor(_config.getForegroundColor());
        }
        if (heading == null) {
            heading = "";
        }
        return heading;
    }

    /**
     * ʸ֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾
     * @param result 
     * @param inline Υ饤ɽ̵ͭ
     * @param applet ץåȤλ̵ͭ
     * @return ʸ
     */
    public String getText(String host, String name, Result result,
                          boolean inline, boolean applet) {
        return getText(host, name, result.getTextPosition(), inline, applet);
    }

    /**
     * ʸ֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾
     * @param pos ʸΰ
     * @param inline Υ饤ɽ̵ͭ
     * @param applet ץåȤλ̵ͭ
     * @return ʸ
     */
    public synchronized String getText(String host, String name, long pos,
                                       boolean inline, boolean applet) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0) {
            return "";
        }
        String text = null;
        try {
            _hooks[idx].setInline(inline);
            _hooks[idx].setApplet(applet);
            text = (String)_subs[idx].getText(pos, _hooks[idx]);
        } catch (EBException e) {
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    /**
     * ˥塼֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾
     * @return ˥塼
     */
    public synchronized String getMenu(String host, String name) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0) {
            return "";
        }
        String text = null;
        try {
            _hooks[idx].setInline(false);
            _hooks[idx].setApplet(false);
            text = (String)_subs[idx].getMenu(_hooks[idx]);
        } catch (EBException e) {
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    /**
     * ֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾
     * @return 
     */
    public synchronized String getCopyright(String host, String name) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0) {
            return "";
        }
        String text = null;
        try {
            _hooks[idx].setInline(true);
            _hooks[idx].setApplet(false);
            text = (String)_subs[idx].getCopyright(_hooks[idx]);
        } catch (EBException e) {
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    /**
     * ֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾
     * @param multiIndex ʣ縡Υǥå
     * @param entryIndex ȥΥǥå
     * @return 
     */
    public String getCandidate(String host, String name,
                               int multiIndex, int entryIndex) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0) {
            return "";
        }
        String text = null;
        try {
            text = (String)_subs[idx].getCandidate(multiIndex,
                                                   entryIndex,
                                                   new ListupHook(_subs[idx]));
        } catch (EBException e) {
        } catch (IllegalArgumentException e) {
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    /**
     * Ҿ֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾
     * @return Ҿ
     */
    public String getInfo(String host, String name) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Book book = _subs[idx].getBook();

        final String[] TRCLASS = {"odd", "even"};
        int tr = 0;

        buf.append("<TABLE class=\"main\">");
        buf.append("<TR class=\"header main\">");
        buf.append("<TH colspan=\"2\" class=\"header\">");
        buf.append(_subs[idx].getTitle());
        buf.append("</TH></TR>");

        // Ҥμ
        buf.append("<TR class=\"").append(TRCLASS[tr]).append(" main\">");
        tr = (tr + 1) % 2;
        buf.append("<TD class=\"infoL\">Ҥμࡧ</TD>");
        String text = null;
        if (book.getBookType() == Book.DISC_EB) {
            text = "EB/EBG/EBXA/EBXA-C/S-EBXA";
        } else if (book.getBookType() == Book.DISC_EPWING) {
            text = "EPWING V" + book.getVersion();
        } else {
            text = "unknown";
        }
        buf.append("<TD class=\"infoR\">").append(text).append("</TD></TR>");

        // ʸå
        buf.append("<TR class=\"").append(TRCLASS[tr]).append(" main\">");
        tr = (tr + 1) % 2;
        buf.append("<TD class=\"infoL\">ʸåȡ</TD>");
        switch (book.getCharCode()) {
            case Book.CHARCODE_ISO8859_1:
                text = "ISO 8859-1";
                break;
            case  Book.CHARCODE_JISX0208:
                text = "JIS X 0208";
                break;
            case Book.CHARCODE_JISX0208_GB2312:
                text = "JIS X 0208 + GB 2312";
                break;
            default:
                text = "unknown";
        }
        buf.append("<TD class=\"infoR\">").append(text).append("</TD></TR>");

        // 
        buf.append("<TR class=\"").append(TRCLASS[tr]).append(" main\">");
        tr = (tr + 1) % 2;
        buf.append("<TD class=\"infoL\" valign=\"top\"></TD>");
        StringBuffer list = new StringBuffer();
        if (_subs[idx].hasWordSearch()) {
            list.append("׸<BR>");
        }
        if (_subs[idx].hasEndwordSearch()) {
            list.append("׸<BR>");
        }
        if (_subs[idx].hasExactwordSearch()) {
            list.append("׸<BR>");
        }
        if (_subs[idx].hasKeywordSearch()) {
            list.append("︡<BR>");
        }
        if (_subs[idx].hasMultiSearch()) {
            list.append("ʣ縡<BR>");
        }
        if (_subs[idx].hasMenu()) {
            list.append("˥塼<BR>");
        }
        if (_subs[idx].hasCopyright()) {
            list.append("ɽ<BR>");
        }
        buf.append("<TD class=\"infoR\">").append(list).append("</TD></TR>");

        // 
        list.delete(0, list.length());
        for (int i=0; i<4; i++) {
            ExtFont font = _subs[idx].getFont(i);
            if (font.hasFont()) {
                list.append(Integer.toString(font.getFontHeight())).append(" ");
            }
        }
        if (list.length() > 0) {
            buf.append("<TR class=\"").append(TRCLASS[tr]).append(" main\">");
            tr = (tr + 1) % 2;
            buf.append("<TD class=\"infoL\" valign=\"top\"></TD>");
            buf.append("<TD class=\"infoR\">").append(list).append("</TD></TR>");
        }

        // Ⱦѳ
        ExtFont font = _subs[idx].getFont();
        if (font.hasNarrowFont()) {
            buf.append("<TR class=\"").append(TRCLASS[tr]).append(" main\">");
            tr = (tr + 1) % 2;
            buf.append("<TD class=\"infoL\" valign=\"top\">Ⱦѳɡ</TD>");
            list.delete(0, list.length());
            list.append("0x");
            int code = font.getNarrowFontStart();
            String hex = Integer.toHexString(code).toUpperCase();
            int len = 4 - hex.length();
            if (len > 0) {
                for (int j=0; j<len; j++) {
                    list.append('0');
                }
            }
            list.append(hex).append("  0x");
            code = font.getNarrowFontEnd();
            hex = Integer.toHexString(code).toUpperCase();
            len = 4 - hex.length();
            if (len > 0) {
                for (int j=0; j<len; j++) {
                    list.append('0');
                }
            }
            list.append(hex);
            try {
                list.append(" (<A href=\"detail.jsp?view=font&book=");
                list.append(URLEncoder.encode(_subs[idx].getName(), "UTF-8"));
                list.append("&type=narrow\" target=\"detailFrame\"></A>)");
            } catch (UnsupportedEncodingException e) {
            }
            buf.append("<TD class=\"infoR\">").append(list).append("</TD></TR>");
        }

        // ѳ
        if (font.hasWideFont()) {
            buf.append("<TR class=\"").append(TRCLASS[tr]).append(" main\">");
            tr = (tr + 1) % 2;
            buf.append("<TD class=\"infoL\" valign=\"top\">ѳɡ</TD>");
            list.delete(0, list.length());
            list.append("0x");
            int code = font.getWideFontStart();
            String hex = Integer.toHexString(code).toUpperCase();
            int len = 4 - hex.length();
            if (len > 0) {
                for (int j=0; j<len; j++) {
                    list.append('0');
                }
            }
            list.append(hex).append("  0x");
            code = font.getWideFontEnd();
            hex = Integer.toHexString(code).toUpperCase();
            len = 4 - hex.length();
            if (len > 0) {
                for (int j=0; j<len; j++) {
                    list.append('0');
                }
            }
            list.append(hex);
            try {
                list.append(" (<A href=\"detail.jsp?view=font&book=");
                list.append(URLEncoder.encode(_subs[idx].getName(), "UTF-8"));
                list.append("&type=wide\" target=\"detailFrame\"></A>)");
            } catch (UnsupportedEncodingException e) {
            }
            buf.append("<TD class=\"infoR\">").append(list).append("</TD></TR>");
        }

        // ʣ縡
        if (_subs[idx].hasMultiSearch()) {
            int count = _subs[idx].getMultiCount();
            for (int i=0; i<count; i++) {
                buf.append("<TR class=\"empty\"><TD colspan=\"2\"></TD></TR>");
                buf.append("<TR class=\"header main\">");
                buf.append("<TH colspan=\"2\" class=\"header\">");
                buf.append(_subs[idx].getMultiTitle(i));
                buf.append("</TH></TR>");

                int entryCount = _subs[idx].getMultiEntryCount(i);
                tr = 0;
                for (int j=0; j<entryCount; j++) {
                    buf.append("<TR class=\"").append(TRCLASS[tr]).append(" main\">");
                    tr = (tr + 1) % 2;
                    buf.append("<TD class=\"infoL\">");
                    buf.append("٥ ").append(Integer.toString(j+1)).append("<BR>");
                    buf.append("䡧");
                    buf.append("</TD>");
                    buf.append("<TD class=\"infoR\">");
                    buf.append(_subs[idx].getMultiEntryLabel(i, j)).append("<BR>");
                    if (_subs[idx].hasMultiEntryCandidate(i, j)) {
                        buf.append("ͭ");
                    } else {
                        buf.append("̵");
                    }
                    buf.append("</TD></TR>");
                }
            }
        }

        buf.append("</TABLE>");
        return buf.toString();
    }

    /**
     * ꥹȤ֤ޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param name оݤ̾
     * @param type 0:Ⱦ/1:
     * @return ꥹ
     */
    public String getFontList(String host, String name, int type) {
        int idx = _getSubBookIndex(host, name);
        if (idx < 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();

        // μ
        ExtFont font = _subs[idx].getFont();
        int start = -1;
        int end = -1;
        boolean narrow = true;
        if (type == 0) {
            if (font.hasNarrowFont()) {
                narrow = true;
                start = font.getNarrowFontStart();
                end = font.getNarrowFontEnd();
            }
        } else {
            if (font.hasWideFont()) {
                narrow = false;
                start = font.getWideFontStart();
                end = font.getWideFontEnd();
            }
        }
        if (start == -1 || end == -1) {
            return buf.toString();
        }

        String src = RES_DIR + _subs[idx].getName() + "/";
        String prefix = null;
        if (narrow) {
            prefix = "N";
        } else {
            prefix = "W";
        }
        prefix += Integer.toString(_subs[idx].getFont().getFontHeight());

        buf.append("<TABLE class=\"main\">");
        // ȥ
        String text = null;
        if (type == 0) {
            text = "Ⱦ";
        } else {
            text = "";
        }
        buf.append("<TR class=\"header main\">");
        buf.append("<TH colspan=\"8\" class=\"header\">");
        buf.append(text).append(" (");
        buf.append(_subs[idx].getTitle()).append(")");
        buf.append("</TH></TR>");

        int charcode = _subs[idx].getBook().getCharCode();
        int code = start & 0xfff8;
        int fore = _config.getForegroundColor().getRGB() | 0xff000000;
        int back = _config.getBackgroundColor().getRGB() | 0xff000000;
        String height = Integer.toString(_subs[idx].getFont().getFontHeight());
        String width = null;
        if (type == 0) {
            width = Integer.toString(_subs[idx].getFont().getNarrowFontWidth());
        } else {
            width = Integer.toString(_subs[idx].getFont().getWideFontWidth());
        }
        String alt;
        for (int i=code; i<=end; i+=8) {
            if (charcode != Book.CHARCODE_ISO8859_1
                && ((i & 0xff) < 0x20 || (i & 0xff) > 0x7f)) {
                continue;
            }
            buf.append("<TR class=\"odd main\">");
            for (int j=0; j<8; j++) {
                buf.append("<TD class=\"font1\">");
                code = i + j;
                if (code > end) {
                    alt = null;
                } else {
                    if (charcode == Book.CHARCODE_ISO8859_1
                        && ((code & 0xff) < 0x01 || (code & 0xff) > 0xfe)) {
                        alt = null;
                    } else if (charcode != Book.CHARCODE_ISO8859_1
                               && ((code & 0xff) < 0x21 || (code & 0xff) > 0x7e)) {
                        alt = null;
                    } else {
                        // ϥե̾
                        alt = prefix + "-" + Integer.toHexString(code).toUpperCase();
                    }
                }

                if (alt != null) {
                    buf.append("<IMG class=\"gaiji\" src=\"");
                    buf.append(src).append(alt);
                    buf.append("_F-");
                    buf.append(Integer.toHexString(fore).substring(2).toUpperCase());
                    buf.append("_B-");
                    buf.append(Integer.toHexString(back).substring(2).toUpperCase());
                    buf.append(".png\"");
                    buf.append(" width=\"").append(width).append("\"");
                    buf.append(" height=\"").append(height).append("\"");
                    buf.append(" alt=\"[").append(alt).append("]\">");
                }
                buf.append("</TD>");
            }
            buf.append("</TR>");
            buf.append("<TR class=\"even main\">");
            for (int j=0; j<8; j++) {
                buf.append("<TD class=\"font2\">");
                code = i + j;
                if (code <= end) {
                    if (charcode == Book.CHARCODE_ISO8859_1
                        && ((code & 0xff) < 0x01 || (code & 0xff) > 0xfe)) {
                    } else if (charcode != Book.CHARCODE_ISO8859_1
                               && ((code & 0xff) < 0x21 || (code & 0xff) > 0x7e)) {
                    } else {
                        // 
                        buf.append("0x").append(Integer.toHexString(code).toUpperCase());
                    }
                }
                buf.append("</TD>");
            }
            buf.append("</TR>");
        }

        buf.append("</TABLE>");
        return buf.toString();
    }
}

// end of WebBook.java
