package fuku.webbook;

import java.awt.Color;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * WebBookեɤ߹ߥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class WebBookConfig {

    /** ʿΥǥå */
    private static final int FOREGROUND = 0;
    /** طʿΥǥå */
    private static final int BACKGROUND = 1;
    /** ΥɽΥǥå */
    private static final int KEYWORD = 2;
    /** λɽΥǥå */
    private static final int ANCHOR = 3;

    /** Υǥեɽ */
    private static final Color[] DEF_COLOR = {
        Color.BLACK, Color.WHITE, Color.GREEN, Color.BLUE
    };

    /** ɽꥹ */
    private Color[] _colorList = null;

    /** ҥꥹ */
    private String[] _bookList = null;
    /** Ͽꥹ */
    private String[] _appendixList = null;
    /** ۥȥꥹ */
    private Hosts[] _hostsList = null;

    /** å */
    private static final int CACHE_GAIJI = 0;
    /** å */
    private static final int CACHE_IMAGE = 1;
    /** å */
    private static final int CACHE_SOUND = 2;
    /** å̵ͭ */
    private boolean[] _cache = new boolean[3];
    /** åǥ쥯ȥ */
    private File _cacheDir = null;
    /** URN쥯URL */
    private String _urn = null;


    /**
     * 󥹥ȥ饯
     *
     * @param url եURL
     * @param context ֥åȥƥ
     * @exception FactoryConfigurationError ѡեȥμѤǤʤ󥹥󥹲Ǥʤ
     * @exception IllegalArgumentException ѡեȥ꤬"http://java.sun.com/xml/jaxp/properties/schemaLanguage"°ǧʤ
     * @exception ParserConfigurationException DocumentBuilderǤʤ
     * @exception SAXException ʸϥ顼ȯ
     * @exception IOException ϥȯ
     */
    WebBookConfig(URL url, ServletContext context)
        throws ParserConfigurationException, SAXException, IOException {
        super();

        ArrayList list = new ArrayList(10);
        InputStream stream = null;
        try {
            stream = url.openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage",
                                 "http://www.w3.org/2001/XMLSchema");
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new NullHandler(context));
            String systemID = url.toString();
            String file = new File(url.getFile()).getName();
            int idx = systemID.indexOf(file);
            if (idx > 0) {
                systemID = systemID.substring(0, idx);
            }
            Document doc = builder.parse(stream, systemID);
            Node root = doc.getFirstChild();

            NamedNodeMap nmap;
            NodeList nlist;
            Node node1, node2;
            String tag;
            int i, j, num;

            NodeList nodes = root.getChildNodes();
            int len = nodes.getLength();
            for (i=0; i<len; i++) {
                node1 = nodes.item(i);
                if (node1.getNodeType() != Node.ELEMENT_NODE) {
                    continue;
                }
                if (node1.getNodeName().equals("book")) {
                    // ɤ߹
                    nlist = node1.getChildNodes();
                    num = nlist.getLength();
                    String[] val = new String[4];
                    for (j=0; j<num; j++) {
                        node2 = nlist.item(j);
                        if (node2.getNodeType() != Node.ELEMENT_NODE) {
                            continue;
                        }
                        tag = node2.getNodeName();
                        idx = -1;
                        if (tag.equals("data")) {
                            if (node2.hasAttributes()) {
                                nmap = node2.getAttributes();
                                node2 = nmap.getNamedItem("path");
                                val[0] = node2.getNodeValue();
                            }
                        } else if (tag.equals("appendix")) {
                            if (node2.hasAttributes()) {
                                nmap = node2.getAttributes();
                                node2 = nmap.getNamedItem("path");
                                val[1] = node2.getNodeValue();
                            }
                        } else if (tag.equals("hosts")) {
                            if (node2.hasAttributes()) {
                                nmap = node2.getAttributes();
                                node2 = nmap.getNamedItem("type");
                                val[2] = node2.getNodeValue();
                                node2 = nmap.getNamedItem("list");
                                val[3] = node2.getNodeValue();
                            }
                        }
                    }
                    if (val[0] != null) {
                        list.add(val);
                    }
                } else if (node1.getNodeName().equals("gaiji")) {
                    // ɽɤ߹
                    _colorList = new Color[DEF_COLOR.length];
                    nlist = node1.getChildNodes();
                    num = nlist.getLength();
                    for (j=0; j<num; j++) {
                        node2 = nlist.item(j);
                        if (node2.getNodeType() != Node.ELEMENT_NODE) {
                            continue;
                        }
                        tag = node2.getNodeName();
                        idx = -1;
                        if (tag.equals("foreground")) {
                            idx = FOREGROUND;
                        } else if (tag.equals("background")) {
                            idx = BACKGROUND;
                        } else if (tag.equals("keyword")) {
                            idx = KEYWORD;
                        } else if (tag.equals("anchor")) {
                            idx = ANCHOR;
                        }
                        if (idx >= 0 && node2.hasAttributes()) {
                            nmap = node2.getAttributes();
                            node2 = nmap.getNamedItem("color");
                            try {
                                String val = node2.getNodeValue();
                                _colorList[idx] = Color.decode(val);
                            } catch (NumberFormatException e) {
                            }
                        }
                    }
                } else if (node1.getNodeName().equals("cache")) {
                    // å
                    if (node1.hasAttributes()) {
                        nmap = node1.getAttributes();
                        num = nmap.getLength();
                        for (j=0; j<num; j++) {
                            node2 = nmap.item(j);
                            tag = node2.getNodeName();
                            idx = -1;
                            if (tag.equals("gaiji")) {
                                idx = CACHE_GAIJI;
                            } else if (tag.equals("image")) {
                                idx = CACHE_IMAGE;
                            } else if (tag.equals("sound")) {
                                idx = CACHE_SOUND;
                            }
                            if (idx >= 0) {
                                String val = node2.getNodeValue();
                                _cache[idx] = StringUtil.toBoolean(val);
                            }
                        }
                    }
                    nlist = node1.getChildNodes();
                    num = nlist.getLength();
                    for (j=0; j<num; j++) {
                        node2 = nlist.item(j);
                        if (node2.getNodeType() != Node.ELEMENT_NODE) {
                            continue;
                        }
                        tag = node2.getNodeName();
                        if (tag.equals("dir") && node2.hasAttributes()) {
                            nmap = node2.getAttributes();
                            node2 = nmap.getNamedItem("path");
                            String val = node2.getNodeValue();
                            _cacheDir = new File(val, "webbook");
                        }
                    }
                } else if (node1.getNodeName().equals("redirect")) {
                    nlist = node1.getChildNodes();
                    num = nlist.getLength();
                    for (j=0; j<num; j++) {
                        node2 = nlist.item(j);
                        if (node2.getNodeType() != Node.ELEMENT_NODE) {
                            continue;
                        }
                        tag = node2.getNodeName();
                        if (tag.equals("urn") && node2.hasAttributes()) {
                            nmap = node2.getAttributes();
                            node2 = nmap.getNamedItem("url");
                            _urn = node2.getNodeValue();
                        }
                    }
                }
            }
        } finally {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }

        if (!list.isEmpty()) {
            // ҥꥹȤν
            int len = list.size();
            _bookList = new String[len];
            _appendixList = new String[len];
            _hostsList = new Hosts[len];
            for (int i=0; i<len; i++) {
                String[] item = (String[])list.get(i);
                _bookList[i] = item[0];
                _appendixList[i] = item[1];
                if (item[2] != null && item[2].equals("allow")) {
                    _hostsList[i] = new Hosts(true, item[3]);
                } else {
                    _hostsList[i] = new Hosts(false, item[3]);
                }
            }
        }

        if (_cacheDir == null) {
            _cacheDir =
                new File(System.getProperty("java.io.tmpdir"), "webbook");
        }
    }


    /**
     * ҥꥹȤ֤ޤ
     *
     * @return ҥꥹ (ʤnull)
     */
    public String[] getBookList() {
        return _bookList;
    }

    /**
     * ϿꥹȤ֤ޤ
     *
     * @return Ͽꥹ (ʤnull)
     */
    public String[] getAppendixList() {
        return _appendixList;
    }

    /**
     * ꤵ줿ѥνҤؤΥĤƤ뤫ɤȽꤷޤ
     *
     * @param host ۥ̾ޤIPɥ쥹
     * @param path ҤΥѥ
     * @return ĤƤtrueǤʤfalse
     */
    public boolean isAllowed(String host, String path) {
        for (int i=0; i<_bookList.length; i++) {
            if (path.equals(_bookList[i])) {
                return _hostsList[i].isAllowed(host);
            }
        }
        return false;
    }

    /**
     * å̵֤ͭޤ
     *
     * @return å̵ͭ
     */
    public boolean isGaijiCache() {
        return _cache[CACHE_GAIJI];
    }

    /**
     * å̵֤ͭޤ
     *
     * @return å̵ͭ
     */
    public boolean isImageCache() {
        return _cache[CACHE_IMAGE];
    }

    /**
     * å̵֤ͭޤ
     *
     * @return å̵ͭ
     */
    public boolean isSoundCache() {
        return _cache[CACHE_SOUND];
    }

    /**
     * åǥ쥯ȥ֤ޤ
     *
     * @return åǥ쥯ȥ
     */
    public File getCacheDirectory() {
        return _cacheDir;
    }

    /**
     * ʿ֤ޤ
     *
     * @return ʿ
     */
    public Color getForegroundColor() {
        if (_colorList == null || _colorList[FOREGROUND] == null) {
            return DEF_COLOR[FOREGROUND];
        }
        return _colorList[FOREGROUND];
    }

    /**
     * طʿ֤ޤ
     *
     * @return طʿ
     */
    public Color getBackgroundColor() {
        if (_colorList == null || _colorList[BACKGROUND] == null) {
            return DEF_COLOR[BACKGROUND];
        }
        return _colorList[BACKGROUND];
    }

    /**
     * Υɽ֤ޤ
     *
     * @return Υɽ
     */
    public Color getKeywordColor() {
        if (_colorList == null || _colorList[KEYWORD] == null) {
            return DEF_COLOR[KEYWORD];
        }
        return _colorList[KEYWORD];
    }

    /**
     * Υ󥫡ɽ֤ޤ
     *
     * @return Υ󥫡ɽ
     */
    public Color getAnchorColor() {
        if (_colorList == null || _colorList[ANCHOR] == null) {
            return DEF_COLOR[ANCHOR];
        }
        return _colorList[ANCHOR];
    }

    /**
     * URN쥯URL֤ޤ
     *
     * @return URN쥯URL
     */
    public String getURNRedirectURL() {
        if (_urn == null) {
            return "";
        }
        return _urn;
    }


    /**
     * 顼ϥɥ顣
     *
     */
    private class NullHandler extends DefaultHandler {

        /** ֥åȥƥ */
        private ServletContext _context = null;


        /**
         * 󥹥ȥ饯
         *
         * @param context ֥åȥƥ
         */
        public NullHandler(ServletContext context) {
            super();
            _context = context;
        }


        /**
         * ǽʥ顼Τޤ
         *
         * @param exp SAXʸ㳰˥ץ벽줿顼
         * @exception SAXException SAX㳰
         */
        public void error(SAXParseException exp) throws SAXException {
            _context.log("[ERROR " + exp.getLineNumber()
                         + ":" + exp.getColumnNumber() + "] "
                         + exp.getMessage());
        }

        /**
         * ٹΤޤ
         *
         * @param exp SAXʸ㳰˥ץ벽줿顼
         * @exception SAXException SAX㳰
         */
        public void warning(SAXParseException exp) throws SAXException {
            _context.log("[WARNING " + exp.getLineNumber()
                         + ":" + exp.getColumnNumber() + "] "
                         + exp.getMessage());
        }

        /**
         * Ǥʤ顼Τޤ
         *
         * @param exp SAXʸ㳰˥ץ벽줿顼
         * @exception SAXException SAX㳰
         */
        public void fatal(SAXParseException exp) throws SAXException {
            _context.log("[FATAL " + exp.getLineNumber()
                         + ":" + exp.getColumnNumber() + "] "
                         + exp.getMessage());
        }
    }
}

// end of WebBookConfig.java
