package fuku.webbook;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import fuku.eb4j.SubBook;
import fuku.eb4j.Result;

/**
 * WebBook֥åȥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.4
 */
public final class WebBookServlet extends HttpServlet {

    /** ǥեȤʸå */
    private static final String CHARSET = "EUC-JP";


    /**
     * GETꥯȤν
     *
     * @param req 饤ȤΥꥯ
     * @param res 饤Ȥ֤쥹ݥ
     * @exception ServletException GETꥯȤǤʤ
     * @exception IOException GETꥯȤνϥ顼ȯ
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {
        doPost(req, res);
    }

    /**
     * POSTꥯȤν
     *
     * @param req 饤ȤΥꥯ
     * @param res 饤Ȥ֤쥹ݥ
     * @exception ServletException POSTꥯȤǤʤ
     * @exception IOException POSTꥯȤνϥ顼ȯ
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {

        // ֥åȥƥȤҴ֥ȼ
        WebBook webbook = (WebBook)getServletContext().getAttribute("webbook");

        req.setCharacterEncoding(CHARSET);
        HttpSession session = req.getSession(true);

        // 
        String act = req.getParameter("act");
        if (act == null) {
            act = "";
        }

        Result[][] results = null;
        try {
            if (act.equals("wordsearch")) {
                // ///︡
                String word = req.getParameter("word");
                String book = req.getParameter("book");
                int method = Integer.parseInt(req.getParameter("method"));
                // 򥯥å
                int max = 10;
                Cookie[] cookies = req.getCookies();
                if (cookies != null) {
                    int len = cookies.length;
                    for (int i=0; i<len; i++) {
                        if (cookies[i].getName().equals("webbook")) {
                            String v = cookies[i].getValue();
                            try {
                                max = Integer.parseInt(v.substring(1, 2)) * 10;
                            } catch (NumberFormatException e) {
                            } catch (IndexOutOfBoundsException e) {
                            }
                        }
                    }
                }
                if (word != null && word.trim().length() > 0) {
                    results = webbook.search(req.getRemoteHost(),
                                             book, word, method, max);
                }
            } else if (act.equals("multisearch")) {
                // ʣ縡
                String book = req.getParameter("book");
                int multi =  Integer.parseInt(req.getParameter("multi"));
                String host = req.getRemoteHost();
                SubBook sub = webbook.getSubBook(host, book);
                if (sub != null) {
                    int count = sub.getMultiEntryCount(multi);
                    ArrayList list = new ArrayList(count);
                    for (int i=0; i<count; i++) {
                        list.add(_convert(req.getParameter("key" + i)));
                    }
                    String[] keys = (String[])list.toArray(new String[0]);
                    results = webbook.search(host, book, multi, keys);
                }
            } else if (act.equals("preference")) {
                // 򥯥å¸
                StringBuffer val = new StringBuffer(4);
                val.append(req.getParameter("method"));
                val.append(req.getParameter("num"));
                val.append(req.getParameter("inline"));
                val.append(req.getParameter("applet"));
                Cookie cookie = new Cookie("webbook", val.toString());
                cookie.setMaxAge(Integer.MAX_VALUE);
                cookie.setSecure(false);
                res.addCookie(cookie);
            }
        } catch (NumberFormatException e) {
        }

        if (session != null) {
            session.setAttribute("results", results);
        }

        String target = req.getParameter("target");
        if (target == null) {
            target = "index.html";
        }
        req.getRequestDispatcher(target).forward(req, res);
    }

    /**
     * ʸ˴ޤޤ"[N-####]/[W-####]""\####"Ѵޤ
     *
     * @param str Ѵоʸ
     * @return Ѵʸ
     */
    private String _convert(String str) {
        if (str == null) {
            return new String();
        }
        StringBuffer buf = new StringBuffer(str);

        // Ⱦѳ
        int idx1 = buf.indexOf("[N-", 0);
        int idx2 = 0;
        while (idx1 >= 0) {
            buf.replace(idx1, idx1+3, "\\");
            idx2 = buf.indexOf("]", idx1+1);
            buf.deleteCharAt(idx2);
            idx1 = buf.indexOf("[N-", idx2+1);
        }

        // ѳ
        idx1 = buf.indexOf("[W-", 0);
        idx2 = 0;
        while (idx1 >= 0) {
            buf.replace(idx1, idx1+3, "\\");
            idx2 = buf.indexOf("]", idx1+1);
            buf.deleteCharAt(idx2);
            idx1 = buf.indexOf("[W-", idx2+1);
        }

        return buf.toString();
    }
}

// end of WebBookServlet.java
