/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;

public final class GraphicData {
    private static final int COLOR_GRAPHIC_HEADER = 8;
    private EBFile _file = null;

    GraphicData(EBFile file) {
        this._file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMonoGraphic(long pos, int width, int height) throws EBException {
        byte[] img = null;
        BookInputStream bis = this._file.getInputStream();
        try {
            byte[] b;
            if (width == 0 && height == 0) {
                b = new byte[22];
                bis.seek(pos);
                bis.readFully(b, 0, b.length);
                if (ByteUtil.getInt2(b, 0) != 8005 || ByteUtil.getInt2(b, 4) != 7985) {
                    throw new EBException(5, this._file.getPath());
                }
                width = ByteUtil.getBCD2(b, 8);
                height = ByteUtil.getBCD2(b, 10);
                if (ByteUtil.getInt2(b, 12) == 8017) {
                    pos = BookInputStream.getPosition(ByteUtil.getBCD4(b, 14), ByteUtil.getBCD2(b, 18));
                } else if (ByteUtil.getInt2(b, 14) == 8017) {
                    pos = BookInputStream.getPosition(ByteUtil.getBCD4(b, 16), ByteUtil.getBCD2(b, 20));
                } else {
                    throw new EBException(5, this._file.getPath());
                }
            }
            if (width <= 0 || height <= 0) {
                b = null;
                return b;
            }
            bis.seek(pos);
            int size = (width + 7) / 8 * height;
            img = new byte[size];
            bis.readFully(img, 0, img.length);
        }
        finally {
            bis.close();
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getColorGraphic(long pos) throws EBException {
        byte[] img = null;
        BookInputStream bis = this._file.getInputStream();
        try {
            bis.seek(pos);
            byte[] b = new byte[8];
            bis.readFully(b, 0, b.length);
            int size = 0;
            if (new String(b, 0, 4).equals("data")) {
                size = (int)ByteUtil.getLongLE4(b, 4);
            }
            img = new byte[size];
            bis.readFully(img, 0, img.length);
        }
        finally {
            bis.close();
        }
        return img;
    }
}

