/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.Book;
import fuku.eb4j.EBException;
import fuku.eb4j.ExtFont;
import fuku.eb4j.GraphicData;
import fuku.eb4j.IndexStyle;
import fuku.eb4j.MultiWordSearcher;
import fuku.eb4j.NullSearcher;
import fuku.eb4j.Searcher;
import fuku.eb4j.SingleWordSearcher;
import fuku.eb4j.SoundData;
import fuku.eb4j.SubAppendix;
import fuku.eb4j.hook.Hook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.BookReader;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;
import java.io.File;
import java.util.ArrayList;

public final class SubBook {
    private static final int SIZE_MULTI_LABEL = 30;
    private static final int SIZE_MULTI_TITLE = 32;
    private static final int KANA = 0;
    private static final int KANJI = 1;
    private static final int ALPHABET = 2;
    private Book _book = null;
    private SubAppendix _appendix = null;
    private String _name = null;
    private File _movieDir = null;
    private EBFile _text = null;
    private EBFile _graphic = null;
    private EBFile _sound = null;
    private int _indexPage = 0;
    private long _titlePage = 0L;
    private String _title = null;
    private ExtFont[] _fonts = new ExtFont[4];
    private int _fontIndex = -1;
    private IndexStyle _textStyle = null;
    private IndexStyle _soundStyle = null;
    private IndexStyle[] _wordStyle = new IndexStyle[3];
    private IndexStyle[] _endwordStyle = new IndexStyle[3];
    private IndexStyle _keywordStyle = null;
    private IndexStyle[] _multiStyle = null;
    private IndexStyle[][] _entryStyle = null;
    private IndexStyle _menuStyle = null;
    private IndexStyle _copyrightStyle = null;

    SubBook(Book book, String title, String path, int index, String[] fname, int[] format, String[] narrow, String[] wide) throws EBException {
        int i;
        this._book = book;
        this._title = title;
        this._indexPage = index;
        if (this._book.getBookType() == 0) {
            this._setupEB(path, fname, format);
        } else {
            this._setupEPWING(path, fname, format, narrow, wide);
        }
        this._load();
        int len = this._fonts.length;
        for (i = 0; i < len; ++i) {
            if (!this._fonts[i].hasNarrowFont() || !this._fonts[i].hasWideFont()) continue;
            this._fontIndex = i;
            break;
        }
        if (this._fontIndex < 0) {
            this._fontIndex = 0;
            for (i = 0; i < len; ++i) {
                if (!this._fonts[i].hasFont()) continue;
                this._fontIndex = i;
                break;
            }
        }
    }

    private void _setupEB(String path, String[] fname, int[] format) throws EBException {
        File dir = EBFile.searchDirectory(this._book.getPath(), path);
        this._name = dir.getName();
        this._graphic = this._text = new EBFile(dir, fname[0], format[0]);
    }

    private void _setupEPWING(String path, String[] fname, int[] format, String[] narrow, String[] wide) throws EBException {
        File dir = EBFile.searchDirectory(this._book.getPath(), path);
        this._name = dir.getName();
        File dataDir = EBFile.searchDirectory(dir, "data");
        this._text = new EBFile(dataDir, fname[0], format[0]);
        if (fname[1] != null) {
            try {
                this._graphic = new EBFile(dataDir, fname[1], format[1]);
            }
            catch (EBException e2) {}
        } else {
            this._graphic = this._text;
        }
        if (fname[2] != null) {
            try {
                this._sound = new EBFile(dataDir, fname[2], format[2]);
            }
            catch (EBException e2) {}
        } else {
            this._sound = this._text;
        }
        File gaijiDir = null;
        try {
            gaijiDir = EBFile.searchDirectory(dir, "gaiji");
        }
        catch (EBException e) {
            // empty catch block
        }
        EBFile file = null;
        int len = this._fonts.length;
        for (int i = 0; i < len; ++i) {
            this._fonts[i] = new ExtFont(this, i);
            if (gaijiDir == null) continue;
            if (narrow[i] != null) {
                file = new EBFile(gaijiDir, narrow[i], 0);
                this._fonts[i].setNarrowFont(file, 1L);
            }
            if (wide[i] == null) continue;
            file = new EBFile(gaijiDir, wide[i], 0);
            this._fonts[i].setWideFont(file, 1L);
        }
        try {
            this._movieDir = EBFile.searchDirectory(dir, "movie");
        }
        catch (EBException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() throws EBException {
        byte[] b = new byte[2048];
        BookInputStream bis = this._text.getInputStream();
        try {
            bis.seek(this._indexPage, 0);
            bis.readFully(b, 0, b.length);
        }
        finally {
            bis.close();
        }
        int indexCount = b[1] & 0xFF;
        if (indexCount >= 127) {
            throw new EBException(5, this._text.getPath());
        }
        int avail1 = b[4] & 0xFF;
        if (avail1 > 2) {
            avail1 = 0;
        }
        int len = this._fonts.length;
        long[][] fontPage = new long[len][2];
        for (int i = 0; i < len; ++i) {
            fontPage[i][0] = -1L;
            fontPage[i][1] = -1L;
        }
        IndexStyle[] sebxa = new IndexStyle[2];
        ArrayList<IndexStyle> multi = new ArrayList<IndexStyle>(indexCount);
        int i = 0;
        int off = 16;
        while (i < indexCount) {
            IndexStyle style = new IndexStyle();
            int id = b[off] & 0xFF;
            style.setIndexID(id);
            style.setStartPage(ByteUtil.getLong4(b, off + 2));
            style.setEndPage(style.getStartPage() + ByteUtil.getLong4(b, off + 6) - 1L);
            if (this._book.getCharCode() == 1 || id == 114 || id == 146) {
                style.setSpaceStyle(1);
            }
            int avail2 = b[off + 10] & 0xFF;
            if (avail1 == 0 && avail2 == 2 || avail1 == 2) {
                int flag = ByteUtil.getInt3(b, off + 11);
                style.setKatakanaStyle((flag & 0xC00000) >>> 22);
                style.setLowerStyle((flag & 0x300000) >>> 20);
                if ((flag & 0xC0000) >>> 18 == 0) {
                    style.setMarkStyle(2);
                } else {
                    style.setMarkStyle(1);
                }
                style.setLongVowelStyle((flag & 0x30000) >>> 16);
                style.setDoubleConsonantStyle((flag & 0xC000) >>> 14);
                style.setContractedSoundStyle((flag & 0x3000) >>> 12);
                style.setSmallVowelStyle((flag & 0xC00) >>> 10);
                style.setVoicedConsonantStyle((flag & 0x300) >>> 8);
                style.setPSoundStyle((flag & 0xC0) >>> 6);
            } else if (id == 112 || id == 144) {
                style.setKatakanaStyle(0);
                style.setLowerStyle(0);
                style.setMarkStyle(2);
                style.setLongVowelStyle(0);
                style.setDoubleConsonantStyle(0);
                style.setContractedSoundStyle(0);
                style.setSmallVowelStyle(0);
                style.setVoicedConsonantStyle(0);
                style.setPSoundStyle(0);
            } else {
                style.setKatakanaStyle(1);
                style.setLowerStyle(0);
                style.setMarkStyle(1);
                style.setLongVowelStyle(1);
                style.setDoubleConsonantStyle(1);
                style.setContractedSoundStyle(1);
                style.setSmallVowelStyle(1);
                style.setVoicedConsonantStyle(1);
                style.setPSoundStyle(1);
            }
            switch (style.getIndexID()) {
                case 0: {
                    this._textStyle = style;
                    break;
                }
                case 1: {
                    this._menuStyle = style;
                    break;
                }
                case 2: {
                    this._copyrightStyle = style;
                    break;
                }
                case 22: {
                    if (this._book.getBookType() != 1) break;
                    this._titlePage = style.getStartPage();
                    break;
                }
                case 33: {
                    if (this._book.getBookType() != 0) break;
                    sebxa[1] = style;
                    break;
                }
                case 34: {
                    if (this._book.getBookType() != 0) break;
                    sebxa[0] = style;
                    break;
                }
                case 112: 
                case 113: 
                case 114: {
                    int idx = style.getIndexID() % 112;
                    this._endwordStyle[idx] = style;
                    break;
                }
                case 128: {
                    this._keywordStyle = style;
                    break;
                }
                case 144: 
                case 145: 
                case 146: {
                    int idx = style.getIndexID() % 144;
                    this._wordStyle[idx] = style;
                    break;
                }
                case 216: {
                    this._soundStyle = style;
                    break;
                }
                case 241: {
                    if (this._book.getBookType() != 0) break;
                    fontPage[0][0] = style.getStartPage();
                    break;
                }
                case 242: {
                    if (this._book.getBookType() != 0) break;
                    fontPage[0][1] = style.getStartPage();
                    break;
                }
                case 243: {
                    if (this._book.getBookType() != 0) break;
                    fontPage[1][0] = style.getStartPage();
                    break;
                }
                case 244: {
                    if (this._book.getBookType() != 0) break;
                    fontPage[1][1] = style.getStartPage();
                    break;
                }
                case 245: {
                    if (this._book.getBookType() != 0) break;
                    fontPage[2][0] = style.getStartPage();
                    break;
                }
                case 246: {
                    if (this._book.getBookType() != 0) break;
                    fontPage[2][1] = style.getStartPage();
                    break;
                }
                case 247: {
                    if (this._book.getBookType() != 0) break;
                    fontPage[3][0] = style.getStartPage();
                    break;
                }
                case 248: {
                    if (this._book.getBookType() != 0) break;
                    fontPage[3][1] = style.getStartPage();
                    break;
                }
                case 255: {
                    multi.add(style);
                    break;
                }
            }
            ++i;
            off += 16;
        }
        if (!multi.isEmpty()) {
            this._multiStyle = multi.toArray(new IndexStyle[0]);
            this._loadMulti();
            this._loadMultiTitle();
        }
        if (this._book.getBookType() == 0) {
            if (this._text.getFormat() == 0 && sebxa[0] != null && sebxa[1] != null && this._textStyle.getStartPage() != 0L && sebxa[0].getStartPage() != 0L && sebxa[1].getStartPage() != 0L) {
                long index = (sebxa[0].getStartPage() - 1L) * 2048L;
                long base = (sebxa[1].getStartPage() - 1L) * 2048L;
                long start = (this._textStyle.getStartPage() - 1L) * 2048L;
                long end = this._textStyle.getEndPage() * 2048L - 1L;
                this._text.setSEBXAInfo(index, base, start, end);
            }
            for (i = 0; i < len; ++i) {
                this._fonts[i] = new ExtFont(this, i);
                long page = fontPage[i][0];
                if (page < 0L) {
                    this._fonts[i].setWideFont(this._text, page);
                }
                if ((page = fontPage[i][1]) >= 0L) continue;
                this._fonts[i].setNarrowFont(this._text, page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadMulti() throws EBException {
        int len = this._multiStyle.length;
        this._entryStyle = new IndexStyle[len][];
        ArrayList<IndexStyle> list = new ArrayList<IndexStyle>(len * 4);
        byte[] b = new byte[2048];
        BookInputStream bis = this._text.getInputStream();
        try {
            for (int i = 0; i < len; ++i) {
                bis.seek(this._multiStyle[i].getStartPage(), 0);
                bis.readFully(b, 0, b.length);
                int entryCount = ByteUtil.getInt2(b, 0);
                if (entryCount <= 0) {
                    throw new EBException(5, this._text.getPath());
                }
                int off = 16;
                for (int j = 0; j < entryCount; ++j) {
                    IndexStyle style = new IndexStyle();
                    style.setSpaceStyle(1);
                    style.setKatakanaStyle(1);
                    style.setLowerStyle(1);
                    style.setMarkStyle(1);
                    style.setLongVowelStyle(1);
                    style.setDoubleConsonantStyle(1);
                    style.setContractedSoundStyle(1);
                    style.setVoicedConsonantStyle(1);
                    style.setSmallVowelStyle(1);
                    style.setPSoundStyle(1);
                    int indexCount = b[off] & 0xFF;
                    String label = ByteUtil.jisx0208ToString(b, off + 2, 30);
                    style.setLabel(label);
                    off += 32;
                    for (int k = 0; k < indexCount; ++k) {
                        int indexID = b[off] & 0xFF;
                        long page = ByteUtil.getLong4(b, off + 2);
                        switch (indexID) {
                            case 113: 
                            case 145: 
                            case 161: {
                                if (style.getStartPage() != 0L && style.getIndexID() != 113) break;
                                style.setIndexID(indexID);
                                style.setStartPage(page);
                                style.setEndPage(page += ByteUtil.getLong4(b, off + 6) - 1L);
                                break;
                            }
                            case 1: {
                                style.setIndexID(indexID);
                                style.setCandidatePage(page);
                                break;
                            }
                        }
                        off += 16;
                    }
                    list.add(style);
                }
                this._entryStyle[i] = list.toArray(new IndexStyle[0]);
                list.clear();
            }
        }
        finally {
            bis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadMultiTitle() throws EBException {
        String num;
        int i;
        int len = this._multiStyle.length;
        if (this._book.getCharCode() == 1) {
            for (i = 0; i > len; ++i) {
                num = Integer.toString(i + 1);
                this._multiStyle[i].setLabel("Multi search " + num);
            }
        } else {
            for (i = 0; i < len; ++i) {
                num = ByteUtil.narrowToWide(Integer.toString(i + 1));
                this._multiStyle[i].setLabel("\u8907\u5408\u691c\u7d22" + num);
            }
        }
        if (this._book.getBookType() != 1 || this._titlePage == 0L) {
            return;
        }
        byte[] b = new byte[2048];
        BookInputStream bis = this._text.getInputStream();
        try {
            bis.seek(this._titlePage, 0);
            bis.readFully(b, 0, b.length);
        }
        finally {
            bis.close();
        }
        int titleCount = ByteUtil.getInt2(b, 0);
        if (titleCount > this._multiStyle.length + 4) {
            titleCount = this._multiStyle.length + 4;
        }
        int off = 350;
        for (int i2 = 4; i2 < titleCount; ++i2) {
            if (ByteUtil.getInt2(b, off) != 2) continue;
            String title = ByteUtil.jisx0208ToString(b, off + 18, 32);
            this._multiStyle[i2 - 4].setLabel(title);
            off += 70;
        }
    }

    public Book getBook() {
        return this._book;
    }

    void setAppendix(SubAppendix appendix) {
        this._appendix = appendix;
    }

    public SubAppendix getSubAppendix() {
        return this._appendix;
    }

    public String getTitle() {
        return this._title;
    }

    public String getName() {
        return this._name;
    }

    public ExtFont getFont() {
        return this._fonts[this._fontIndex];
    }

    public ExtFont getFont(int type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Illegal font type: " + Integer.toString(type));
        }
        return this._fonts[type];
    }

    public void setFont(int type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Illegal font type: " + Integer.toString(type));
        }
        this._fontIndex = type;
    }

    public GraphicData getGraphicData() {
        return new GraphicData(this._graphic);
    }

    public SoundData getSoundData() {
        return new SoundData(this._sound, this._soundStyle);
    }

    public EBFile getTextFile() {
        return this._text;
    }

    public EBFile getGraphicFile() {
        return this._graphic;
    }

    public EBFile getSoundFile() {
        return this._sound;
    }

    public File[] getMovieFileList() {
        if (this._movieDir == null) {
            return null;
        }
        return this._movieDir.listFiles();
    }

    public File getMovieFile(String name) {
        if (this._movieDir == null) {
            return null;
        }
        File file = null;
        try {
            EBFile ebfile = new EBFile(this._movieDir, name, 0);
            file = ebfile.getFile();
        }
        catch (EBException eBException) {
            // empty catch block
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getHeading(long pos, Hook hook) throws EBException {
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            obj = reader.readHeading(pos);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextHeadingPosition(long pos) throws EBException {
        BookReader reader = null;
        long nextPos = 0L;
        try {
            reader = new BookReader(this, null);
            nextPos = reader.nextHeadingPosition(pos);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return nextPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getText(long pos, Hook hook) throws EBException {
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            obj = reader.readText(pos);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getMenu(Hook hook) throws EBException {
        if (!this.hasMenu()) {
            return null;
        }
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            obj = reader.readText(this._menuStyle.getStartPage(), 0);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCopyright(Hook hook) throws EBException {
        if (!this.hasCopyright()) {
            return null;
        }
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            obj = reader.readText(this._copyrightStyle.getStartPage(), 0);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    private int _getWordType(byte[] b) {
        boolean alphabet = false;
        boolean kana = false;
        boolean kanji = false;
        int len = b.length;
        for (int i = 0; i < len; i += 2) {
            if (b[i] == 35) {
                alphabet = true;
                continue;
            }
            if (b[i] == 36 || b[i] == 37) {
                kana = true;
                continue;
            }
            if (b[i] == 33) continue;
            kanji = true;
        }
        if (alphabet && !kana && !kanji) {
            return 2;
        }
        if (!alphabet && kana && !kanji) {
            return 0;
        }
        return 1;
    }

    public Searcher searchExactword(String word) throws EBException {
        if (!this.hasWordSearch() || word == null || word.trim().length() <= 0) {
            return new NullSearcher();
        }
        byte[] b = null;
        int type = 2;
        if (this._book.getCharCode() == 1) {
            b = word.getBytes();
        } else {
            b = ByteUtil.stringToJISX0208(word);
            type = this._getWordType(b);
            if (this._wordStyle[type] == null) {
                type = 1;
            }
        }
        SingleWordSearcher searcher = new SingleWordSearcher(this, this._wordStyle[type], 2);
        searcher.search(b);
        return searcher;
    }

    public Searcher searchWord(String word) throws EBException {
        if (!this.hasWordSearch() || word == null || word.trim().length() <= 0) {
            return new NullSearcher();
        }
        byte[] b = null;
        int type = 2;
        if (this._book.getCharCode() == 1) {
            b = word.trim().getBytes();
        } else {
            b = ByteUtil.stringToJISX0208(word);
            type = this._getWordType(b);
            if (this._wordStyle[type] == null) {
                type = 1;
            }
        }
        SingleWordSearcher searcher = new SingleWordSearcher(this, this._wordStyle[type], 0);
        searcher.search(b);
        return searcher;
    }

    public Searcher searchEndword(String word) throws EBException {
        if (!this.hasEndwordSearch() || word == null || word.trim().length() <= 0) {
            return new NullSearcher();
        }
        byte[] b = null;
        int type = 2;
        if (this._book.getCharCode() == 1) {
            b = word.trim().getBytes();
        } else {
            b = ByteUtil.stringToJISX0208(word);
            type = this._getWordType(b);
            if (this._wordStyle[type] == null) {
                type = 1;
            }
        }
        SingleWordSearcher searcher = new SingleWordSearcher(this, this._endwordStyle[type], 1);
        searcher.search(b);
        return searcher;
    }

    public Searcher searchKeyword(String[] word) throws EBException {
        int i;
        if (!this.hasKeywordSearch()) {
            return new NullSearcher();
        }
        int len = word.length;
        byte[][] b = new byte[len][];
        if (this._book.getCharCode() == 1) {
            for (i = 0; i < len; ++i) {
                b[i] = word[i].trim().getBytes();
            }
        } else {
            for (i = 0; i < len; ++i) {
                b[i] = ByteUtil.stringToJISX0208(word[i]);
            }
        }
        MultiWordSearcher searcher = new MultiWordSearcher(this, this._keywordStyle);
        searcher.search(b);
        return searcher;
    }

    public Searcher searchMulti(int multiIndex, String[] word) throws EBException {
        if (!this.hasMultiSearch()) {
            return new NullSearcher();
        }
        int len = word.length;
        if (multiIndex < 0 || multiIndex >= this._multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: " + Integer.toString(multiIndex));
        }
        if (this._entryStyle[multiIndex].length < len) {
            throw new IllegalArgumentException("Too many words: " + Integer.toString(len));
        }
        byte[][] b = new byte[len][];
        ArrayList<byte[]> list = new ArrayList<byte[]>(4);
        for (int i = 0; i < len; ++i) {
            int j;
            list.clear();
            String key = word[i].trim();
            int length = key.length();
            int size = 0;
            int idx1 = 0;
            int idx2 = key.indexOf(92, 0);
            String str = null;
            byte[] tmp = null;
            while (idx2 >= 0) {
                int idx3;
                if (idx1 < idx2) {
                    str = key.substring(idx1, idx2);
                    tmp = this._book.getCharCode() == 1 ? str.getBytes() : ByteUtil.stringToJISX0208(str);
                    size += tmp.length;
                    list.add(tmp);
                }
                if ((idx3 = idx2 + 5) > length) {
                    idx3 = length;
                }
                str = key.substring(idx2 + 1, idx3);
                int code = -1;
                for (j = 4; j > 0; --j) {
                    try {
                        code = Integer.parseInt(str, 16);
                        idx1 = idx2 + 1 + j;
                        break;
                    }
                    catch (NumberFormatException e) {
                        str = str.substring(0, j - 1);
                        continue;
                    }
                }
                if (code >= 0) {
                    tmp = new byte[]{(byte)(code >>> 8 & 0xFF), (byte)(code & 0xFF)};
                } else {
                    tmp = new byte[]{92};
                    idx1 = idx2 + 1;
                }
                size += tmp.length;
                list.add(tmp);
                idx2 = key.indexOf(92, idx1);
            }
            if (idx1 < length) {
                str = key.substring(idx1, length);
                tmp = this._book.getCharCode() == 1 ? str.getBytes() : ByteUtil.stringToJISX0208(str);
                size += tmp.length;
                list.add(tmp);
            }
            b[i] = new byte[size];
            int pos = 0;
            int num = list.size();
            for (j = 0; j < num; ++j) {
                tmp = (byte[])list.get(j);
                System.arraycopy(tmp, 0, b[i], pos, tmp.length);
                pos += tmp.length;
            }
        }
        MultiWordSearcher searcher = new MultiWordSearcher(this, this._multiStyle[multiIndex], this._entryStyle[multiIndex]);
        searcher.search(b);
        return searcher;
    }

    public boolean hasMenu() {
        return this._menuStyle != null && this._menuStyle.getStartPage() != 0L;
    }

    public boolean hasCopyright() {
        return this._copyrightStyle != null && this._copyrightStyle.getStartPage() != 0L;
    }

    public boolean hasExactwordSearch() {
        return this.hasWordSearch();
    }

    public boolean hasWordSearch() {
        if (this._wordStyle == null) {
            return false;
        }
        int len = this._wordStyle.length;
        for (int i = 0; i < len; ++i) {
            if (this._wordStyle[i] == null || this._wordStyle[i].getStartPage() <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean hasEndwordSearch() {
        if (this._endwordStyle == null) {
            return false;
        }
        int len = this._endwordStyle.length;
        for (int i = 0; i < len; ++i) {
            if (this._endwordStyle[i] == null || this._endwordStyle[i].getStartPage() <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean hasKeywordSearch() {
        return this._keywordStyle != null && this._keywordStyle.getStartPage() != 0L;
    }

    public boolean hasMultiSearch() {
        return this._multiStyle != null;
    }

    public int getMultiCount() {
        if (this._multiStyle == null) {
            return 0;
        }
        return this._multiStyle.length;
    }

    public String getMultiTitle(int multiIndex) {
        if (this._multiStyle == null) {
            return null;
        }
        if (multiIndex < 0 || multiIndex >= this._multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: " + Integer.toString(multiIndex));
        }
        return this._multiStyle[multiIndex].getLabel();
    }

    public int getMultiEntryCount(int multiIndex) {
        if (this._multiStyle == null) {
            return 0;
        }
        if (multiIndex < 0 || multiIndex >= this._multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: " + Integer.toString(multiIndex));
        }
        return this._entryStyle[multiIndex].length;
    }

    public String getMultiEntryLabel(int multiIndex, int entryIndex) {
        if (this._multiStyle == null || this._entryStyle == null) {
            return null;
        }
        if (multiIndex < 0 || multiIndex >= this._multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: " + Integer.toString(multiIndex));
        }
        if (entryIndex < 0 || entryIndex >= this._entryStyle[multiIndex].length) {
            throw new IllegalArgumentException("Illegal entry index: " + Integer.toString(entryIndex));
        }
        return this._entryStyle[multiIndex][entryIndex].getLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCandidate(int multiIndex, int entryIndex, Hook hook) throws EBException {
        if (!this.hasMultiEntryCandidate(multiIndex, entryIndex)) {
            return null;
        }
        BookReader reader = null;
        Object obj = null;
        try {
            reader = new BookReader(this, hook);
            long page = this._entryStyle[multiIndex][entryIndex].getCandidatePage();
            obj = reader.readText(page, 0);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    public boolean hasMultiEntryCandidate(int multiIndex, int entryIndex) {
        if (this._multiStyle == null || this._entryStyle == null) {
            return false;
        }
        if (multiIndex < 0 || multiIndex >= this._multiStyle.length) {
            throw new IllegalArgumentException("Illegal multi index: " + Integer.toString(multiIndex));
        }
        if (entryIndex < 0 || entryIndex >= this._entryStyle[multiIndex].length) {
            throw new IllegalArgumentException("Illegal entry index: " + Integer.toString(entryIndex));
        }
        return this._entryStyle[multiIndex][entryIndex].getCandidatePage() > 0L;
    }

    public String toString() {
        return this.getTitle();
    }
}

