/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.hook;

import fuku.eb4j.EBException;
import fuku.eb4j.SubAppendix;
import fuku.eb4j.SubBook;
import fuku.eb4j.hook.HookAdapter;
import fuku.eb4j.util.ByteUtil;

public class DefaultHook
extends HookAdapter {
    private int _maxLine = 500;
    private boolean _narrow = false;
    private int _line = 0;
    private StringBuffer _buf = new StringBuffer(2048);
    private SubAppendix _appendix = null;

    public DefaultHook(SubBook sub) {
        this(sub, 500);
    }

    public DefaultHook(SubBook sub, int maxLine) {
        this._appendix = sub.getSubAppendix();
        this._maxLine = maxLine;
    }

    public void clear() {
        this._buf.delete(0, this._buf.length());
        this._narrow = false;
        this._line = 0;
    }

    public Object getObject() {
        return this._buf.toString();
    }

    public boolean isMoreInput() {
        return this._line < this._maxLine;
    }

    public void append(String str) {
        if (this._narrow) {
            str = ByteUtil.wideToNarrow(str);
        }
        this._buf.append(str);
    }

    public void append(int code) {
        String str = null;
        if (this._narrow) {
            if (this._appendix != null) {
                try {
                    str = this._appendix.getNarrowFontAlt(code);
                }
                catch (EBException e) {
                    // empty catch block
                }
            }
            if (str == null) {
                str = "[GAIJI=n" + Integer.toHexString(code).toUpperCase() + "]";
            }
        } else {
            if (this._appendix != null) {
                try {
                    str = this._appendix.getWideFontAlt(code);
                }
                catch (EBException eBException) {
                    // empty catch block
                }
            }
            if (str == null) {
                str = "[GAIJI=w" + Integer.toHexString(code).toUpperCase() + "]";
            }
        }
        this._buf.append(str);
    }

    public void beginNarrow() {
        this._narrow = true;
    }

    public void endNarrow() {
        this._narrow = false;
    }

    public void newLine() {
        this._buf.append('\n');
        ++this._line;
    }
}

