/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.FileInfo;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class BookInputStream {
    public static final int PAGE_SIZE = 2048;
    protected FileInfo _info = null;
    protected RandomAccessFile _stream = null;
    protected long _filePos = 0L;
    protected byte[] _cache = null;
    protected long _cachePos = -1L;

    BookInputStream(FileInfo info) {
        this._info = info;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public final long getFileSize() {
        return this._info.fileSize;
    }

    public final long getRealFileSize() {
        return this._info.realFileSize;
    }

    public final int getSliceSize() {
        return this._info.sliceSize;
    }

    protected void initFileInfo() throws EBException {
    }

    protected final void open() throws EBException {
        if (this._stream != null) {
            this.close();
        }
        try {
            this._stream = new RandomAccessFile(this._info.file, "r");
        }
        catch (FileNotFoundException e) {
            EBException exp = new EBException(2, this._info.file.getPath());
            exp.setStackTrace(e.getStackTrace());
            throw exp;
        }
        this._filePos = 0L;
    }

    public final void close() {
        if (this._stream != null) {
            try {
                this._stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final void readFully(byte[] b) throws EBException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws EBException {
        int rlen = len;
        int offset = off;
        while (rlen > 0) {
            int n = this.read(b, offset, rlen);
            if (n == -1) {
                throw new EBException(4, this._info.file.getPath());
            }
            rlen -= n;
            offset += n;
        }
    }

    public final int read(byte[] b) throws EBException {
        return this.read(b, 0, b.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws EBException;

    public final void seek(long page, int offset) {
        this.seek(BookInputStream.getPosition(page, offset));
    }

    public final void seek(long pos) {
        this._filePos = pos < 0L ? 0L : (pos > this._info.fileSize ? this._info.fileSize : pos);
    }

    protected final int readRaw(byte[] b) throws EBException {
        return this.readRaw(b, 0, b.length);
    }

    protected final int readRaw(byte[] b, int off, int len) throws EBException {
        int ret = -1;
        try {
            ret = this._stream.read(b, off, len);
        }
        catch (IOException e) {
            throw new EBException(4, this._info.file.getPath(), e);
        }
        return ret;
    }

    protected final void readRawFully(byte[] b) throws EBException {
        this.readRawFully(b, 0, b.length);
    }

    protected final void readRawFully(byte[] b, int off, int len) throws EBException {
        try {
            this._stream.readFully(b, off, len);
        }
        catch (EOFException e) {
            throw new EBException(4, this._info.file.getPath(), e);
        }
        catch (IOException e) {
            throw new EBException(4, this._info.file.getPath(), e);
        }
    }

    public static final long getPosition(long page, int offset) {
        return (page - 1L) * 2048L + (long)offset;
    }

    public static final long getPage(long pos) {
        return pos / 2048L + 1L;
    }

    public static final int getOffset(long pos) {
        return (int)(pos % 2048L);
    }
}

