/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBZipInputStream;
import fuku.eb4j.io.EPWINGInputStream;
import fuku.eb4j.io.FileInfo;
import fuku.eb4j.io.PlainInputStream;
import fuku.eb4j.io.SEBXAInputStream;
import java.io.File;

public final class EBFile {
    public static final int FORMAT_PLAIN = 0;
    public static final int FORMAT_EBZIP = 1;
    public static final int FORMAT_EPWING = 2;
    public static final int FORMAT_EPWING6 = 3;
    public static final int FORMAT_SEBXA = 4;
    private FileInfo _info = new FileInfo();
    private String _name = null;

    public EBFile(File parent, String name, int defaultFormat) throws EBException {
        String ebzName = name + ".ebz";
        String orgName = name + ".org";
        String[] list = parent.list();
        if (list != null) {
            int len = list.length;
            for (int i = 0; i < len; ++i) {
                File f = new File(parent, list[i]);
                if (f.isDirectory()) continue;
                if (list[i].compareToIgnoreCase(name) == 0) {
                    this._info.file = f;
                    this._info.format = defaultFormat;
                    this._name = list[i];
                    break;
                }
                if (list[i].compareToIgnoreCase(orgName) == 0) {
                    this._info.file = f;
                    this._info.format = 0;
                    this._name = list[i].substring(0, list[i].length() - 4);
                    break;
                }
                if (list[i].compareToIgnoreCase(ebzName) != 0) continue;
                this._info.file = f;
                this._info.format = 1;
                this._name = list[i].substring(0, list[i].length() - 4);
                break;
            }
        }
        if (this._info.file == null) {
            throw new EBException(2, parent.getPath(), name);
        }
        if (!this._info.file.canRead()) {
            throw new EBException(3, this._info.file.getPath());
        }
        this.getInputStream().initFileInfo();
    }

    public static File searchDirectory(String parent, String name) throws EBException {
        return EBFile.searchDirectory(new File(parent), name);
    }

    public static File searchDirectory(File parent, String name) throws EBException {
        String[] list = parent.list();
        File dir = null;
        if (list != null) {
            int len = list.length;
            for (int i = 0; i < len; ++i) {
                File f = new File(parent, list[i]);
                if (!f.isDirectory() || list[i].compareToIgnoreCase(name) != 0) continue;
                dir = f;
                break;
            }
        }
        if (dir == null) {
            throw new EBException(0, parent.getPath(), name);
        }
        if (!dir.canRead()) {
            throw new EBException(1, dir.getPath());
        }
        return dir;
    }

    public File getFile() {
        return this._info.file;
    }

    public String getPath() {
        return this._info.file.getPath();
    }

    public String getName() {
        return this._name;
    }

    public int getFormat() {
        return this._info.format;
    }

    public void setSEBXAInfo(long index, long base, long start, long end) {
        this._info.sebxaIndexPos = index;
        this._info.sebxaBasePos = base;
        this._info.sebxaStartPos = start;
        this._info.sebxaEndPos = end;
        this._info.fileSize = end;
        this._info.format = 4;
    }

    public BookInputStream getInputStream() throws EBException {
        BookInputStream bis = null;
        switch (this._info.format) {
            case 1: {
                bis = new EBZipInputStream(this._info);
                break;
            }
            case 2: 
            case 3: {
                bis = new EPWINGInputStream(this._info);
                break;
            }
            case 4: {
                bis = new SEBXAInputStream(this._info);
                break;
            }
            default: {
                bis = new PlainInputStream(this._info);
            }
        }
        return bis;
    }
}

