/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.FileInfo;
import fuku.eb4j.io.HuffmanNode;
import fuku.eb4j.util.ByteUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public final class EPWINGInputStream
extends BookInputStream {
    EPWINGInputStream(FileInfo info) throws EBException {
        super(info);
        this.open();
        this._cache = new byte[2048];
    }

    protected void initFileInfo() throws EBException {
        int freq;
        long value;
        int off;
        int i;
        try {
            this._info.realFileSize = this._stream.length();
        }
        catch (IOException e) {
            throw new EBException(4, this._info.file.getPath(), e);
        }
        byte[] b = new byte[512];
        int len = 32;
        if (this._info.format == 3) {
            len += 16;
        }
        this.readRawFully(b, 0, len);
        this._info.epwingIndexPos = ByteUtil.getLong4(b, 0);
        this._info.epwingIndexSize = ByteUtil.getLong4(b, 4);
        this._info.epwingFreqPos = ByteUtil.getLong4(b, 8);
        this._info.epwingFreqSize = ByteUtil.getLong4(b, 12);
        if (this._info.epwingIndexSize < 36L || this._info.epwingFreqSize < 512L) {
            throw new EBException(5, this._info.file.getPath());
        }
        long pos = this._info.epwingIndexPos + (this._info.epwingIndexSize - 36L) / 36L * 36L;
        try {
            this._stream.seek(pos);
        }
        catch (IOException e) {
            throw new EBException(6, this._info.file.getPath(), e);
        }
        this.readRawFully(b, 0, 36);
        this._info.fileSize = this._info.epwingIndexSize / 36L * 32768L;
        for (int i2 = 1; i2 < 16; ++i2) {
            int p = i2 * 2 + 4;
            if (ByteUtil.getInt2(b, p) != 0) continue;
            this._info.fileSize -= (long)(2048 * (16 - i2));
            break;
        }
        int leaf32 = 0;
        int leaf16 = 0;
        if (this._info.format == 2) {
            leaf16 = (int)((this._info.epwingFreqSize - 512L) / 4L);
        } else {
            leaf16 = 1024;
            leaf32 = (int)((this._info.epwingFreqSize - (long)(leaf16 * 4) - 512L) / 6L);
        }
        ArrayList<HuffmanNode> list = null;
        if (this._info.format == 3) {
            list = new ArrayList(leaf32 + leaf16 + 256 + 1);
            len = b.length - b.length % 6;
            try {
                this._stream.seek(this._info.epwingFreqPos);
            }
            catch (IOException e) {
                throw new EBException(6, this._info.file.getPath(), e);
            }
            this.readRawFully(b, 0, len);
            i = 0;
            off = 0;
            while (i < leaf32) {
                if (off >= len) {
                    this.readRawFully(b, 0, len);
                    off = 0;
                }
                value = ByteUtil.getLong4(b, off);
                freq = ByteUtil.getInt2(b, off + 4);
                list.add(new HuffmanNode(value, freq, 3));
                ++i;
                off += 6;
            }
        } else {
            list = new ArrayList<HuffmanNode>(leaf16 + 256 + 1);
        }
        len = b.length - b.length % 4;
        try {
            this._stream.seek(this._info.epwingFreqPos + (long)(leaf32 * 6));
        }
        catch (IOException e) {
            throw new EBException(6, this._info.file.getPath(), e);
        }
        this.readRawFully(b, 0, len);
        i = 0;
        off = 0;
        while (i < leaf16) {
            if (off >= b.length) {
                this.readRawFully(b, 0, len);
                off = 0;
            }
            value = ByteUtil.getInt2(b, off);
            freq = ByteUtil.getInt2(b, off + 2);
            list.add(new HuffmanNode(value, freq, 2));
            ++i;
            off += 4;
        }
        try {
            this._stream.seek(this._info.epwingFreqPos + (long)(leaf32 * 6) + (long)(leaf16 * 4));
        }
        catch (IOException e) {
            throw new EBException(6, this._info.file.getPath(), e);
        }
        this.readRawFully(b, 0, b.length);
        i = 0;
        off = 0;
        while (i < 256) {
            int freq2 = ByteUtil.getInt2(b, off);
            list.add(new HuffmanNode(i, freq2, 1));
            ++i;
            off += 2;
        }
        list.add(new HuffmanNode(256L, 1, 0));
        this._info.epwingRootNode = HuffmanNode.makeTree(list);
        super.initFileInfo();
    }

    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            int n;
            if (this._info.fileSize <= this._filePos) {
                if (rlen == 0) {
                    return -1;
                }
                return rlen;
            }
            if (this._cachePos < 0L || this._filePos < this._cachePos || this._cachePos + 2048L <= this._filePos) {
                this._cachePos = this._filePos - this._filePos % 2048L;
                long pos = this._info.epwingIndexPos + this._filePos / 32768L * 36L;
                try {
                    this._stream.seek(pos);
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                byte[] buf = new byte[36];
                this.readRawFully(buf, 0, buf.length);
                int offset = (int)(4L + this._filePos / 2048L % 16L * 2L);
                long pagePos = ByteUtil.getLong4(buf, 0) + (long)ByteUtil.getInt2(buf, offset);
                try {
                    this._stream.seek(pagePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this._info.file.getPath(), e);
                }
                this._decode();
            }
            if (len - rlen < (n = (int)(2048L - this._filePos % 2048L))) {
                n = len - rlen;
            }
            if (this._info.fileSize - this._filePos < (long)n) {
                n = (int)(this._info.fileSize - this._filePos);
            }
            int p = (int)(this._filePos - this._cachePos);
            System.arraycopy(this._cache, p, b, off + rlen, n);
            rlen += n;
            this._filePos += (long)n;
        }
        return rlen;
    }

    private void _decode() throws EBException {
        byte[] b = new byte[2048];
        int inPos = 0;
        int inLen = 0;
        int outPos = 0;
        int outLen = 0;
        int bitIndex = 7;
        if (this._info.format == 3) {
            this.readRawFully(b, 0, 1);
            if ((b[0] & 0xFF) != 0) {
                this.readRawFully(this._cache, 0, 2048);
                return;
            }
        }
        while (outLen < 2048) {
            HuffmanNode node = this._info.epwingRootNode;
            while (!node.isLeaf()) {
                int bit;
                if (inLen <= inPos) {
                    inLen = this.readRaw(b, 0, b.length);
                    if (inLen <= 0) {
                        throw new EBException(5, this._info.file.getPath());
                    }
                    inPos = 0;
                }
                if ((node = (bit = b[inPos] >>> bitIndex & 1) == 1 ? node.getLeft() : node.getRight()) == null) {
                    throw new EBException(5, this._info.file.getPath());
                }
                if (bitIndex > 0) {
                    --bitIndex;
                    continue;
                }
                bitIndex = 7;
                ++inPos;
            }
            if (node.getLeafType() == 0) {
                if (outLen >= 2048) break;
                Arrays.fill(this._cache, outPos, this._cache.length, (byte)0);
                outLen = 2048;
                break;
            }
            if (node.getLeafType() == 3) {
                if (outLen >= 2047) {
                    this._cache[outPos] = (byte)(node.getValue() >>> 24 & 0xFFL);
                    ++outPos;
                    ++outLen;
                    continue;
                }
                if (outLen >= 2046) {
                    this._cache[outPos] = (byte)(node.getValue() >>> 24 & 0xFFL);
                    this._cache[outPos + 1] = (byte)(node.getValue() >>> 16 & 0xFFL);
                    outPos += 2;
                    outLen += 2;
                    continue;
                }
                if (outLen >= 2045) {
                    this._cache[outPos] = (byte)(node.getValue() >>> 24 & 0xFFL);
                    this._cache[outPos + 1] = (byte)(node.getValue() >>> 16 & 0xFFL);
                    this._cache[outPos + 2] = (byte)(node.getValue() >>> 8 & 0xFFL);
                    outPos += 3;
                    outLen += 3;
                    continue;
                }
                this._cache[outPos] = (byte)(node.getValue() >>> 24 & 0xFFL);
                this._cache[outPos + 1] = (byte)(node.getValue() >>> 16 & 0xFFL);
                this._cache[outPos + 2] = (byte)(node.getValue() >>> 8 & 0xFFL);
                this._cache[outPos + 3] = (byte)(node.getValue() & 0xFFL);
                outPos += 4;
                outLen += 4;
                continue;
            }
            if (node.getLeafType() == 2) {
                if (outLen >= 2047) {
                    this._cache[outPos] = (byte)(node.getValue() >>> 8 & 0xFFL);
                    ++outPos;
                    ++outLen;
                    continue;
                }
                this._cache[outPos] = (byte)(node.getValue() >>> 8 & 0xFFL);
                this._cache[outPos + 1] = (byte)(node.getValue() & 0xFFL);
                outPos += 2;
                outLen += 2;
                continue;
            }
            this._cache[outPos] = (byte)(node.getValue() & 0xFFL);
            ++outPos;
            ++outLen;
        }
    }
}

