/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.util;

import fuku.eb4j.util.ByteUtil;
import java.awt.Color;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public final class ImageUtil {
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 8, 6, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] PNG_FOOTER = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};

    private ImageUtil() {
    }

    public static byte[] bitmapToPNG(byte[] b, int width, int height) {
        return ImageUtil.bitmapToPNG(b, width, height, Color.BLACK, Color.WHITE, false, -1);
    }

    public static byte[] bitmapToPNG(byte[] b, int width, int height, Color foreground, Color background, boolean transparent) {
        return ImageUtil.bitmapToPNG(b, width, height, foreground, background, transparent, -1);
    }

    public static byte[] bitmapToPNG(byte[] b, int width, int height, Color foreground, Color background, boolean transparent, int level) {
        byte[] fRGB = new byte[]{(byte)foreground.getRed(), (byte)foreground.getGreen(), (byte)foreground.getBlue(), -1};
        byte[] bRGB = new byte[]{(byte)background.getRed(), (byte)background.getGreen(), (byte)background.getBlue(), transparent ? (byte)0 : -1};
        byte[] image = new byte[(width * 4 + 1) * height];
        int offi = 0;
        int offb = 0;
        byte[] c = null;
        for (int i = 0; i < height; ++i) {
            image[offi++] = 0;
            for (int j = 0; j < width; j += 8) {
                int cnt = 8;
                if (j + 8 > width) {
                    cnt = width - j;
                }
                int mask = 128;
                for (int k = 0; k < cnt; ++k) {
                    c = (b[offb] & mask) > 0 ? fRGB : bRGB;
                    image[offi++] = c[0];
                    image[offi++] = c[1];
                    image[offi++] = c[2];
                    image[offi++] = c[3];
                    mask >>>= 1;
                }
                ++offb;
            }
        }
        return ImageUtil._encodePNG(width, height, image, level);
    }

    public static byte[] dibToPNG(byte[] b) {
        return ImageUtil.dibToPNG(b, -1);
    }

    public static byte[] dibToPNG(byte[] b, int level) {
        if ((b[0] & 0xFF) != 66 || (b[1] & 0xFF) != 77) {
            return null;
        }
        int off = (int)ByteUtil.getLongLE4(b, 10);
        int width = (int)ByteUtil.getLongLE4(b, 18);
        int height = (int)ByteUtil.getLongLE4(b, 22);
        int bitCount = ByteUtil.getIntLE2(b, 28);
        int compress = (int)ByteUtil.getLongLE4(b, 30);
        int lineBytes = (width * bitCount + 31) / 32 * 4;
        byte[] dib = b;
        if (compress > 0) {
            if (compress == 1 && bitCount == 8 || compress == 2 && bitCount == 4) {
                dib = ImageUtil._expandRLE(b, off, compress, lineBytes, height);
            } else {
                return null;
            }
        }
        byte[] line = new byte[lineBytes];
        byte[] image = new byte[(width * 4 + 1) * height];
        int idx = 0;
        switch (bitCount) {
            case 1: {
                for (int i = height - 1; i >= 0; --i) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * i, line, 0, lineBytes);
                    for (int j = 0; j < width; j += 8) {
                        int cnt = 8;
                        if (j + 8 > width) {
                            cnt = width - j;
                        }
                        int mask = 128;
                        for (int k = 0; k < cnt; ++k) {
                            int pallet = 54;
                            if ((line[j / 8] & mask) > 0) {
                                pallet += 4;
                            }
                            image[idx++] = dib[pallet + 2];
                            image[idx++] = dib[pallet + 1];
                            image[idx++] = dib[pallet];
                            image[idx++] = -1;
                            mask >>>= 1;
                        }
                    }
                }
                break;
            }
            case 4: {
                for (int i = height - 1; i >= 0; --i) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * i, line, 0, lineBytes);
                    boolean shift = false;
                    for (int j = 0; j < width; j += 2) {
                        int pallet = 54 + (line[j / 2] >>> 4 & 0xF) * 4;
                        image[idx++] = dib[pallet + 2];
                        image[idx++] = dib[pallet + 1];
                        image[idx++] = dib[pallet];
                        image[idx++] = -1;
                        if (width - j <= 1) continue;
                        pallet = 54 + (line[j / 2] & 0xF) * 4;
                        image[idx++] = dib[pallet + 2];
                        image[idx++] = dib[pallet + 1];
                        image[idx++] = dib[pallet];
                        image[idx++] = -1;
                    }
                }
                break;
            }
            case 8: {
                for (int i = height - 1; i >= 0; --i) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * i, line, 0, lineBytes);
                    for (int j = 0; j < width; ++j) {
                        int pallet = 54 + (line[j] & 0xFF) * 4;
                        image[idx++] = dib[pallet + 2];
                        image[idx++] = dib[pallet + 1];
                        image[idx++] = dib[pallet];
                        image[idx++] = -1;
                    }
                }
                break;
            }
            case 24: {
                for (int i = height - 1; i >= 0; --i) {
                    image[idx++] = 0;
                    System.arraycopy(dib, off + lineBytes * i, line, 0, lineBytes);
                    for (int j = 0; j < width * 3; j += 3) {
                        image[idx++] = line[j + 2];
                        image[idx++] = line[j + 1];
                        image[idx++] = line[j];
                        image[idx++] = -1;
                    }
                }
                break;
            }
            default: {
                return null;
            }
        }
        return ImageUtil._encodePNG(width, height, image, level);
    }

    private static byte[] _expandRLE(byte[] rle, int off, int type, int line, int height) {
        int len = off + line * height;
        byte[] dib = new byte[len];
        System.arraycopy(rle, 0, dib, 0, off);
        int idx1 = off;
        int idx2 = off;
        int abs = 0;
        int pad = 0;
        if (type == 1) {
            block8: for (int i = off; i < len; i += 2) {
                int j;
                int code1 = rle[idx2++] & 0xFF;
                int code2 = rle[idx2++] & 0xFF;
                if (abs > 0) {
                    dib[idx1++] = (byte)code1;
                    if (--abs <= 0) continue;
                    dib[idx1] = (byte)code2;
                    continue;
                }
                if (code1 == 0) {
                    switch (code2) {
                        case 0: 
                        case 1: {
                            if (pad <= 0) {
                                pad = 3 - (idx1 - off + 3) % 4;
                            }
                            for (j = 0; j < pad; ++j) {
                                dib[idx1++] = 0;
                            }
                            if (code2 != 1) continue block8;
                            return dib;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            abs = code2;
                            break;
                        }
                    }
                    continue;
                }
                for (j = 0; j < code1; ++j) {
                    dib[idx1++] = (byte)code2;
                }
            }
        } else {
            boolean high = false;
            block11: for (int i = off; i < len; i += 2) {
                int j;
                int code1 = rle[idx2++] & 0xFF;
                int code2 = rle[idx2++] & 0xFF;
                if (abs > 0) {
                    if (high) {
                        dib[idx1] = (byte)(dib[idx1] | code1 >>> 4);
                        ++idx1;
                    } else {
                        dib[idx1] = (byte)(code1 & 0xF0);
                    }
                    boolean bl = high = !high;
                    if (--abs > 0) {
                        if (high) {
                            dib[idx1] = (byte)(dib[idx1] | code1 & 0xF);
                            ++idx1;
                        } else {
                            dib[idx1] = (byte)(code1 << 4);
                        }
                        --abs;
                        boolean bl2 = high = !high;
                    }
                    if (abs > 0) {
                        if (high) {
                            dib[idx1] = (byte)(dib[idx1] | code2 >>> 4);
                            ++idx1;
                        } else {
                            dib[idx1] = (byte)(code2 & 0xF0);
                        }
                        --abs;
                        boolean bl3 = high = !high;
                    }
                    if (abs <= 0) continue;
                    if (high) {
                        dib[idx1] = (byte)(dib[idx1] | code2 & 0xF);
                        ++idx1;
                    } else {
                        dib[idx1] = (byte)(code2 << 4);
                    }
                    --abs;
                    high = !high;
                    continue;
                }
                if (code1 == 0) {
                    switch (code2) {
                        case 0: 
                        case 1: {
                            if (pad <= 0) {
                                pad = 3 - (idx1 - off + 3) % 4;
                            }
                            for (j = 0; j < pad; ++j) {
                                dib[idx1++] = 0;
                            }
                            if (code2 != 1) continue block11;
                            return dib;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            abs = code2;
                            break;
                        }
                    }
                    continue;
                }
                for (j = 0; j < code1 / 2; ++j) {
                    if (high) {
                        dib[idx1] = (byte)(dib[idx1] | code2 >>> 4);
                        dib[++idx1] = (byte)(code2 << 4);
                        continue;
                    }
                    dib[idx1++] = (byte)code2;
                }
                if (code1 % 2 <= 0) continue;
                if (high) {
                    dib[idx1] = (byte)(dib[idx1] | code2 >>> 4);
                    ++idx1;
                } else {
                    dib[idx1] = (byte)(code2 & 0xF0);
                }
                high = !high;
            }
        }
        return dib;
    }

    private static byte[] _encodePNG(int width, int height, byte[] image, int level) {
        byte[] buf = new byte[image.length + 62];
        Deflater def = new Deflater(level);
        def.setInput(image, 0, image.length);
        def.finish();
        int len = 0;
        while (!def.needsInput()) {
            int n = def.deflate(buf, len, buf.length - len);
            len += n;
        }
        def.end();
        int size = PNG_HEADER.length + len + 12 + PNG_FOOTER.length;
        byte[] png = new byte[size];
        System.arraycopy(PNG_HEADER, 0, png, 0, PNG_HEADER.length);
        png[16] = (byte)(width >>> 24 & 0xFF);
        png[17] = (byte)(width >>> 16 & 0xFF);
        png[18] = (byte)(width >>> 8 & 0xFF);
        png[19] = (byte)(width & 0xFF);
        png[20] = (byte)(height >>> 24 & 0xFF);
        png[21] = (byte)(height >>> 16 & 0xFF);
        png[22] = (byte)(height >>> 8 & 0xFF);
        png[23] = (byte)(height & 0xFF);
        CRC32 crc = new CRC32();
        crc.update(png, 12, 17);
        long c = crc.getValue();
        png[29] = (byte)(c >>> 24 & 0xFFL);
        png[30] = (byte)(c >>> 16 & 0xFFL);
        png[31] = (byte)(c >>> 8 & 0xFFL);
        png[32] = (byte)(c & 0xFFL);
        int off = PNG_HEADER.length;
        png[off++] = (byte)(len >>> 24 & 0xFF);
        png[off++] = (byte)(len >>> 16 & 0xFF);
        png[off++] = (byte)(len >>> 8 & 0xFF);
        png[off++] = (byte)(len & 0xFF);
        png[off++] = 73;
        png[off++] = 68;
        png[off++] = 65;
        png[off++] = 84;
        System.arraycopy(buf, 0, png, off, len);
        crc.reset();
        crc.update(png, off - 4, len + 4);
        c = crc.getValue();
        off += len;
        png[off++] = (byte)(c >>> 24 & 0xFFL);
        png[off++] = (byte)(c >>> 16 & 0xFFL);
        png[off++] = (byte)(c >>> 8 & 0xFFL);
        png[off++] = (byte)(c & 0xFFL);
        System.arraycopy(PNG_FOOTER, 0, png, off, PNG_FOOTER.length);
        return png;
    }
}

