package fuku.player;

import java.awt.*;
import java.net.*;
import java.io.*;
import javax.swing.*;

import javax.media.*;

/**
 * 動画再生アプレット。
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.5
 */
public final class VideoPlayerApplet
    extends JApplet implements ControllerListener {

    /** プレイヤ */
    private Player _player = null;
    /** プログレスバー */
    private Component _progressBar = null;
    /** 表示コンポーネント */
    private Component _visualComp = null;
    /** コントローラコンポーネント */
    private Component _controlComp = null;


    /**
     * このアプレットを初期化します。
     *
     */
    public void init() {
        getContentPane().setLayout(new BorderLayout(0, 0));

        try {
            URL url = new URL(getDocumentBase(), getParameter("file"));
            _player = Manager.createPlayer(url);
            _player.addControllerListener(this);
        } catch (MalformedURLException e) {
            System.err.println(e.getMessage());
        } catch (IOException e) {
            System.err.println(e.getMessage());
        } catch (NoPlayerException e) {
            System.err.println(e.getMessage());
        }
    }

    /**
     * アプレットが開始されると呼び出されます。
     *
     */
    public void start() {
        if (_player != null) {
            _player.start();
        }
    }

    /**
     * アプレットが停止されると呼び出されます。
     *
     */
    public void stop() {
        if (_player != null) {
            _player.stop();
            _player.deallocate();
        }
    }

    /**
     * すべてのリソースを開放します。
     *
     */
    public void destroy() {
        getContentPane().removeAll();
        _progressBar = null;
        _visualComp = null;
        _controlComp = null;
        if (_player != null) {
            _player.close();
            _player = null;
        }
    }

    /**
     * コントローライベントが発生すると呼び出されます。
     *
     * @param evt コントローライベント
     */
    public synchronized void controllerUpdate(ControllerEvent evt) {
        if (_player == null) {
            return;
        }
        if (evt instanceof RealizeCompleteEvent) {
            _player.stop();
            if (_visualComp == null) {
                // 表示コンポーネントの追加
                _visualComp = _player.getVisualComponent();
                if (_visualComp != null) {
                    getContentPane().add(_visualComp, BorderLayout.CENTER);
                }
            }
            if (_controlComp == null) {
                // コントローラコンポーネントの追加
                _controlComp = _player.getControlPanelComponent();
                if (_controlComp != null) {
                    getContentPane().add(_controlComp, BorderLayout.SOUTH);
                }
            }
            validate();
        } else if (evt instanceof CachingControlEvent) {
            CachingControlEvent e = (CachingControlEvent)evt;
            CachingControl cc = e.getCachingControl();
            if (_progressBar == null) {
                // ダウンロード状況をプログレスバーで表示
                _progressBar = cc.getProgressBarComponent();
                if (_progressBar != null) {
                    getContentPane().add(_progressBar, BorderLayout.NORTH);
                    validate();
                }
            }
            if (_progressBar != null) {
                // ダウンロードが終了したら取り除く
                if (e.getContentProgress() == cc.getContentLength()) {
                    getContentPane().remove(_progressBar);
                    _progressBar = null;
                    validate();
                }
            }
        } else if (evt instanceof EndOfMediaEvent) {
            _player.setMediaTime(new Time(0));
        } else if (evt instanceof ControllerErrorEvent) {
            ControllerErrorEvent e = (ControllerErrorEvent)evt;
            System.err.println(e.getMessage());
        }
    }
}

// end of VideoPlayerApplet.java
