<%@page contentType="text/html; charset=UTF-8" %>
<%@page import="java.io.*" %>
<%@page import="java.net.*" %>
<%@page import="fuku.eb4j.SubBook" %>
<%@page import="fuku.webbook.WebBook" %>

<%
  WebBook webbook = (WebBook)application.getAttribute("webbook");
  SubBook[] subs = webbook.getSubBooks(request.getRemoteHost());
  int len = -1;
  String errmsg = null;
  if (subs != null && subs.length > 0) {
    boolean hasMulti = false;
    len = subs.length;
    for (int i=0; i<len; i++) {
      if (subs[i].hasMultiSearch()) {
        hasMulti = true;
        break;
      }
    }
    if (!hasMulti) {
      len = -1;
      errmsg = "複合検索をサポートした書籍が存在しません。";
    }
  } else {
    errmsg = "書籍が存在しません。";
  }
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
                      "http://www.w3.org/TR/html4/loose.dtd">

<HTML>
<HEAD>
<META http-equiv="Pragma" content="no-cache">
<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
<META http-equiv="Content-Style-Type" content="text/css">
<LINK rel="stylesheet" href="webbook.css" type="text/css" media="screen">
<TITLE>複合検索</TITLE>
</HEAD>

<BODY>
<CENTER>
 <TABLE class="menu">
  <TR>
   <TD class="menu">
    <A class="menu" href="preference.jsp" target="detailFrame">表示設定</A>
   </TD>
   <TD class="menu">
    <A class="menu" href="search.jsp" target="searchFrame">単語検索</A>
   </TD>
   <TD class="menu">
    <SPAN class="menu">複合検索</SPAN>
   </TD>
   <TD class="menu">
    <A class="menu" href="list.jsp?view=menu" target="summaryFrame">メニュー</A>
   </TD>
   <TD class="menu">
    <A class="menu" href="list.jsp?view=copyright" target="summaryFrame">著作権</A>
   </TD>
   <TD class="menu">
    <A class="menu" href="list.jsp?view=info" target="summaryFrame">書籍情報</A>
   </TD>
<% if (request.getRemoteUser() != null) { %>
   <TD class="menu">
    <A class="menu" href="logout.jsp" target="_top">ログアウト</A>
   </TD>
<% } %>
  </TR>
 </TABLE>
 <BR>

 <TABLE class="main">
<%
  if (len > 0) {
    boolean first = true;
    for (int i=0; i<len; i++) {
      if (subs[i].hasMultiSearch()) {
        if (first) {
          first = false;
        } else {
%>
  <TR class="empty"><TD colspan="3"></TR></TD>
<% } %>
  <TR class="header main">
   <TH colspan="3" class="header"><%= subs[i].getTitle() %></TH>
  </TR>
<%
        int count = subs[i].getMultiCount();
        for (int j=0; j<count; j++) {
          int entry = subs[i].getMultiEntryCount(j);
          String url = null;
          try {
            url = "WebBookServlet?target=multisearch.jsp"
                  + "&book=" + URLEncoder.encode(subs[i].getName(), "UTF-8")
                  + "&multi=" + j;
          } catch (UnsupportedEncodingException e) {
          }
%>
<% if ((j%2) == 0) { %>
  <TR class="odd main">
<% } else { %>
  <TR class="even main">
<% } %>
   <TD class="itemL"><%= subs[i].getMultiTitle(j) %>：</TD>
   <TD class="itemR">
    <SELECT>
     <OPTION>検索語一覧</OPTION>
<% for (int k=0; k<entry; k++) { %>
     <OPTION disabled><%= subs[i].getMultiEntryLabel(j, k) %></OPTION>
<% } %>
    </SELECT>
   </TD>
   <TD class="button"><A href="<%= url %>">選択</A></TD>
  </TR>
<% }}}} else { %>
  <TR class="header main"><TH class="header">エラー</TH></TR>
  <TR class="odd main"><TD class="item"><%= errmsg %></TD></TR>
<% } %>
 </TABLE>
</CENTER>
</BODY>
</HTML>

<!-- end of multilist.jsp -->
