<%@page contentType="text/html; charset=UTF-8" %>
<%@page import="fuku.eb4j.SubBook" %>
<%@page import="fuku.webbook.WebBook" %>

<%
  WebBook webbook = (WebBook)application.getAttribute("webbook");
  String host = request.getRemoteHost();
  String book = request.getParameter("book");
  SubBook sub = webbook.getSubBook(host, book);
  int multi = 0;
  try {
    multi = Integer.parseInt(request.getParameter("multi"));
  } catch (NumberFormatException e) {
    multi = -1;
  }

  SubBook[] subs = webbook.getSubBooks(host);
  boolean hasMulti = false;
  if (subs != null && subs.length > 0) {
    int len = subs.length;
    for (int i=0; i<len; i++) {
      if (subs[i].hasMultiSearch()) {
        hasMulti = true;
        break;
      }
    }
  }
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
                      "http://www.w3.org/TR/html4/loose.dtd">

<HTML>
<HEAD>
<META http-equiv="Pragma" content="no-cache">
<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
<META http-equiv="Content-Style-Type" content="text/css">
<LINK rel="stylesheet" href="webbook.css" type="text/css" media="screen">
<TITLE>複合検索</TITLE>
</HEAD>

<BODY>
<CENTER>
 <TABLE class="menu">
  <TR class="main">
   <TD class="menu">
    <A class="menu" href="preference.jsp" target="detailFrame">表示設定</A>
   </TD>
   <TD class="menu">
    <A class="menu" href="search.jsp" target="searchFrame">単語検索</A>
   </TD>
   <TD class="menu">
<% if (hasMulti) { %>
    <A class="menu" href="multilist.jsp" target="searchFrame">複合検索</A>
<% } else { %>
    <SPAN class="menu">複合検索</SPAN>
<% } %>
   </TD>
   <TD class="menu">
    <A class="menu" href="list.jsp?view=menu" target="summaryFrame">メニュー</A>
   </TD>
   <TD class="menu">
    <A class="menu" href="list.jsp?view=copyright" target="summaryFrame">著作権</A>
   </TD>
   <TD class="menu">
    <A class="menu" href="list.jsp?view=info" target="summaryFrame">書籍情報</A>
   </TD>
<% if (request.getRemoteUser() != null) { %>
   <TD class="menu">
    <A class="menu" href="logout.jsp" target="_top">ログアウト</A>
   </TD>
<% } %>
  </TR>
 </TABLE>
 <BR>

 <FORM name="f" method="POST" target="summaryFrame" action="WebBookServlet">
 <INPUT type="hidden" name="target" value="result.jsp">
 <INPUT type="hidden" name="act" value="multisearch">

 <TABLE class="main">
  <TR class="header main">
   <TH class="header" colspan="2">
    <%= sub.getTitle() + " - " + sub.getMultiTitle(multi) %>
    <INPUT type="hidden" name="book" value="<%= book %>">
    <INPUT type="hidden" name="multi" value="<%= multi %>">
   </TH>
  </TR>
  <TR class="main">
   <TD class="inner">
    <TABLE class="inner">
<%
     int entry = sub.getMultiEntryCount(multi);
     boolean flag = false;
     int text = -1;
     for (int i=0; i<entry; i++) {
%>
     <TR>
      <TD class="itemL"><%= sub.getMultiEntryLabel(multi, i) %>：</TD>
      <TD class="itemR">
<% if (sub.hasMultiEntryCandidate(multi, i)) { %>
       <SELECT name="key<%= i %>">
        <OPTION value="">選択</OPTION>
        <%= webbook.getCandidate(host, book, multi, i) %>
       </SELECT>
<%
   } else {
     text = i;
%>
       <INPUT type="text" name="key<%= i %>" size="30">
<%
   }
   if (!flag && text >= 0) {
     flag = true;
%>
       <SCRIPT type="text/javascript">
       document.f.key<%= i %>.focus();
       </SCRIPT>
<% } %>
      </TD>
     </TR>
<% } %>
    </TABLE>
   </TD>
   <TD class="inner">
    <TABLE class="inner">
     <TR>
      <TD class="button">
       <INPUT type="submit" value="検索" style="width:100%;">
      </TD>
     </TR>
     <TR>
      <TD class="button">
       <INPUT type="reset" value="リセット" style="width:100%;">
      </TD>
     </TR>
    </TABLE>
   </TD>
  </TR>
 </TABLE>
 </FORM>
</CENTER>
</BODY>
</HTML>

<!-- end of multisearch.jsp -->
