package fuku.webbook;

import java.util.*;

/**
 * 文字列ユーティリティクラス。
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.5
 */
public final class StringUtil {

    /**
     * コンストラクタ。
     *
     */
    private StringUtil() {
        super();
    }


    /**
     * 文字列をboolean型に変換します。<BR>
     * 文字列が "true"、"on"、"yes" に等しい
     * (大文字と小文字は区別しない) 場合、または、
     * 数値として 0 以上の場合はtrueを返します。
     *
     * @param str 文字列
     * @return boolean値
     */
    public static boolean toBoolean(String str) {
        if (str == null) {
            return false;
        }
        boolean ret = false;
        if (str.equalsIgnoreCase("true")) {
            ret = true;
        } else if (str.equalsIgnoreCase("yes")) {
            ret = true;
        } else if (str.equalsIgnoreCase("on")) {
            ret = true;
        } else {
            try {
                if (Integer.parseInt(str) > 0) {
                    ret = true;
                }
            } catch (NumberFormatException e) {
            }
        }
        return ret;
    }

    /**
     * 指定されたデリミタで文字列を区切ります。
     *
     * @param str 文字列
     * @param delim デリミタ
     * @return 文字列配列
     */
    public static String[] split(String str, char delim) {
        return split(str, delim, true);
    }

    /**
     * 指定されたデリミタで文字列を区切ります。
     *
     * @param str 文字列
     * @param delim デリミタ
     * @param empty 空要素を許すかどうか
     * @return 文字列配列
     */
    public static String[] split(String str, char delim, boolean empty) {
        if (str == null || str.length() <= 0) {
            return new String[0];
        }
        String sep = Character.toString(delim);
        StringBuffer buf = new StringBuffer(str);
        ArrayList list = new ArrayList();
        int idx1 = 0;
        int idx2 = buf.indexOf(sep, idx1);
        String s;
        while (idx2 >= 0) {
            if (idx2 > 0 && buf.charAt(idx2-1) == '\\') {
                buf.deleteCharAt(idx2-1);
                idx2--;
            } else {
                s = buf.substring(idx1, idx2);
                if (s.length() > 0 || empty) {
                    list.add(s);
                }
            }
            idx1 = idx2 + 1;
            idx2 = buf.indexOf(sep, idx1);
        }
        s = buf.substring(idx1, buf.length());
        if (s.length() > 0 || empty) {
            list.add(s);
        }
        return (String[])list.toArray(new String[0]);
    }
}

// end of StringUtil.java
