/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.Appendix;
import fuku.eb4j.EBException;
import fuku.eb4j.SubAppendix;
import fuku.eb4j.SubBook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;
import java.io.File;

public class Book {
    public static final int DISC_EB = 0;
    public static final int DISC_EPWING = 1;
    public static final int CHARCODE_ISO8859_1 = 1;
    public static final int CHARCODE_JISX0208 = 2;
    public static final int CHARCODE_JISX0208_GB2312 = 3;
    static final int[] SIZE_CATALOG = new int[]{40, 164};
    static final int[] SIZE_TITLE = new int[]{30, 80};
    static final int SIZE_DIRNAME = 8;
    private static final String[] MISLEADED = new String[]{"%;%s%A%e%j!\\%S%8%M%9!\\%/%i%&%s", "8&5f<R!!?71QOBCf<-E5", "#E#B2J3X5;=QMQ8lBg<-E5", "#E#N#G!?#J#A#N!J!\\#F#R#E!K", "#E#N#G!?#J#A#N!J!\\#S#P#A!K"};
    private String _bookPath = null;
    private int _bookType = -1;
    private int _charCode = -1;
    private int _version = -1;
    private SubBook[] _sub = null;

    public Book(String bookPath) throws EBException {
        this(bookPath, null);
    }

    public Book(File bookDir) throws EBException {
        this(bookDir, null);
    }

    public Book(String bookPath, String appendixPath) throws EBException {
        this(new File(bookPath), appendixPath == null ? null : new File(appendixPath));
    }

    public Book(File bookDir, File appendixDir) throws EBException {
        this._bookPath = bookDir.getPath();
        if (!bookDir.isDirectory()) {
            throw new EBException(0, this._bookPath);
        }
        if (!bookDir.canRead()) {
            throw new EBException(1, this._bookPath);
        }
        this._loadLanguage(bookDir);
        this._loadCatalog(bookDir);
        if (appendixDir != null) {
            Appendix appendix = new Appendix(appendixDir);
            SubAppendix[] sa = appendix.getSubAppendixes();
            int len = sa.length;
            if (len > this._sub.length) {
                len = this._sub.length;
            }
            for (int i = 0; i < len; ++i) {
                this._sub[i].setAppendix(sa[i]);
            }
        }
    }

    public String getPath() {
        return this._bookPath;
    }

    public int getBookType() {
        return this._bookType;
    }

    public int getCharCode() {
        return this._charCode;
    }

    public int getSubBookCount() {
        int ret = 0;
        if (this._sub != null) {
            ret = this._sub.length;
        }
        return ret;
    }

    public SubBook[] getSubBooks() {
        if (this._sub == null) {
            return new SubBook[0];
        }
        int len = this._sub.length;
        SubBook[] list = new SubBook[len];
        System.arraycopy(this._sub, 0, list, 0, len);
        return list;
    }

    public SubBook getSubBook(int index) {
        if (index < 0 || index >= this._sub.length) {
            return null;
        }
        return this._sub[index];
    }

    public int getVersion() {
        return this._version;
    }

    private void _loadCatalog(File dir) throws EBException {
        EBFile file = null;
        try {
            file = new EBFile(dir, "catalog", 0);
            this._bookType = 0;
            this._loadCatalogEB(file);
        }
        catch (EBException e) {
            file = new EBFile(dir, "catalogs", 0);
            this._bookType = 1;
            this._loadCatalogEPWING(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadCatalogEB(EBFile file) throws EBException {
        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            bis.readFully(b, 0, b.length);
            int subCount = ByteUtil.getInt2(b, 0);
            if (subCount <= 0) {
                throw new EBException(5, file.getPath());
            }
            this._sub = new SubBook[subCount];
            b = new byte[SIZE_CATALOG[0]];
            for (int i = 0; i < subCount; ++i) {
                bis.readFully(b, 0, b.length);
                int off = 2;
                String title = null;
                if (this._charCode == 1) {
                    title = new String(b, off, SIZE_TITLE[0]).trim();
                    for (int j = 0; j < MISLEADED.length; ++j) {
                        if (!title.equals(MISLEADED[j])) continue;
                        this._charCode = 2;
                        byte[] tmp = title.getBytes();
                        title = ByteUtil.jisx0208ToString(tmp, 0, tmp.length);
                        break;
                    }
                } else {
                    title = ByteUtil.jisx0208ToString(b, off, SIZE_TITLE[0]);
                }
                String name = new String(b, off, 8).trim();
                String[] fname = new String[3];
                int[] format = new int[3];
                fname[0] = "start";
                format[0] = 0;
                this._sub[i] = new SubBook(this, title, name, 1, fname, format, null, null);
            }
        }
        finally {
            bis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadCatalogEPWING(EBFile file) throws EBException {
        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            bis.readFully(b, 0, b.length);
            int subCount = ByteUtil.getInt2(b, 0);
            if (subCount <= 0) {
                throw new EBException(5, file.getPath());
            }
            this._version = ByteUtil.getInt2(b, 2);
            this._sub = new SubBook[subCount];
            b = new byte[SIZE_CATALOG[1]];
            for (int i = 0; i < subCount; ++i) {
                bis.seek(16 + i * b.length);
                bis.readFully(b, 0, b.length);
                int off = 2;
                String title = null;
                if (this._charCode == 1) {
                    title = new String(b, off, SIZE_TITLE[1]).trim();
                    for (int j = 0; j < MISLEADED.length; ++j) {
                        if (!title.equals(MISLEADED[j])) continue;
                        this._charCode = 2;
                        byte[] tmp = title.getBytes();
                        title = ByteUtil.jisx0208ToString(tmp, 0, tmp.length);
                        break;
                    }
                } else {
                    title = ByteUtil.jisx0208ToString(b, off, SIZE_TITLE[1]);
                }
                String name = new String(b, off += SIZE_TITLE[1], 8).trim();
                int index = ByteUtil.getInt2(b, (off += 8) + 4);
                off += 6;
                String[] narrow = new String[4];
                String[] wide = new String[4];
                off += 4;
                for (int j = 0; j < 4; ++j) {
                    if (b[off] != 0 && b[off] < 128) {
                        wide[j] = new String(b, off, 8).trim();
                    }
                    if (b[off + 32] != 0 && b[off + 32] < 128) {
                        narrow[j] = new String(b, off + 32, 8).trim();
                    }
                    off += 8;
                }
                String[] fname = new String[3];
                int[] format = new int[3];
                fname[0] = "honmon";
                format[0] = 0;
                if (this._version != 1) {
                    bis.seek(16 + (subCount + i) * b.length);
                    bis.readFully(b, 0, b.length);
                    if ((b[4] & 0xFF) != 0) {
                        fname[0] = new String(b, 4, 8).trim();
                        format[0] = b[55] & 0xFF;
                        int dataType = ByteUtil.getInt2(b, 41);
                        if ((dataType & 3) == 2) {
                            fname[1] = new String(b, 44, 8).trim();
                            format[1] = b[54] & 0xFF;
                        } else if ((dataType >>> 8 & 3) == 2) {
                            fname[1] = new String(b, 56, 8).trim();
                            format[1] = b[53] & 0xFF;
                        }
                        if ((dataType & 3) == 1) {
                            fname[2] = new String(b, 44, 8).trim();
                            format[2] = b[54] & 0xFF;
                        } else if ((dataType >>> 8 & 3) == 1) {
                            fname[2] = new String(b, 56, 8).trim();
                            format[2] = b[53] & 0xFF;
                        }
                        block11: for (int j = 0; j < 3; ++j) {
                            switch (format[j]) {
                                case 0: {
                                    format[j] = 0;
                                    continue block11;
                                }
                                case 17: {
                                    format[j] = 2;
                                    continue block11;
                                }
                                case 18: {
                                    format[j] = 3;
                                    continue block11;
                                }
                                default: {
                                    throw new EBException(5, file.getPath());
                                }
                            }
                        }
                    }
                }
                this._sub[i] = new SubBook(this, title, name, index, fname, format, narrow, wide);
            }
        }
        finally {
            bis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadLanguage(File dir) throws EBException {
        this._charCode = 2;
        EBFile file = null;
        try {
            file = new EBFile(dir, "language", 0);
        }
        catch (EBException e) {
            // empty catch block
        }
        if (file == null) {
            return;
        }
        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            if (bis.read(b, 0, b.length) != b.length) {
                return;
            }
            this._charCode = ByteUtil.getInt2(b, 0);
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }
}

