/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.zipcode;

import fuku.xml2eb.converter.zipcode.ZipCodeUtil;
import fuku.xml2eb.util.UnicodeUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipCodeJigyosyo {
    private static final String ENCODING = "MS932";
    private transient Log _log = null;
    private File _file = null;
    private List<Item> _itemList = new ArrayList<Item>();

    public ZipCodeJigyosyo(File file) {
        this._log = LogFactory.getLog(this.getClass());
        this._file = file;
        this._load();
    }

    public Date getDate() {
        long time = this._file.lastModified();
        return new Date(time);
    }

    public List<Item> getItemList() {
        return this._itemList;
    }

    public List<Item> getItemList(Item item) {
        ArrayList<Item> list = new ArrayList<Item>();
        int len = this._itemList.size();
        for (int i = 0; i < len; ++i) {
            Item item1 = this._itemList.get(i);
            if (!item.getName().equals(item1.getName()) || item.getIndex() == item1.getIndex()) continue;
            list.add(item1);
        }
        return list;
    }

    public Map<String, List<Item>> getZipcodeMap() {
        TreeMap<String, List<Item>> map = new TreeMap<String, List<Item>>();
        int size = this._itemList.size();
        for (int i = 0; i < size; ++i) {
            Item item = this._itemList.get(i);
            String key = item.getZipcode();
            ArrayList<Item> list = (ArrayList<Item>)map.get(key);
            if (list == null) {
                list = new ArrayList<Item>();
                map.put(key, list);
            }
            list.add(item);
        }
        return map;
    }

    public Map<String, Map<String, List<Item>>> getAddressMap() {
        LinkedHashMap<String, Map<String, List<Item>>> map = new LinkedHashMap<String, Map<String, List<Item>>>();
        int size = this._itemList.size();
        for (int i = 0; i < size; ++i) {
            String key2;
            ArrayList<Item> list;
            Item item = this._itemList.get(i);
            String key1 = item.getPrefecture();
            LinkedHashMap<String, ArrayList<Item>> map1 = (LinkedHashMap<String, ArrayList<Item>>)map.get(key1);
            if (map1 == null) {
                map1 = new LinkedHashMap<String, ArrayList<Item>>();
                map.put(key1, map1);
            }
            if ((list = (ArrayList<Item>)map1.get(key2 = item.getCity())) == null) {
                list = new ArrayList<Item>();
                map1.put(key2, list);
            }
            list.add(item);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        this._log.info((Object)("load file: " + this._file.getPath()));
        LineNumberReader lnr = null;
        try {
            Charset cs = Charset.forName(ENCODING);
            lnr = new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), cs)));
            String line = null;
            while ((line = lnr.readLine()) != null) {
                line = UnicodeUtil.sanitizeUnicode((String)line);
                line = line.replace('\ufa10', '\u585a');
                line = line.replace('\ufa11', '\u5d0e');
                StrTokenizer st = StrTokenizer.getCSVInstance((String)(line = line.replaceAll("\u66b2", "\u65e5\u7ae0")));
                int n = st.size();
                if (n != 13) {
                    this._log.error((Object)("unknown tokens count: " + this._file.getName() + "[" + lnr.getLineNumber() + "] " + n));
                    continue;
                }
                String[] tokens = st.getTokenArray();
                int empty = -1;
                for (int i = 0; i < n; ++i) {
                    if (!StringUtils.isBlank((String)tokens[i])) continue;
                    empty = i;
                    break;
                }
                Item item = new Item(tokens[0], tokens[1], tokens[2], tokens[3], tokens[4], tokens[5], tokens[6], tokens[7], tokens[9], tokens[10], tokens[11]);
                this._itemList.add(item);
            }
            this._log.info((Object)("loaded " + this._itemList.size() + " items"));
            IOUtils.closeQuietly((Reader)lnr);
        }
        catch (IOException e) {
            this._log.fatal((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(lnr);
        }
    }

    public class Item {
        private String _code = null;
        private String _kanaName = null;
        private String _name = null;
        private String _prefecture = null;
        private String _city = null;
        private String _town = null;
        private String _area = null;
        private String _zipcode = null;
        private String _postoffice = null;
        private boolean _pob = false;
        private int _index = 0;

        protected Item(String code, String kanaName, String name, String prefecture, String city, String town, String area, String zipcode, String postoffice, String pob, String index) {
            this._code = code;
            this._zipcode = zipcode.substring(0, 3) + "-" + zipcode.substring(3);
            this._kanaName = ZipCodeUtil.toFullwidth(kanaName, name);
            this._kanaName = this._kanaName.replace('\uff08', '(');
            this._kanaName = this._kanaName.replace('\uff09', ')');
            this._name = name;
            this._name = this._name.replace('\u3000', ' ');
            this._name = this._name.replace('\uff08', '(');
            this._name = this._name.replace('\uff09', ')');
            this._prefecture = prefecture;
            this._city = city;
            this._town = town;
            this._area = area;
            this._area = this._area.replace('\uff08', '(');
            this._area = this._area.replace('\uff09', ')');
            int idx = this._area.indexOf(40);
            if (idx > 0 && this._area.charAt(idx - 1) != ' ') {
                this._area = this._area.substring(0, idx) + " " + this._area.substring(idx);
            }
            this._postoffice = postoffice;
            if ("1".equals(pob)) {
                this._pob = true;
            }
            try {
                this._index = Integer.parseInt(index);
            }
            catch (NumberFormatException e) {
                this._index = 0;
            }
        }

        public String getCode() {
            return this._code;
        }

        public String getZipcode() {
            return this._zipcode;
        }

        public String getKanaName() {
            return this._kanaName;
        }

        public String getName() {
            return this._name;
        }

        public String getPrefecture() {
            return this._prefecture;
        }

        public String getCity() {
            return this._city;
        }

        public String getTown() {
            return this._town;
        }

        public String getArea() {
            return this._area;
        }

        public String getPostOffice() {
            return this._postoffice;
        }

        public boolean isPostOfficeBox() {
            return this._pob;
        }

        public int getIndex() {
            return this._index;
        }
    }
}

