/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class Xbm {
    private String _name = null;
    private int _width = -1;
    private int _height = -1;
    private byte[] _bitmap = null;

    public Xbm(String path) throws IOException {
        this(new File(path));
    }

    public Xbm(File file) throws IOException {
        int n;
        String str = FileUtils.readFileToString((File)file, (String)"ISO-8859-1");
        int flag = 8;
        Pattern p = Pattern.compile("^#define\\s+(\\S+)_width\\s+(\\d+)$", flag);
        Matcher m = p.matcher(str);
        if (!m.find()) {
            throw new IOException("width not defined");
        }
        this._name = m.group(1);
        this._width = Integer.decode(m.group(2));
        p = Pattern.compile("^#define\\s+\\S+_height\\s+(\\d+)$", flag);
        m = p.matcher(str);
        if (!m.find()) {
            throw new IOException("height not defined");
        }
        this._height = Integer.decode(m.group(1));
        p = Pattern.compile("^static\\s+[a-z]*\\s*char\\s+\\S+_bits\\[\\]\\s+=\\s+\\{\\s*([0-9][0-9a-fA-FxX,\\s]+[0-9a-fA-F])\\s*\\}\\s*;", flag);
        m = p.matcher(str);
        if (!m.find()) {
            throw new IOException("bits not defined");
        }
        String[] bits = m.group(1).split(",\\s*");
        if (bits.length != (n = this._height * this._width / 8)) {
            throw new IOException("bits length error");
        }
        this._bitmap = new byte[n];
        Arrays.fill(this._bitmap, (byte)0);
        for (int i = 0; i < n; ++i) {
            int bit = Integer.decode(bits[i]);
            int mask = 1;
            int val = 128;
            for (int j = 0; j < 8; ++j) {
                if ((bit & mask) != 0) {
                    int n2 = i;
                    this._bitmap[n2] = (byte)(this._bitmap[n2] | val);
                }
                mask <<= 1;
                val >>>= 1;
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getSize() {
        return this._bitmap.length;
    }

    public byte[] getBitmap() {
        int len = this._bitmap.length;
        byte[] b = new byte[len];
        System.arraycopy(this._bitmap, 0, b, 0, len);
        return b;
    }
}

