/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.eb4j.util.HexUtil;
import fuku.xml2eb.converter.wdic.Wdic;
import fuku.xml2eb.converter.wdic.WdicDirList;
import fuku.xml2eb.converter.wdic.WdicGroup;
import fuku.xml2eb.converter.wdic.WdicGroupList;
import fuku.xml2eb.converter.wdic.WdicItem;
import fuku.xml2eb.converter.wdic.WdicMan;
import fuku.xml2eb.converter.wdic.WdicTable;
import fuku.xml2eb.converter.wdic.WdicUtil;
import fuku.xml2eb.util.BmpUtil;
import fuku.xml2eb.util.FontUtil;
import fuku.xml2eb.util.WordUtil;
import fuku.xml2eb.util.XmlUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Wdic2Xml {
    private static final String _PROGRAM = Wdic2Xml.class.getName();
    private static final String ENCODING = "UTF-8";
    private static final String WDIC_PLUGIN_DIR = "plugin";
    private static final String WDIC_GAIJI_DIR = "gaiji";
    private static final String WDIC_TABLE_DIR = "table";
    private static final String BOOK_XML = "book.xml";
    private static final String BOOK_TITLE = "\u901a\u4fe1\u7528\u8a9e\u306e\u57fa\u790e\u77e5\u8b58";
    private static final String BOOK_DIR = "wdic";
    private static final String BOOK_TYPE = "0x" + HexUtil.toHexString((int)96, (int)2);
    private transient Log _log = LogFactory.getLog(this.getClass());
    private File _basedir = null;
    private WdicGroupList _groupList = null;
    private WdicDirList _dirList = null;
    private WdicMan _manual = null;
    private Map<String, Set<WdicItem>> _pluginMap = null;
    private Map<String, String> _gaijiMap = null;
    private List<String> _tableList = null;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("java " + _PROGRAM + " [wdic-directory]");
        } else {
            new Wdic2Xml(args[0]).convert();
        }
    }

    public Wdic2Xml(String path) {
        this(new File(path));
    }

    public Wdic2Xml(File dir) {
        this._basedir = dir;
    }

    public void convert() throws ParserConfigurationException, IOException {
        File file = new File(this._basedir, "FILE.GL");
        this._groupList = new WdicGroupList(file);
        file = new File(this._basedir, "DIR.LST");
        this._dirList = new WdicDirList(file);
        file = new File(this._basedir, "WDICALL.MAN");
        this._manual = new WdicMan(file);
        this._pluginMap = this._groupList.getPluginMap();
        this._gaijiMap = new TreeMap<String, String>();
        this._tableList = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element book = doc.createElement("book");
        doc.appendChild(book);
        Element subbook = this._appendElement(book, "subbook");
        subbook.setAttribute("title", BOOK_TITLE);
        subbook.setAttribute("dir", BOOK_DIR);
        subbook.setAttribute("type", BOOK_TYPE);
        this._log.info((Object)"create content node...");
        this._makeContentNode(subbook);
        this._log.info((Object)"create graphic node...");
        this._makeGraphicNode(subbook);
        this._log.info((Object)"create sound node...");
        this._makeSoundNode(subbook);
        this._log.info((Object)"create font node...");
        this._makeFontNode(subbook);
        file = new File(this._basedir, BOOK_XML);
        this._log.info((Object)("write file: " + file.getPath()));
        XmlUtil.write((Document)doc, (File)file);
    }

    private void _makeGraphicNode(Element subbook) {
        Element graphic = this._appendElement(subbook, "graphic");
        File plugin = new File(this._basedir, WDIC_PLUGIN_DIR);
        for (String name : this._pluginMap.keySet()) {
            if (name.endsWith(".jpg")) {
                File jpg = new File(plugin, name);
                if (!jpg.exists()) {
                    this._log.error((Object)("file not found: " + jpg.getPath()));
                }
                String path = FilenameUtils.concat((String)WDIC_PLUGIN_DIR, (String)name);
                this._appendData(graphic, name, path, "jpg");
                continue;
            }
            if (!name.endsWith(".png")) continue;
            String bmpName = name + ".bmp";
            File bmp = new File(plugin, bmpName);
            if (!bmp.exists()) {
                this._log.error((Object)("file not found: " + bmp.getPath()));
            }
            String path = FilenameUtils.concat((String)WDIC_PLUGIN_DIR, (String)bmpName);
            this._appendData(graphic, name, path, "bmp");
        }
        File table = new File(this._basedir, WDIC_TABLE_DIR);
        int len = this._tableList.size();
        for (int i = 0; i < len; ++i) {
            String name = this._tableList.get(i) + ".bmp";
            File bmp = new File(table, name);
            if (!bmp.exists()) {
                this._log.error((Object)("file not found: " + bmp.getPath()));
            }
            String path = FilenameUtils.concat((String)WDIC_TABLE_DIR, (String)name);
            this._appendData(graphic, name, path, "bmp");
        }
    }

    private void _makeSoundNode(Element subbook) {
        Element sound = this._appendElement(subbook, "sound");
        File plugin = new File(this._basedir, WDIC_PLUGIN_DIR);
        for (String name : this._pluginMap.keySet()) {
            if (name.endsWith(".mp3") || name.endsWith(".ogg")) {
                String wavName = name + ".wav";
                File wav = new File(plugin, wavName);
                if (!wav.exists()) {
                    this._log.error((Object)("file not found: " + wav.getPath()));
                }
                String path = FilenameUtils.concat((String)WDIC_PLUGIN_DIR, (String)wavName);
                this._appendData(sound, name, path, "wav");
                continue;
            }
            if (!name.endsWith(".mid")) continue;
            File midi = new File(plugin, name);
            if (!midi.exists()) {
                this._log.error((Object)("file not found: " + midi.getPath()));
            }
            String path = FilenameUtils.concat((String)WDIC_PLUGIN_DIR, (String)name);
            this._appendData(sound, name, path, "mid");
        }
    }

    private void _makeFontNode(Element subbook) {
        Element font = this._appendElement(subbook, "font");
        File gaiji = new File(this._basedir, WDIC_GAIJI_DIR);
        for (Map.Entry<String, String> entry : this._gaijiMap.entrySet()) {
            String name = entry.getKey();
            String type = entry.getValue();
            File file = new File(gaiji, name + ".xbm");
            if (!file.exists()) {
                this._log.error((Object)("file not found: " + file.getPath()));
            }
            String path = FilenameUtils.concat((String)WDIC_GAIJI_DIR, (String)file.getName());
            Element charElem = this._appendElement(font, "char");
            charElem.setAttribute("name", name);
            charElem.setAttribute("type", type);
            Element dataElem = this._appendElement(charElem, "data");
            dataElem.setAttribute("size", "16");
            dataElem.setAttribute("src", path);
        }
    }

    private void _makeContentNode(Element subbook) {
        Element content = this._appendElement(subbook, "content");
        this._log.info((Object)"create item node...");
        Collection<WdicGroup> groups = this._groupList.getGroups();
        for (WdicGroup group : groups) {
            List<Wdic> dics = group.getWdics();
            int len1 = dics.size();
            for (int i = 0; i < len1; ++i) {
                Wdic dic = dics.get(i);
                List<WdicItem> items = dic.getWdicItems();
                int len2 = items.size();
                for (int j = 0; j < len2; ++j) {
                    WdicItem item = items.get(j);
                    this._makeItemNode(content, item);
                }
            }
        }
        this._makeItemNode(content);
        this._log.info((Object)"create menu node...");
        this._makeMenuNode(content);
        this._log.info((Object)"create copyright node...");
        this._makeCopyrightNode(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _makeItemNode(Element content, WdicItem item) {
        List<String> speechList;
        Map<String, String> pronMap;
        String str;
        int i;
        String grpId = item.getWdic().getGroupId();
        String grpName = item.getWdic().getGroupName();
        String partName = item.getWdic().getPartName();
        String partId = item.getWdic().getPartId();
        String head = item.getHead();
        this._log.debug((Object)("  [" + grpId + ":" + partId + "] " + head));
        Element itemElem = this._appendItem(content, "WDIC:" + grpId + ":" + head);
        Element headElem = this._appendElement(itemElem, "head");
        this._appendRawText(headElem, head + " \u3010" + grpName + "\uff1a" + partName + "\u3011");
        boolean wordAvail = false;
        if (WordUtil.isValidWord((String)head)) {
            Element wordElem = this._appendElement(itemElem, "word");
            this._appendRawText(wordElem, head);
            wordAvail = true;
        }
        List<String> yomiList = item.getYomi();
        int n = yomiList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String yomi = yomiList.get(i2);
            String word = WdicUtil.unescape(yomi);
            if ("???".equals(yomi) || head.equals(word) || !WordUtil.isValidWord((String)word)) continue;
            Element wordElem = this._appendElement(itemElem, "word");
            this._appendRawText(wordElem, word);
            wordAvail = true;
        }
        Map<String, String> spellMap = item.getSpell();
        for (Map.Entry<String, String> entry : spellMap.entrySet()) {
            String str2 = WdicUtil.unescape(entry.getValue());
            if (!StringUtils.isAsciiPrintable((String)str2)) continue;
            int idx = str2.indexOf(": ");
            if (idx > 0) {
                String ss = str2.substring(0, idx).trim();
                if (!head.equals(ss) && WordUtil.isValidWord((String)ss)) {
                    Element wordElem = this._appendElement(itemElem, "word");
                    this._appendRawText(wordElem, ss);
                    wordAvail = true;
                }
                str2 = str2.substring(idx + 2).trim();
            }
            if (head.equals(str2) || !WordUtil.isValidWord((String)str2)) continue;
            Element wordElem = this._appendElement(itemElem, "word");
            this._appendRawText(wordElem, str2);
            wordAvail = true;
        }
        if (!wordAvail) {
            this._log.warn((Object)("word not defined: " + grpId + ":" + partId + ":" + head));
        }
        Element bodyElem = this._appendElement(itemElem, "body");
        Element keyElem = this._appendElement(bodyElem, "key");
        this._appendRawText(keyElem, head);
        this._appendRawText(bodyElem, " \u3010");
        Element refElem = this._appendIdReference(bodyElem, "MENU:group:" + grpId);
        this._appendRawText(refElem, grpName);
        this._appendRawText(bodyElem, "\uff1a");
        refElem = this._appendIdReference(bodyElem, "MENU:group:" + grpId + ":" + partId);
        this._appendRawText(refElem, partName + "\u7de8");
        this._appendRawText(bodyElem, "\u3011");
        this._appendNewLine(bodyElem);
        List<String> dirs = item.getDir();
        n = dirs.size();
        for (i = 0; i < n; ++i) {
            refElem = this._appendIdReference(bodyElem, "DIR:/");
            this._appendRawText(refElem, "\u5206\u985e");
            this._appendRawText(bodyElem, "\uff1a");
            str = dirs.get(i);
            if (str.startsWith("/")) {
                str = str.substring(1);
            }
            String[] ss = str.split("/");
            String key = "";
            int m = ss.length;
            for (int j = 0; j < m; ++j) {
                if (j != 0) {
                    this._appendRawText(bodyElem, " > ");
                }
                key = key + "/" + ss[j];
                refElem = this._appendIdReference(bodyElem, "DIR:" + key);
                this._appendRawText(refElem, this._dirList.getName(key));
            }
            this._appendNewLine(bodyElem);
        }
        if (!yomiList.isEmpty()) {
            n = yomiList.size();
            for (i = 0; i < n; ++i) {
                str = "\u8aad\u307f\uff1a" + yomiList.get(i);
                this._appendText(item, bodyElem, str);
                this._appendNewLine(bodyElem);
            }
        }
        if (!spellMap.isEmpty()) {
            for (Map.Entry<String, String> entry : spellMap.entrySet()) {
                str = "\u5916\u8a9e\uff1a[" + entry.getKey() + "] " + entry.getValue();
                this._appendText(item, bodyElem, str);
                this._appendNewLine(bodyElem);
            }
        }
        if (!(pronMap = item.getPronounce()).isEmpty()) {
            for (Map.Entry<String, String> entry : pronMap.entrySet()) {
                String str3 = "\u767a\u97f3\uff1a[" + entry.getKey() + "] " + entry.getValue();
                this._appendRawText(bodyElem, str3);
                this._appendNewLine(bodyElem);
            }
        }
        if (!(speechList = item.getSpeech()).isEmpty()) {
            StringBuilder buf = new StringBuilder("\u54c1\u8a5e\uff1a");
            n = speechList.size();
            for (int i3 = 0; i3 < n; ++i3) {
                if (i3 > 0) {
                    buf.append(",");
                }
                buf.append(speechList.get(i3));
            }
            this._appendRawText(bodyElem, buf.toString());
            this._appendNewLine(bodyElem);
        }
        this._appendNewLine(bodyElem);
        Stack<Element> indentStack = new Stack<Element>();
        int curIndent = 0;
        int ignoreTabs = 0;
        int section = 0;
        int tableNum = 0;
        Element indentElem = this._appendElement(bodyElem, "indent");
        HashMap<Integer, Integer> numMap = new HashMap<Integer, Integer>();
        boolean linkBlock = false;
        List<String> bodyList = item.getBody();
        n = bodyList.size();
        block18: for (int i4 = 0; i4 < n; ++i4) {
            String body = bodyList.get(i4);
            String block = WdicUtil.deleteTab(body);
            if ("//LINK".equals(block)) {
                while (!indentStack.isEmpty()) {
                    indentElem = (Element)indentStack.pop();
                }
                this._appendNewLine(indentElem);
                linkBlock = true;
                curIndent = 0;
                ignoreTabs = 1;
                continue;
            }
            int indent = WdicUtil.getTabCount(body);
            if (block.startsWith("= ")) {
                section = indent;
                ignoreTabs = indent + 1;
                indent = 0;
                curIndent = 0;
                while (!indentStack.isEmpty()) {
                    indentElem = (Element)indentStack.pop();
                }
            } else {
                if ((indent -= ignoreTabs) < 0) {
                    indent = 0;
                }
                if (block.startsWith("+ ")) {
                    numMap.put(-1, indent);
                    if (numMap.size() > 1) {
                        indent = curIndent;
                    }
                } else {
                    numMap.clear();
                }
            }
            if (curIndent < indent) {
                while (curIndent != indent) {
                    indentStack.push(indentElem);
                    indentElem = this._appendElement(indentElem, "indent");
                    ++curIndent;
                }
            } else if (curIndent > indent) {
                while (curIndent != indent) {
                    indentElem = (Element)indentStack.pop();
                    --curIndent;
                }
            }
            if (linkBlock) {
                this._appendItemLinkBlock(item, indentElem, block);
                this._appendNewLine(indentElem);
                continue;
            }
            if (block.startsWith("))")) {
                this._appendNewLine(indentElem);
                while (i4 < n) {
                    body = bodyList.get(i4);
                    block = WdicUtil.deleteTab(body);
                    if (!block.startsWith("))")) {
                        --i4;
                        break;
                    }
                    if (block.startsWith(")) ")) {
                        Element nobr = this._appendElement(indentElem, "nobr");
                        this._appendText(item, nobr, block.substring(3));
                    }
                    this._appendNewLine(indentElem);
                    ++i4;
                }
                this._appendNewLine(indentElem);
                continue;
            }
            if (block.startsWith(">>")) {
                Element indentElem2 = this._appendElement(indentElem, "indent");
                while (i4 < n) {
                    body = bodyList.get(i4);
                    block = WdicUtil.deleteTab(body);
                    if (!block.startsWith(">>")) {
                        --i4;
                        continue block18;
                    }
                    if (block.startsWith(">> ")) {
                        this._appendText(item, indentElem2, block.substring(3));
                    }
                    this._appendNewLine(indentElem2);
                    ++i4;
                }
                continue;
            }
            if (block.startsWith(":: ")) {
                while (i4 < n) {
                    body = bodyList.get(i4);
                    block = WdicUtil.deleteTab(body);
                    if (!block.startsWith(":: ")) {
                        --i4;
                        continue block18;
                    }
                    int idx = WdicUtil.indexOf(block, "|", 3);
                    String dt = block.substring(3, idx).trim();
                    String dd = block.substring(idx + 1).trim();
                    this._appendText(item, indentElem, "\u30fb " + dt);
                    this._appendNewLine(indentElem);
                    Element indentElem2 = this._appendElement(indentElem, "indent");
                    this._appendText(item, indentElem2, dd);
                    this._appendNewLine(indentElem2);
                    ++i4;
                }
                continue;
            }
            if (block.startsWith(": ")) {
                int tab = curIndent;
                boolean term = false;
                Element indentElem2 = null;
                ++i4;
                while (i4 < n) {
                    body = bodyList.get(i4);
                    int t = WdicUtil.getTabCount(body) - ignoreTabs;
                    if (t <= tab) {
                        --i4;
                        continue block18;
                    }
                    block = WdicUtil.deleteTab(body);
                    if (block.startsWith("+ ")) {
                        numMap.put(-1, t);
                    } else {
                        numMap.clear();
                    }
                    if (block.startsWith(":>")) {
                        if (indentElem2 != null) {
                            indentElem2 = null;
                        }
                        term = true;
                        String dt = block.substring(2).trim();
                        if (StringUtils.isNotBlank((String)dt)) {
                            this._appendText(item, indentElem, "\u30fb " + dt);
                            this._appendNewLine(indentElem);
                        }
                    } else if (block.startsWith(":<")) {
                        if (indentElem2 == null) {
                            indentElem2 = this._appendElement(indentElem, "indent");
                        }
                        term = false;
                        String dd = block.substring(2).trim();
                        if (StringUtils.isNotBlank((String)dd)) {
                            this._appendText(item, indentElem2, dd);
                            this._appendNewLine(indentElem2);
                        }
                    } else if (term) {
                        this._appendItemBodyBlock(item, indentElem, block, numMap, "\u30fb ");
                        this._appendNewLine(indentElem);
                    } else {
                        this._appendItemBodyBlock(item, indentElem2, block, numMap, null);
                        this._appendNewLine(indentElem2);
                    }
                    ++i4;
                }
                continue;
            }
            if (block.startsWith("| ")) {
                String name;
                File file;
                File dir;
                ++tableNum;
                WdicTable table = new WdicTable(item);
                table.add(block);
                int tab = curIndent;
                ++i4;
                while (i4 < n) {
                    body = bodyList.get(i4);
                    int t = WdicUtil.getTabCount(body) - ignoreTabs;
                    if (t <= tab) {
                        --i4;
                        break;
                    }
                    block = WdicUtil.deleteTab(body);
                    table.add(block);
                    ++i4;
                }
                if (!(dir = new File(this._basedir, WDIC_TABLE_DIR)).exists()) {
                    dir.mkdirs();
                }
                if (!(file = new File(dir, (name = grpId + "_" + partId + "_" + item.getIndex() + "-" + tableNum) + ".bmp")).exists()) {
                    BufferedImage img = table.getImage();
                    try {
                        BmpUtil.write((BufferedImage)img, (File)file);
                    }
                    catch (IOException e) {
                        this._log.error((Object)e.getMessage(), (Throwable)e);
                        file.delete();
                    }
                    finally {
                        if (img != null) {
                            img.flush();
                        }
                    }
                }
                if (!this._tableList.contains(name)) {
                    this._tableList.add(name);
                }
                Element elem = this._appendDataReference(indentElem, file.getName(), "graphic");
                this._appendRawText(elem, "[\u8868]");
                this._appendNewLine(indentElem);
                continue;
            }
            if (block.startsWith("|| ") || block.startsWith("|= ")) {
                String name;
                File file;
                File dir;
                ++tableNum;
                WdicTable table = new WdicTable(item);
                table.add(block);
                ++i4;
                while (i4 < n) {
                    body = bodyList.get(i4);
                    block = WdicUtil.deleteTab(body);
                    if (!block.startsWith("|| ") && !block.startsWith("|= ")) {
                        --i4;
                        break;
                    }
                    table.add(block);
                    ++i4;
                }
                if (!(dir = new File(this._basedir, WDIC_TABLE_DIR)).exists()) {
                    dir.mkdirs();
                }
                if (!(file = new File(dir, (name = grpId + "_" + partId + "_" + item.getIndex() + "-" + tableNum) + ".bmp")).exists()) {
                    BufferedImage img = table.getImage();
                    try {
                        BmpUtil.write((BufferedImage)img, (File)file);
                    }
                    catch (IOException e) {
                        this._log.error((Object)e.getMessage(), (Throwable)e);
                        file.delete();
                    }
                    finally {
                        if (img != null) {
                            img.flush();
                        }
                    }
                }
                if (!this._tableList.contains(name)) {
                    this._tableList.add(name);
                }
                Element elem = this._appendDataReference(indentElem, file.getName(), "graphic");
                this._appendRawText(elem, "[\u8868]");
                this._appendNewLine(indentElem);
                continue;
            }
            if (block.startsWith("= ")) {
                int j;
                String prev;
                if (i4 > 0 && !(prev = WdicUtil.deleteTab(bodyList.get(i4 - 1))).startsWith("= ")) {
                    this._appendNewLine(indentElem);
                }
                StringBuilder buf = new StringBuilder();
                int black = 5 - section;
                int white = section;
                for (j = 0; j < white; ++j) {
                    buf.append('\u25a1');
                }
                for (j = 0; j < black; ++j) {
                    buf.append('\u25a0');
                }
                buf.append(" ");
                buf.append(block.substring(2));
                buf.append(" ");
                for (j = 0; j < black; ++j) {
                    buf.append('\u25a0');
                }
                for (j = 0; j < white; ++j) {
                    buf.append('\u25a1');
                }
                this._appendText(item, indentElem, buf.toString());
                this._appendNewLine(indentElem);
                continue;
            }
            this._appendItemBodyBlock(item, indentElem, block, numMap, null);
            this._appendNewLine(indentElem);
        }
    }

    private void _appendItemBodyBlock(WdicItem item, Element elem, String block, Map<Integer, Integer> numMap, String prefix) {
        if (block.startsWith("* ")) {
            block = "\u25c6 " + block.substring(2);
        } else if (block.startsWith("- ")) {
            block = "\u30fb " + block.substring(2);
        } else if (block.startsWith("+ ")) {
            int indent = numMap.get(-1);
            int val = 1;
            if (numMap.containsKey(indent)) {
                val = numMap.get(indent) + 1;
            }
            String num = Integer.toString(val);
            numMap.put(indent, val);
            int lower = indent + 1;
            while (numMap.containsKey(lower)) {
                numMap.remove(lower);
                ++lower;
            }
            for (int upper = indent - 1; upper >= 0 && numMap.containsKey(upper); --upper) {
                num = numMap.get(upper) + "." + num;
            }
            block = num + ") " + block.substring(2);
        } else if (block.startsWith("=> ")) {
            block = "\u21d2 " + block.substring(3);
        }
        if (prefix != null) {
            block = prefix + block;
        }
        this._appendText(item, elem, block);
    }

    private void _appendItemLinkBlock(WdicItem item, Element elem, String block) {
        if (block.startsWith("= ")) {
            this._appendNewLine(elem);
            block = "\u25bc " + block.substring(2);
        } else if (block.startsWith("- ")) {
            block = "\u21d2 " + block.substring(2);
        } else if (block.startsWith("-! ")) {
            block = "\u21d4 " + block.substring(3);
        }
        this._appendText(item, elem, block, true);
    }

    private void _makeItemNode(Element content) {
        String title;
        String part;
        String gname;
        String id;
        String grpId;
        String head;
        Set<WdicItem> set;
        Element refElem;
        Element keyElem;
        Element bodyElem;
        Element keywordElem;
        Element headElem;
        Element itemElem;
        String name;
        int i;
        this._log.debug((Object)"  graphic plugin");
        String[] ext = new String[]{".jpg", ".png"};
        int len = ext.length;
        for (i = 0; i < len; ++i) {
            for (Map.Entry<String, Set<WdicItem>> entry : this._pluginMap.entrySet()) {
                name = entry.getKey();
                if (!name.endsWith(ext[i])) continue;
                itemElem = this._appendItem(content, "PLUGIN:" + name);
                headElem = this._appendElement(itemElem, "head");
                this._appendRawText(headElem, name + " \u3010\u30d7\u30e9\u30b0\u30a4\u30f3\u3011");
                keywordElem = this._appendElement(itemElem, "keyword");
                this._appendRawText(keywordElem, name);
                bodyElem = this._appendElement(itemElem, "body");
                keyElem = this._appendElement(bodyElem, "key");
                this._appendRawText(keyElem, name);
                this._appendNewLine(bodyElem);
                refElem = this._appendDataReference(bodyElem, name, "graphic");
                this._appendRawText(refElem, "[\u56f3\u7248]");
                this._appendNewLine(bodyElem);
                set = entry.getValue();
                for (WdicItem item : set) {
                    this._appendRawText(bodyElem, "\u2192 ");
                    head = item.getHead();
                    grpId = item.getWdic().getGroupId();
                    id = "WDIC:" + grpId + ":" + head;
                    refElem = this._appendIdReference(bodyElem, id);
                    gname = item.getWdic().getGroupName();
                    part = item.getWdic().getPartName();
                    title = head + " \u300a" + gname + "\uff1a" + part + "\u300b";
                    this._appendRawText(refElem, title);
                    this._appendNewLine(bodyElem);
                }
            }
        }
        this._log.debug((Object)"  sound plugin");
        ext = new String[]{".mp3", ".ogg", ".mid"};
        len = ext.length;
        for (i = 0; i < len; ++i) {
            for (Map.Entry<String, Set<WdicItem>> entry : this._pluginMap.entrySet()) {
                name = entry.getKey();
                if (!name.endsWith(ext[i])) continue;
                itemElem = this._appendItem(content, "PLUGIN:" + name);
                headElem = this._appendElement(itemElem, "head");
                this._appendRawText(headElem, name + " \u3010\u30d7\u30e9\u30b0\u30a4\u30f3\u3011");
                keywordElem = this._appendElement(itemElem, "keyword");
                this._appendRawText(keywordElem, name);
                bodyElem = this._appendElement(itemElem, "body");
                keyElem = this._appendElement(bodyElem, "key");
                this._appendRawText(keyElem, name);
                this._appendNewLine(bodyElem);
                refElem = this._appendDataReference(bodyElem, name, "sound");
                this._appendRawText(refElem, "[\u97f3\u58f0]");
                this._appendNewLine(bodyElem);
                set = entry.getValue();
                for (WdicItem item : set) {
                    this._appendRawText(bodyElem, "\u2192 ");
                    head = item.getHead();
                    grpId = item.getWdic().getGroupId();
                    id = "WDIC:" + grpId + ":" + head;
                    refElem = this._appendIdReference(bodyElem, id);
                    gname = item.getWdic().getGroupName();
                    part = item.getWdic().getPartName();
                    title = head + " \u300a" + gname + "\uff1a" + part + "\u300b";
                    this._appendRawText(refElem, title);
                    this._appendNewLine(bodyElem);
                }
            }
        }
        this._log.debug((Object)"  document plugin");
        File plugin = new File(this._basedir, WDIC_PLUGIN_DIR);
        ext = new String[]{".jpg", ".png", ".mp3", ".ogg", ".mid"};
        len = ext.length;
        for (Map.Entry<String, Set<WdicItem>> entry : this._pluginMap.entrySet()) {
            name = entry.getKey();
            boolean add = true;
            for (int i2 = 0; i2 < len; ++i2) {
                if (!name.endsWith(ext[i2])) continue;
                add = false;
                break;
            }
            if (!add) continue;
            File file = new File(plugin, name);
            if (!file.exists()) {
                this._log.error((Object)("file not found: " + file.getPath()));
                continue;
            }
            Element itemElem2 = this._appendItem(content, "PLUGIN:" + name);
            Element headElem2 = this._appendElement(itemElem2, "head");
            this._appendRawText(headElem2, name + " \u3010\u30d7\u30e9\u30b0\u30a4\u30f3\u3011");
            Element keywordElem2 = this._appendElement(itemElem2, "keyword");
            this._appendRawText(keywordElem2, name);
            Element bodyElem2 = this._appendElement(itemElem2, "body");
            Element keyElem2 = this._appendElement(bodyElem2, "key");
            this._appendRawText(keyElem2, name);
            this._appendNewLine(bodyElem2);
            Set<WdicItem> set2 = entry.getValue();
            for (WdicItem item : set2) {
                this._appendRawText(bodyElem2, "\u2192 ");
                String head2 = item.getHead();
                String grpId2 = item.getWdic().getGroupId();
                String id2 = "WDIC:" + grpId2 + ":" + head2;
                Element refElem2 = this._appendIdReference(bodyElem2, id2);
                String gname2 = item.getWdic().getGroupName();
                String part2 = item.getWdic().getPartName();
                String title2 = head2 + " \u300a" + gname2 + "\uff1a" + part2 + "\u300b";
                this._appendRawText(refElem2, title2);
                this._appendNewLine(bodyElem2);
            }
            Element indentElem = this._appendElement(bodyElem2, "indent");
            try {
                LineIterator lineIt = FileUtils.lineIterator((File)file, (String)ENCODING);
                while (lineIt.hasNext()) {
                    String line = WdicUtil.sanitize(lineIt.nextLine());
                    this._appendRawText(indentElem, line);
                    this._appendNewLine(indentElem);
                }
            }
            catch (IOException e) {
                this._log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void _makeCopyrightNode(Element content) {
        Element copyright = this._appendElement(content, "copyright");
        String[] line = this._manual.getCopyright();
        int len = line.length;
        for (int i = 0; i < len; ++i) {
            this._appendRawText(copyright, line[i]);
            this._appendNewLine(copyright);
        }
    }

    private void _makeMenuNode(Element content) {
        Element menu = this._appendElement(content, "menu");
        Element layerElem = this._appendLayer(menu, "MENU:top");
        Element refElem = this._appendIdReference(layerElem, "MENU:manual");
        String title = this._groupList.getName() + " " + this._groupList.getEdition();
        this._appendRawText(refElem, title);
        this._appendNewLine(layerElem);
        refElem = this._appendIdReference(layerElem, "MENU:bib");
        this._appendRawText(refElem, "\u57fa\u790e\u6587\u732e");
        this._appendNewLine(layerElem);
        refElem = this._appendIdReference(layerElem, "DIR:/");
        this._appendRawText(refElem, "\u5206\u985e\u5225\u53ce\u9332\u8a9e\u4e00\u89a7");
        this._appendNewLine(layerElem);
        refElem = this._appendIdReference(layerElem, "MENU:group");
        this._appendRawText(refElem, "\u30b0\u30eb\u30fc\u30d7\u5225\u53ce\u9332\u8a9e\u4e00\u89a7");
        this._appendNewLine(layerElem);
        refElem = this._appendIdReference(layerElem, "MENU:plugin");
        this._appendRawText(refElem, "\u30b0\u30eb\u30fc\u30d7\u5225\u30d7\u30e9\u30b0\u30a4\u30f3\u4e00\u89a7");
        this._appendNewLine(layerElem);
        refElem = this._appendIdReference(layerElem, "MENU:image");
        this._appendRawText(refElem, "\u753b\u50cf\u30d7\u30e9\u30b0\u30a4\u30f3\u4e00\u89a7");
        this._appendNewLine(layerElem);
        refElem = this._appendIdReference(layerElem, "MENU:sound");
        this._appendRawText(refElem, "\u97f3\u58f0\u30d7\u30e9\u30b0\u30a4\u30f3\u4e00\u89a7");
        this._appendNewLine(layerElem);
        refElem = this._appendIdReference(layerElem, "MENU:text");
        this._appendRawText(refElem, "\u6587\u66f8\u30d7\u30e9\u30b0\u30a4\u30f3\u4e00\u89a7");
        this._appendNewLine(layerElem);
        this._log.debug((Object)"  manual");
        this._createManualLayer(menu);
        this._log.debug((Object)"  bibliography");
        this._createBibliographyLayer(menu);
        this._log.debug((Object)"  directory");
        this._createDirectoryLayer(menu);
        this._log.debug((Object)"  group");
        this._createGroupLayer(menu);
        this._log.debug((Object)"  plugin list");
        this._createPluginLayer(menu);
        this._log.debug((Object)"  graphic list");
        this._createImageLayer(menu);
        this._log.debug((Object)"  sound list");
        this._createSoundLayer(menu);
        this._log.debug((Object)"  document list");
        this._createTextLayer(menu);
    }

    private void _createManualLayer(Element menu) {
        Element layerElem = this._appendLayer(menu, "MENU:manual");
        String[] sec = this._manual.getSections();
        int len = sec.length;
        for (int i = 0; i < len; ++i) {
            Element refElem = this._appendIdReference(layerElem, "MENU:manual:" + sec[i]);
            this._appendRawText(refElem, sec[i]);
            this._appendNewLine(layerElem);
            String prev = null;
            String next = null;
            if (i > 0) {
                prev = sec[i - 1];
            }
            if (i < len - 1) {
                next = sec[i + 1];
            }
            this._createManualLayer(menu, sec[i], prev, next);
        }
    }

    private void _createManualLayer(Element menu, String sec, String prev, String next) {
        Element layerElem = this._appendLayer(menu, "MENU:manual:" + sec);
        Element keyElem = this._appendElement(layerElem, "key");
        this._appendRawText(keyElem, sec);
        Element indent1Elem = this._appendElement(layerElem, "indent");
        Element indent2Elem = null;
        Element indent3Elem = null;
        Element indentElem = indent1Elem;
        for (String str : this._manual.getContents(sec)) {
            if (str.length() > 0) {
                if (str.startsWith("\t")) {
                    if (indent2Elem == null) {
                        indent2Elem = this._appendElement(indent1Elem, "indent");
                    }
                    if (str.startsWith("\t\t")) {
                        if (indent3Elem == null) {
                            indent3Elem = this._appendElement(indent2Elem, "indent");
                        }
                        str = str.substring(2);
                        indentElem = indent3Elem;
                    } else {
                        str = str.substring(1);
                        indentElem = indent2Elem;
                        indent3Elem = null;
                    }
                } else {
                    indentElem = indent1Elem;
                    indent2Elem = null;
                    indent3Elem = null;
                }
                this._appendRawText(indentElem, str);
            }
            this._appendNewLine(indentElem);
        }
        this._appendNewLine(layerElem);
        if (prev != null) {
            this._appendRawText(layerElem, "\u2190 ");
            Element refElem = this._appendIdReference(layerElem, "MENU:manual:" + prev);
            this._appendRawText(refElem, prev);
            this._appendRawText(layerElem, " | ");
        }
        if (next != null) {
            this._appendRawText(layerElem, "\u2192 ");
            Element refElem = this._appendIdReference(layerElem, "MENU:manual:" + next);
            this._appendRawText(refElem, next);
            this._appendRawText(layerElem, " | ");
        }
        this._appendRawText(layerElem, "\u2191 ");
        String title = this._groupList.getName() + " " + this._groupList.getEdition();
        Element refElem = this._appendIdReference(layerElem, "MENU:manual");
        this._appendRawText(refElem, title);
        this._appendNewLine(layerElem);
    }

    private void _createBibliographyLayer(Element menu) {
        Element layerElem = this._appendLayer(menu, "MENU:bib");
        Collection<WdicGroup> groups = this._groupList.getGroups();
        for (WdicGroup group : groups) {
            Element refElem = this._appendIdReference(layerElem, "MENU:bib:" + group.getGroupId());
            this._appendRawText(refElem, group.getGroupName() + "\u7528\u8a9e\u306e\u57fa\u790e\u77e5\u8b58");
            this._appendNewLine(layerElem);
            this._createBibliographyLayer(menu, group);
        }
    }

    private void _createBibliographyLayer(Element menu, WdicGroup group) {
        Element layerElem = this._appendLayer(menu, "MENU:bib:" + group.getGroupId());
        Element keyElem = this._appendElement(layerElem, "key");
        this._appendRawText(keyElem, group.getGroupName() + "\u7528\u8a9e\u306e\u57fa\u790e\u77e5\u8b58");
        Element indentElem = this._appendElement(layerElem, "indent");
        for (String str : group.getWdicBib().getBibliography()) {
            if (str.length() > 0) {
                this._appendRawText(indentElem, str);
            }
            this._appendNewLine(indentElem);
        }
    }

    private void _createDirectoryLayer(Element menu) {
        Element layerElem = this._appendLayer(menu, "DIR:/");
        List<String> dirs = this._dirList.getChildren("/");
        int len = dirs.size();
        for (int i = 0; i < len; ++i) {
            String dir = dirs.get(i);
            this._appendRawText(layerElem, "\u21d2 ");
            Element refElem = this._appendIdReference(layerElem, "DIR:" + dir);
            this._appendRawText(refElem, this._dirList.getName(dir));
            this._appendNewLine(layerElem);
            this._createDirectoryLayer(menu, dir);
        }
    }

    private void _createDirectoryLayer(Element menu, String dir) {
        Element layerElem = this._appendLayer(menu, "DIR:" + dir);
        Element refElem = this._appendIdReference(layerElem, "DIR:/");
        this._appendRawText(refElem, "\u5206\u985e");
        String[] dirs = null;
        dirs = dir.startsWith("/") ? dir.substring(1).split("/") : dir.split("/");
        String key = "";
        int len = dirs.length;
        for (int i = 0; i < len - 1; ++i) {
            this._appendRawText(layerElem, " > ");
            key = key + "/" + dirs[i];
            refElem = this._appendIdReference(layerElem, "DIR:" + key);
            this._appendRawText(refElem, this._dirList.getName(key));
        }
        this._appendRawText(layerElem, " > " + this._dirList.getName(dir));
        this._appendNewLine(layerElem);
        List<String> children = this._dirList.getChildren(dir);
        int cnt = len = children.size();
        for (int i = 0; i < len; ++i) {
            String child = children.get(i);
            this._appendRawText(layerElem, "\u21d2 ");
            if (this._dirList.hasAlias(child)) {
                String alias = this._dirList.getAlias(child);
                refElem = this._appendIdReference(layerElem, "DIR:" + alias);
                this._appendRawText(refElem, this._dirList.getName(child) + "@");
                this._appendNewLine(layerElem);
                continue;
            }
            refElem = this._appendIdReference(layerElem, "DIR:" + child);
            this._appendRawText(refElem, this._dirList.getName(child));
            this._appendNewLine(layerElem);
            this._createDirectoryLayer(menu, child);
        }
        List<WdicItem> items = this._groupList.getWdicItem(dir);
        len = items.size();
        cnt += len;
        for (int i = 0; i < len; ++i) {
            WdicItem item = items.get(i);
            this._appendRawText(layerElem, "\u2192 ");
            String head = item.getHead();
            String grpId = item.getWdic().getGroupId();
            String id = "WDIC:" + grpId + ":" + head;
            refElem = this._appendIdReference(layerElem, id);
            String gname = item.getWdic().getGroupName();
            String part = item.getWdic().getPartName();
            String title = head + " \u300a" + gname + "\uff1a" + part + "\u300b";
            this._appendRawText(refElem, title);
            this._appendNewLine(layerElem);
        }
        if (cnt == 0) {
            this._appendRawText(layerElem, "(\u8a72\u5f53\u5358\u8a9e\u306a\u3057)");
            this._appendNewLine(layerElem);
        }
    }

    private void _createGroupLayer(Element menu) {
        String id = "MENU:group";
        Element layerElem = this._appendLayer(menu, id);
        Collection<WdicGroup> groups = this._groupList.getGroups();
        for (WdicGroup group : groups) {
            Element refElem = this._appendIdReference(layerElem, id + ":" + group.getGroupId());
            this._appendRawText(refElem, group.getGroupName() + "\u7528\u8a9e\u306e\u57fa\u790e\u77e5\u8b58");
            this._appendNewLine(layerElem);
            this._createGroupLayer(menu, group);
        }
    }

    private void _createGroupLayer(Element menu, WdicGroup group) {
        String id = "MENU:group:" + group.getGroupId();
        Element layerElem = this._appendLayer(menu, id);
        Element refElem = this._appendIdReference(layerElem, "MENU:group");
        this._appendRawText(refElem, "\u30b0\u30eb\u30fc\u30d7");
        this._appendRawText(layerElem, " > " + group.getGroupName());
        this._appendNewLine(layerElem);
        List<Wdic> dics = group.getWdics();
        int len = dics.size();
        for (int i = 0; i < len; ++i) {
            Wdic wdic = dics.get(i);
            String name = wdic.getPartName() + "\u7de8";
            refElem = this._appendIdReference(layerElem, id + ":" + wdic.getPartId());
            this._appendRawText(refElem, name);
            this._appendNewLine(layerElem);
            this._createGroupLayer(menu, wdic);
        }
    }

    private void _createGroupLayer(Element menu, Wdic wdic) {
        String grpId = wdic.getGroupId();
        String partId = wdic.getPartId();
        String id = "MENU:group:" + grpId + ":" + partId;
        Element layerElem = this._appendLayer(menu, id);
        Element refElem = this._appendIdReference(layerElem, "MENU:group");
        this._appendRawText(refElem, "\u30b0\u30eb\u30fc\u30d7");
        refElem = this._appendIdReference(layerElem, "MENU:group:" + grpId);
        this._appendRawText(refElem, " > " + wdic.getGroupName());
        this._appendRawText(layerElem, " > " + wdic.getPartName() + "\u7de8");
        this._appendNewLine(layerElem);
        List<WdicItem> items = wdic.getWdicItems();
        int len = items.size();
        for (int i = 0; i < len; ++i) {
            String yomi;
            String name;
            WdicItem item = items.get(i);
            if (item.isAlias()) {
                name = item.getHead();
                this._appendRawText(layerElem, name);
                yomi = item.getYomi().get(0);
                this._appendText(item, layerElem, " [" + yomi + "]");
                this._appendRawText(layerElem, " \u21d2 ");
                name = item.getRealName();
                String refid = WdicUtil.unescape(name);
                id = "WDIC:" + grpId + ":" + refid;
                refElem = this._appendIdReference(layerElem, id);
                this._appendText(item, refElem, name);
                this._appendNewLine(layerElem);
                continue;
            }
            name = item.getHead();
            id = "WDIC:" + grpId + ":" + name;
            refElem = this._appendIdReference(layerElem, id);
            this._appendRawText(refElem, name);
            yomi = item.getYomi().get(0);
            this._appendText(item, layerElem, " [" + yomi + "]");
            this._appendNewLine(layerElem);
        }
    }

    private void _createPluginLayer(Element menu) {
        String id = "MENU:plugin";
        Element layerElem = this._appendLayer(menu, id);
        Collection<WdicGroup> groups = this._groupList.getGroups();
        for (WdicGroup group : groups) {
            Element refElem = this._appendIdReference(layerElem, id + ":" + group.getGroupId());
            this._appendRawText(refElem, group.getGroupName() + "\u7528\u8a9e\u306e\u57fa\u790e\u77e5\u8b58");
            this._appendNewLine(layerElem);
            this._createPluginLayer(menu, group);
        }
    }

    private void _createPluginLayer(Element menu, WdicGroup group) {
        String id = "MENU:plugin:" + group.getGroupId();
        Element layerElem = this._appendLayer(menu, id);
        Element refElem = this._appendIdReference(layerElem, "MENU:plugin");
        this._appendRawText(refElem, "\u30b0\u30eb\u30fc\u30d7");
        this._appendRawText(layerElem, " > " + group.getGroupName());
        this._appendNewLine(layerElem);
        for (Map.Entry<String, Set<WdicItem>> entry : this._pluginMap.entrySet()) {
            String name = entry.getKey();
            Set<WdicItem> items = entry.getValue();
            Iterator<WdicItem> itemIt = items.iterator();
            boolean include = false;
            while (itemIt.hasNext()) {
                WdicItem item = itemIt.next();
                if (!group.equals(item.getWdic().getGroup())) continue;
                include = true;
                break;
            }
            if (!include) continue;
            refElem = this._appendIdReference(layerElem, "PLUGIN:" + name);
            this._appendRawText(refElem, name);
            this._appendNewLine(layerElem);
        }
    }

    private void _createImageLayer(Element menu) {
        Element layerElem = this._appendLayer(menu, "MENU:image");
        String[] ext = new String[]{".jpg", ".png"};
        for (Map.Entry<String, Set<WdicItem>> entry : this._pluginMap.entrySet()) {
            String name = entry.getKey();
            int n = ext.length;
            boolean image = false;
            for (int i = 0; i < n; ++i) {
                if (!name.endsWith(ext[i])) continue;
                image = true;
                break;
            }
            if (!image) continue;
            Element refElem = this._appendIdReference(layerElem, "PLUGIN:" + name);
            this._appendRawText(refElem, name);
            this._appendNewLine(layerElem);
        }
    }

    private void _createSoundLayer(Element menu) {
        Element layerElem = this._appendLayer(menu, "MENU:sound");
        String[] ext = new String[]{".mp3", ".ogg", ".mid"};
        for (Map.Entry<String, Set<WdicItem>> entry : this._pluginMap.entrySet()) {
            String name = entry.getKey();
            int n = ext.length;
            boolean sound = false;
            for (int i = 0; i < n; ++i) {
                if (!name.endsWith(ext[i])) continue;
                sound = true;
                break;
            }
            if (!sound) continue;
            Element refElem = this._appendIdReference(layerElem, "PLUGIN:" + name);
            this._appendRawText(refElem, name);
            this._appendNewLine(layerElem);
        }
    }

    private void _createTextLayer(Element menu) {
        Element layerElem = this._appendLayer(menu, "MENU:text");
        String[] ext = new String[]{".jpg", ".png", ".mp3", ".ogg", ".mid"};
        for (Map.Entry<String, Set<WdicItem>> entry : this._pluginMap.entrySet()) {
            String name = entry.getKey();
            int n = ext.length;
            boolean text = true;
            for (int i = 0; i < n; ++i) {
                if (!name.endsWith(ext[i])) continue;
                text = false;
                break;
            }
            if (!text) continue;
            Element refElem = this._appendIdReference(layerElem, "PLUGIN:" + name);
            this._appendRawText(refElem, name);
            this._appendNewLine(layerElem);
        }
    }

    private void _appendRawText(Node node, String str) {
        if (str != null && str.trim().length() > 0) {
            Text text = node.getOwnerDocument().createTextNode(str);
            node.appendChild(text);
            this._checkCharacter(text);
        }
    }

    private Element _appendElement(Node node, String tag) {
        Element elem = node.getOwnerDocument().createElement(tag);
        return (Element)node.appendChild(elem);
    }

    private Element _appendNewLine(Node node) {
        return this._appendElement(node, "br");
    }

    private Element _appendItem(Node node, String id) {
        Element elem = this._appendElement(node, "item");
        elem.setAttribute("id", id);
        return elem;
    }

    private Element _appendIdReference(Node node, String id) {
        Element elem = this._appendElement(node, "ref");
        elem.setAttribute("id", id);
        return elem;
    }

    private Element _appendDataReference(Node node, String data, String type) {
        Element elem = this._appendElement(node, "ref");
        elem.setAttribute("data", data);
        elem.setAttribute("type", type);
        return elem;
    }

    private Element _appendCharReference(Node node, String name, String type) {
        Element elem = this._appendElement(node, "char");
        elem.setAttribute("name", name);
        elem.setAttribute("type", type);
        return elem;
    }

    private Element _appendLayer(Node node, String id) {
        Element elem = this._appendElement(node, "layer");
        elem.setAttribute("id", id);
        return elem;
    }

    private Element _appendData(Node node, String name, String src, String format) {
        Element elem = this._appendElement(node, "data");
        elem.setAttribute("name", name);
        elem.setAttribute("src", src);
        elem.setAttribute("format", format);
        return elem;
    }

    private void _appendText(WdicItem item, Node node, String str) {
        this._appendText(item, node, str, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _appendText(WdicItem item, Node node, String str, boolean linkBlock) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            String type;
            BufferedImage img;
            File file;
            File dir;
            String fontname;
            String hex;
            int n;
            char ch = str.charAt(i);
            if (Character.isHighSurrogate(ch) || Character.isLowSurrogate(ch)) {
                buf.append(ch);
                continue;
            }
            if (ch == '\'') {
                int idx1;
                String bracket = "'";
                for (idx1 = i + 1; idx1 < len && str.charAt(idx1) == '\''; ++idx1) {
                    bracket = bracket + "'";
                }
                if (bracket.length() > 1) {
                    int idx2 = WdicUtil.indexOf(str, bracket, idx1);
                    if (idx2 != -1) {
                        this._appendRawText(node, buf.toString());
                        buf.delete(0, buf.length());
                        Element elem = this._appendElement(node, "em");
                        this._appendText(item, elem, str.substring(idx1, idx2), linkBlock);
                        i = idx2 + bracket.length() - 1;
                        continue;
                    }
                    buf.append(bracket);
                    i = idx1 - 1;
                    continue;
                }
            } else if (ch == '[' && i + 1 < len && str.charAt(i + 1) == '[') {
                int idx1 = i + 1;
                int idx2 = WdicUtil.indexOf(str, "]]", idx1 + 1);
                if (idx2 != -1) {
                    int idx3;
                    this._appendRawText(node, buf.toString());
                    buf.delete(0, buf.length());
                    String ref = str.substring(idx1 + 1, idx2);
                    String name = null;
                    if (ref.startsWith("<") && (idx3 = WdicUtil.indexOf(ref, ">", 1)) != -1) {
                        name = ref.substring(1, idx3);
                        ref = ref.substring(idx3 + 1);
                    }
                    if (ref.startsWith("http:") || ref.startsWith("https:") || ref.startsWith("ftp:") || ref.startsWith("news:") || ref.startsWith("gopher:") || ref.startsWith("mailto:") || ref.startsWith("phone:") || ref.startsWith("urn:") || ref.startsWith("x-geo:")) {
                        if (StringUtils.isNotBlank(name)) {
                            ref = linkBlock ? name + " <" + ref + ">" : name + "<" + ref + ">";
                        }
                        this._appendText(item, node, ref, linkBlock);
                    } else if (ref.startsWith("//")) {
                        WdicGroup group;
                        idx3 = ref.indexOf("|");
                        if (idx3 > 0) {
                            ref = ref.substring(0, idx3);
                        }
                        String gid = null;
                        String file2 = null;
                        idx3 = ref.indexOf("/", 2);
                        if (idx3 != -1) {
                            gid = ref.substring(2, idx3);
                            file2 = ref.substring(idx3 + 1);
                        } else {
                            gid = item.getWdic().getGroup().getGroupId();
                            file2 = ref.substring(2);
                        }
                        Element refElem = null;
                        refElem = file2.endsWith(".jpg") || file2.endsWith(".png") ? this._appendDataReference(node, file2, "graphic") : (file2.endsWith(".mp3") || file2.endsWith(".ogg") || file2.endsWith(".mid") ? this._appendDataReference(node, file2, "sound") : this._appendIdReference(node, "PLUGIN:" + file2));
                        if (StringUtils.isBlank((String)name)) {
                            name = file2;
                        }
                        if (linkBlock && (group = this._groupList.getGroup(gid)) != null) {
                            String gname = group.getGroupName();
                            name = name + " \u300a" + gname + "\u300b";
                        }
                        this._appendRawText(refElem, name);
                    } else {
                        WdicGroup group;
                        if (ref.startsWith("x-wdic:")) {
                            ref = ref.substring("x-wdic:".length());
                        }
                        String gid = null;
                        String head = null;
                        if (ref.startsWith("/")) {
                            int idx32 = WdicUtil.indexOf(ref, "/", 1);
                            if (idx32 != -1) {
                                gid = ref.substring(1, idx32);
                                head = ref.substring(idx32 + 1);
                            } else {
                                head = ref.substring(1);
                            }
                        } else {
                            head = ref;
                        }
                        String refid = WdicUtil.unescape(head);
                        if (StringUtils.isBlank((String)name)) {
                            name = head;
                        }
                        if (StringUtils.isBlank(gid)) {
                            gid = item.getWdic().getGroup().getGroupId();
                        }
                        if ((group = this._groupList.getGroup(gid)) != null) {
                            String gname = group.getGroupName();
                            Wdic wdic = group.getWdic(refid);
                            if (wdic != null) {
                                String id = "WDIC:" + gid + ":" + refid;
                                Element refElem = this._appendIdReference(node, id);
                                if (linkBlock) {
                                    name = name + " \u300a" + gname + "\uff1a" + wdic.getPartName() + "\u300b";
                                }
                                this._appendText(item, refElem, name, linkBlock);
                            } else {
                                this._log.error((Object)("undefined word: " + gid + "/" + refid));
                                if (linkBlock) {
                                    name = name + " \u300a" + gname + "\u300b";
                                }
                                this._appendText(item, node, name, linkBlock);
                            }
                        } else {
                            this._log.error((Object)("undefined group: " + gid));
                            this._appendText(item, node, name, linkBlock);
                        }
                    }
                    i = idx2 + 1;
                    continue;
                }
                buf.append("[[");
                i = idx1;
                continue;
            }
            if (ch != '\\') {
                buf.append(ch);
                continue;
            }
            if (i + 1 >= len) {
                buf.append(ch);
                continue;
            }
            char ch1 = str.charAt(i + 1);
            if (ch1 >= '!' && ch1 <= '~' && !CharUtils.isAsciiAlphanumeric((char)ch1)) {
                ++i;
                buf.append(ch1);
                continue;
            }
            int idx = WdicUtil.indexOf(str, ";", i + 1);
            if (idx < 0) {
                this._log.error((Object)("unexpected format: " + str));
                buf.append(ch);
                continue;
            }
            String ref = str.substring(i + 1, idx);
            i = idx;
            int sep1 = WdicUtil.indexOf(ref, "{", 0);
            int sep2 = WdicUtil.indexOf(ref, ":", 0);
            if (sep1 == -1 && sep2 == -1) {
                buf.append(WdicUtil.getCharacter(ref));
                continue;
            }
            String name = null;
            ArrayList<String> param = new ArrayList<String>();
            if (sep1 != -1 && sep2 != -1) {
                if (sep2 < sep1) {
                    sep1 = -1;
                } else {
                    sep2 = -1;
                }
            }
            if (sep1 != -1) {
                name = ref.substring(0, sep1);
                int idx1 = sep1;
                int idx2 = -1;
                while (idx1 != -1) {
                    idx2 = ref.indexOf(125, idx1 + 1);
                    if (idx2 == -1) {
                        idx2 = ref.length();
                    }
                    param.add(ref.substring(idx1 + 1, idx2));
                    idx1 = ref.indexOf(123, idx2 + 1);
                }
            } else {
                name = ref.substring(0, sep2);
                String[] arg = ref.substring(sep2 + 1).split(":");
                n = arg.length;
                for (int j = 0; j < n; ++j) {
                    param.add(arg[j]);
                }
            }
            if ("x".equals(name)) {
                String code = (String)param.get(0);
                try {
                    int codePoint = Integer.parseInt(code, 16);
                    buf.appendCodePoint(codePoint);
                }
                catch (Exception e) {
                    this._log.error((Object)("unknown character code: " + code));
                }
                continue;
            }
            if ("sup".equals(name) || "sub".equals(name)) {
                this._appendRawText(node, buf.toString());
                buf.delete(0, buf.length());
                Element elem = this._appendElement(node, name);
                this._appendText(item, elem, (String)param.get(0), linkBlock);
                continue;
            }
            if ("ruby".equals(name)) {
                this._appendRawText(node, buf.toString());
                buf.delete(0, buf.length());
                this._appendText(item, node, (String)param.get(0), linkBlock);
                if (param.size() <= 1) continue;
                Element elem = this._appendElement(node, "sub");
                this._appendText(item, elem, "(" + (String)param.get(1) + ")", linkBlock);
                continue;
            }
            if ("asin".equals(name)) {
                String asin = (String)param.get(0);
                String url = null;
                switch (asin.charAt(0)) {
                    case '4': {
                        url = "http://www.amazon.co.jp/exec/obidos/ASIN/";
                        break;
                    }
                    case '3': {
                        url = "http://www.amazon.de/exec/obidos/ASIN/";
                        break;
                    }
                    case '2': {
                        url = "http://www.amazon.fr/exec/obidos/ASIN/";
                        break;
                    }
                    case '1': {
                        url = "http://www.amazon.co.uk/exec/obidos/ASIN/";
                        break;
                    }
                    default: {
                        url = "http://www.amazon.com/exec/obidos/ASIN/";
                    }
                }
                buf.append(url + asin);
                continue;
            }
            if ("flag".equals(name)) continue;
            if ("mex".equals(name)) {
                buf.append("[" + (String)param.get(0) + "]");
                continue;
            }
            if ("oline".equals(name)) {
                this._appendRawText(node, buf.toString());
                buf.delete(0, buf.length());
                String pstr = (String)param.get(0);
                n = pstr.length();
                for (int j = 0; j < n; ++j) {
                    int codePoint = pstr.codePointAt(j);
                    hex = HexUtil.toHexString((int)codePoint, (int)6);
                    fontname = "U" + hex + "-OL";
                    dir = new File(this._basedir, WDIC_GAIJI_DIR);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (!(file = new File(dir, fontname + ".xbm")).exists()) {
                        img = WdicUtil.toOverLineImage(codePoint);
                        try {
                            FontUtil.writeXbm((BufferedImage)img, (File)file);
                        }
                        catch (IOException e) {
                            this._log.error((Object)e.getMessage(), (Throwable)e);
                            file.delete();
                        }
                        finally {
                            if (img != null) {
                                img.flush();
                            }
                        }
                    }
                    if ((type = this._gaijiMap.get(fontname)) == null) {
                        type = FontUtil.getFontType((int)codePoint);
                        this._gaijiMap.put(fontname, type);
                    }
                    this._appendCharReference(node, fontname, type);
                }
                continue;
            }
            if ("uline".equals(name)) {
                this._appendRawText(node, buf.toString());
                buf.delete(0, buf.length());
                String pstr = (String)param.get(0);
                n = pstr.length();
                for (int j = 0; j < n; ++j) {
                    int codePoint = pstr.codePointAt(j);
                    hex = HexUtil.toHexString((int)codePoint, (int)6);
                    fontname = "U" + hex + "-UL";
                    dir = new File(this._basedir, WDIC_GAIJI_DIR);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (!(file = new File(dir, fontname + ".xbm")).exists()) {
                        img = WdicUtil.toUnderLineImage(codePoint);
                        try {
                            FontUtil.writeXbm((BufferedImage)img, (File)file);
                        }
                        catch (IOException e) {
                            this._log.error((Object)e.getMessage(), (Throwable)e);
                            file.delete();
                        }
                        finally {
                            if (img != null) {
                                img.flush();
                            }
                        }
                    }
                    if ((type = this._gaijiMap.get(fontname)) == null) {
                        type = FontUtil.getFontType((int)codePoint);
                        this._gaijiMap.put(fontname, type);
                    }
                    this._appendCharReference(node, fontname, type);
                }
                continue;
            }
            if ("sout".equals(name)) {
                this._appendRawText(node, buf.toString());
                buf.delete(0, buf.length());
                String pstr = (String)param.get(0);
                n = pstr.length();
                for (int j = 0; j < n; ++j) {
                    int codePoint = pstr.codePointAt(j);
                    hex = HexUtil.toHexString((int)codePoint, (int)6);
                    fontname = "U" + hex + "-LT";
                    dir = new File(this._basedir, WDIC_GAIJI_DIR);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (!(file = new File(dir, fontname + ".xbm")).exists()) {
                        img = WdicUtil.toLineThroughImage(codePoint);
                        try {
                            FontUtil.writeXbm((BufferedImage)img, (File)file);
                        }
                        catch (IOException e) {
                            this._log.error((Object)e.getMessage(), (Throwable)e);
                            file.delete();
                        }
                        finally {
                            if (img != null) {
                                img.flush();
                            }
                        }
                    }
                    if ((type = this._gaijiMap.get(fontname)) == null) {
                        type = FontUtil.getFontType((int)codePoint);
                        this._gaijiMap.put(fontname, type);
                    }
                    this._appendCharReference(node, fontname, type);
                }
                continue;
            }
            if (!("unit".equals(name) || "date".equals(name) || "dt".equals(name))) {
                this._log.error((Object)("unknown function name: " + name));
            }
            this._appendRawText(node, buf.toString());
            buf.delete(0, buf.length());
            this._appendText(item, node, (String)param.get(0), linkBlock);
        }
        this._appendRawText(node, buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkCharacter(Node node) {
        if (node.getNodeType() == 3) {
            Text text = (Text)node;
            String str = text.getNodeValue();
            int len = str.length();
            int idx = 0;
            while (idx < len) {
                int codePoint = str.codePointAt(idx);
                int cnt = Character.charCount(codePoint);
                if (WordUtil.isValidChar((int)codePoint)) {
                    idx += cnt;
                    continue;
                }
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
                if (Character.UnicodeBlock.HEBREW.equals(unicodeBlock) || Character.UnicodeBlock.ARABIC.equals(unicodeBlock) || Character.UnicodeBlock.DEVANAGARI.equals(unicodeBlock)) {
                    Object[] files;
                    int end = idx + cnt;
                    while (end < len) {
                        int cp = str.codePointAt(end);
                        if (!unicodeBlock.equals(Character.UnicodeBlock.of(cp))) {
                            if (cp != 32 || end + 1 >= len || !unicodeBlock.equals(Character.UnicodeBlock.of(cp = str.codePointAt(end + 1)))) break;
                            end += 1 + Character.charCount(cp);
                            continue;
                        }
                        end += Character.charCount(cp);
                    }
                    String s = str.substring(idx, end);
                    int n = s.length();
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            buf.append("_");
                        }
                        int cp = s.codePointAt(i);
                        buf.append("U").append(HexUtil.toHexString((int)cp, (int)6));
                        i = i + Character.charCount(cp) - 1;
                    }
                    String name = buf.toString() + "-N";
                    File dir = new File(this._basedir, WDIC_GAIJI_DIR);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (ArrayUtils.isEmpty((Object[])(files = dir.list((FilenameFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)name), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".xbm")))))) {
                        this._log.info((Object)("unsupported characters: '" + s + "'" + " " + unicodeBlock.toString()));
                        BufferedImage img = WdicUtil.toImage(s);
                        int height = img.getHeight();
                        int width = 16;
                        byte[][] b = FontUtil.split((BufferedImage)img, (int)width);
                        img.flush();
                        n = b.length;
                        for (int i = 0; i < n; ++i) {
                            File file = new File(dir, name + i + ".xbm");
                            try {
                                FontUtil.writeXbm((byte[])b[i], (int)width, (int)height, (File)file);
                                continue;
                            }
                            catch (IOException e) {
                                this._log.error((Object)e.getMessage(), (Throwable)e);
                                file.delete();
                            }
                        }
                    } else {
                        n = files.length;
                    }
                    Node parent = text.getParentNode();
                    text = text.splitText(idx);
                    text.deleteData(0, end - idx);
                    for (int i = 0; i < n; ++i) {
                        String name0 = name + i;
                        String type = this._gaijiMap.get(name0);
                        if (type == null) {
                            type = "wide";
                            this._gaijiMap.put(name0, type);
                        }
                        Element elem = text.getOwnerDocument().createElement("char");
                        elem.setAttribute("name", name0);
                        elem.setAttribute("type", type);
                        parent.insertBefore(elem, text);
                    }
                } else {
                    String type;
                    File file;
                    String hex = HexUtil.toHexString((int)codePoint, (int)6);
                    String name = "U" + hex;
                    File dir = new File(this._basedir, WDIC_GAIJI_DIR);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (!(file = new File(dir, name + ".xbm")).exists()) {
                        String s = String.valueOf(Character.toChars(codePoint));
                        this._log.info((Object)("unsupported character: [U+" + hex + "]" + " '" + s + "'" + " " + unicodeBlock.toString()));
                        BufferedImage img = WdicUtil.toImage(codePoint);
                        try {
                            FontUtil.writeXbm((BufferedImage)img, (File)file);
                        }
                        catch (IOException e) {
                            this._log.error((Object)e.getMessage(), (Throwable)e);
                            file.delete();
                        }
                        finally {
                            if (img != null) {
                                img.flush();
                            }
                        }
                    }
                    if ((type = this._gaijiMap.get(name)) == null) {
                        type = FontUtil.getFontType((int)codePoint);
                        this._gaijiMap.put(name, type);
                    }
                    Node parent = text.getParentNode();
                    text = text.splitText(idx);
                    text.deleteData(0, cnt);
                    Element elem = text.getOwnerDocument().createElement("char");
                    elem.setAttribute("name", name);
                    elem.setAttribute("type", type);
                    parent.insertBefore(elem, text);
                }
                str = text.getNodeValue();
                len = str.length();
                idx = 0;
            }
        }
        if (node.hasChildNodes()) {
            NodeList nlist = node.getChildNodes();
            int len = nlist.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nlist.item(i);
                this._checkCharacter(child);
                int n = nlist.getLength();
                if (len >= n) continue;
                i += n - len;
                len = n;
            }
        }
    }
}

