/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.eb4j.util.HexUtil;
import fuku.xml2eb.converter.wdic.Wdic;
import fuku.xml2eb.converter.wdic.WdicGroup;
import fuku.xml2eb.converter.wdic.WdicItem;
import fuku.xml2eb.converter.wdic.WdicUtil;
import fuku.xml2eb.util.WaitImageObserver;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WdicTableItem {
    private static final Font FONT = new Font("SansSerif", 0, 10);
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private transient Log _log;
    private WdicItem _item;
    private boolean _header;
    private String _content;
    private int _align;
    private Color _foreground;
    private Color _background;
    private boolean _hbonding;
    private boolean _vbonding;
    private BufferedImage[] _imgs;

    public WdicTableItem(WdicItem item, boolean header) {
        this(item, header, null);
    }

    public WdicTableItem(WdicItem item, boolean header, String data) {
        block17: {
            this._log = null;
            this._item = null;
            this._header = false;
            this._content = null;
            this._align = 0;
            this._foreground = Color.BLACK;
            this._background = Color.WHITE;
            this._hbonding = false;
            this._vbonding = false;
            this._imgs = null;
            this._log = LogFactory.getLog(this.getClass());
            this._item = item;
            this._header = header;
            if (this._header) {
                this._align = 1;
            }
            if (data != null) {
                String str = data.trim();
                if ("<".equals(str)) {
                    this._hbonding = true;
                } else if ("~".equals(str)) {
                    this._vbonding = true;
                } else {
                    while (true) {
                        if (str.startsWith("=")) {
                            this._header = true;
                            this._align = 1;
                            str = str.substring(1);
                            continue;
                        }
                        if (str.startsWith("<<")) {
                            this._align = 0;
                            str = str.substring(2);
                            continue;
                        }
                        if (str.startsWith(">>")) {
                            this._align = 2;
                            str = str.substring(2);
                            continue;
                        }
                        if (str.startsWith("><")) {
                            this._align = 1;
                            str = str.substring(2);
                            continue;
                        }
                        if (!str.startsWith("#")) break;
                        int idx = WdicUtil.indexOf(str, "#", 1);
                        try {
                            int rgb;
                            String func = str.substring(1, idx);
                            str = str.substring(idx + 1);
                            idx = WdicUtil.indexOf(func, ":", 0);
                            String name = func.substring(idx);
                            String val = func.substring(idx + 1);
                            if ("COLOR".equals(name)) {
                                rgb = Integer.parseInt(val, 16);
                                this._foreground = new Color(rgb);
                                continue;
                            }
                            if (!"BGCOLOR".equals(name)) continue;
                            rgb = Integer.parseInt(val, 16);
                            this._background = new Color(rgb);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            String grpId = this._item.getWdic().getGroupId();
                            String partId = this._item.getWdic().getPartId();
                            String id = grpId + ":" + partId + ":" + this._item.getHead();
                            this._log.warn((Object)("unexped table format: " + id + " '" + data + "'"));
                            this._content = str;
                            break block17;
                        }
                    }
                    this._content = str;
                }
            }
        }
        if (this._hbonding || this._vbonding) {
            this._content = null;
        } else if (StringUtils.isBlank((String)this._content)) {
            this._content = " ";
        }
    }

    public String getContent() {
        return this._content;
    }

    public boolean isHeader() {
        return this._header;
    }

    public int getAlign() {
        return this._align;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setForeground(Color color) {
        this._foreground = color;
    }

    public Color getBackground() {
        return this._background;
    }

    public void setBackground(Color color) {
        this._background = color;
    }

    public boolean isHBonding() {
        return this._hbonding;
    }

    public void setHBonding(boolean bonding) {
        this._hbonding = bonding;
    }

    public boolean isVBonding() {
        return this._vbonding;
    }

    public void setVBonding(boolean bonding) {
        this._vbonding = bonding;
    }

    public void destroy() {
        if (this._imgs != null) {
            int n = this._imgs.length;
            for (int i = 0; i < n; ++i) {
                this._imgs[i].flush();
                this._imgs[i] = null;
            }
            this._imgs = null;
        }
    }

    public BufferedImage[] getImage() {
        if (this._imgs == null) {
            this._makeImage();
        }
        return this._imgs;
    }

    public int getWidth() {
        if (this._imgs == null) {
            this._makeImage();
        }
        int n = this._imgs.length;
        int width = 0;
        for (int i = 0; i < n; ++i) {
            int w = this._imgs[i].getWidth();
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public int getHeight() {
        if (this._imgs == null) {
            this._makeImage();
        }
        int n = this._imgs.length;
        int height = 0;
        for (int i = 0; i < n; ++i) {
            height += this._imgs[i].getHeight();
        }
        return height;
    }

    private void _makeImage() {
        if (this._imgs != null) {
            return;
        }
        if (this._content == null) {
            this._imgs = new BufferedImage[0];
            return;
        }
        String[] content = this._content.split("\\\\br;");
        int n = content.length;
        this._imgs = new BufferedImage[n];
        Font font = FONT;
        if (this._header) {
            font = font.deriveFont(1);
        }
        int size = font.getSize();
        int height = size + 7;
        for (int i = 0; i < n; ++i) {
            int width = content[i].length() * size + 8;
            this._imgs[i] = new BufferedImage(width, height, 2);
            Graphics2D g2 = this._imgs[i].createGraphics();
            g2.setColor(this._foreground);
            g2.setFont(font);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int w = this._drawText(g2, content[i], 0, 3);
            g2.dispose();
            if (w > 0 && w < width) {
                WaitImageObserver obs;
                BufferedImage tmp = new BufferedImage(w, height, 2);
                g2 = tmp.createGraphics();
                if (!g2.drawImage((Image)this._imgs[i], 0, 0, (ImageObserver)(obs = new WaitImageObserver()))) {
                    obs.waitFor();
                }
                g2.dispose();
                this._imgs[i].flush();
                this._imgs[i] = tmp;
                continue;
            }
            if (width >= w) continue;
            this._imgs[i] = new BufferedImage(w, height, 2);
            g2 = this._imgs[i].createGraphics();
            g2.setColor(this._foreground);
            g2.setFont(font);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this._drawText(g2, content[i], 0, 3);
            g2.dispose();
        }
    }

    private int _drawText(Graphics2D g2, String str, int x, int y) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int sy;
            int btm;
            FontMetrics fm2;
            char ch = str.charAt(i);
            if (Character.isHighSurrogate(ch) || Character.isLowSurrogate(ch)) {
                buf.append(ch);
                continue;
            }
            if (ch == '\'') {
                int idx1;
                String bracket = "'";
                for (idx1 = i + 1; idx1 < len && str.charAt(idx1) == '\''; ++idx1) {
                    bracket = bracket + "'";
                }
                if (bracket.length() > 1) {
                    int idx2 = WdicUtil.indexOf(str, bracket, idx1);
                    if (idx2 != -1) {
                        if (buf.length() > 0) {
                            x = this._drawRawText(g2, buf.toString(), x, y);
                            buf.delete(0, buf.length());
                        }
                        Font origFont = g2.getFont();
                        Font font = origFont.deriveFont(2);
                        g2.setFont(font);
                        x = this._drawText(g2, str.substring(idx1, idx2), x, y);
                        g2.setFont(origFont);
                        i = idx2 + bracket.length() - 1;
                        continue;
                    }
                    buf.append(bracket);
                    i = idx1 - 1;
                    continue;
                }
            } else if (ch == '[' && i + 1 < len && str.charAt(i + 1) == '[') {
                int idx1 = i + 1;
                int idx2 = WdicUtil.indexOf(str, "]]", idx1 + 1);
                if (idx2 != -1) {
                    int idx3;
                    String ref = str.substring(idx1 + 1, idx2);
                    String name = null;
                    if (ref.startsWith("<") && (idx3 = WdicUtil.indexOf(ref, ">", 1)) != -1) {
                        name = ref.substring(1, idx3);
                        ref = ref.substring(idx3 + 1);
                    }
                    String refid = null;
                    if (ref.startsWith("http:") || ref.startsWith("https:") || ref.startsWith("ftp:") || ref.startsWith("news:") || ref.startsWith("gopher:") || ref.startsWith("mailto:") || ref.startsWith("phone:") || ref.startsWith("urn:") || ref.startsWith("x-geo:")) {
                        if (StringUtils.isBlank(name)) {
                            name = ref;
                        }
                    } else if (ref.startsWith("//")) {
                        int idx32 = ref.indexOf("|");
                        if (idx32 > 0) {
                            ref = ref.substring(0, idx32);
                        }
                        String file = null;
                        idx32 = ref.indexOf("/", 2);
                        file = idx32 != -1 ? ref.substring(idx32 + 1) : ref.substring(2);
                        refid = "PLUGIN:" + file;
                        if (StringUtils.isBlank((String)name)) {
                            name = file;
                        }
                    } else {
                        if (ref.startsWith("x-wdic:")) {
                            ref = ref.substring("x-wdic:".length());
                        }
                        String gid = null;
                        String head = null;
                        if (ref.startsWith("/")) {
                            int idx33 = WdicUtil.indexOf(ref, "/", 1);
                            if (idx33 != -1) {
                                gid = ref.substring(1, idx33);
                                head = ref.substring(idx33 + 1);
                            } else {
                                head = ref.substring(1);
                            }
                        } else {
                            head = ref;
                        }
                        head = WdicUtil.unescape(head);
                        if (StringUtils.isBlank((String)name)) {
                            name = head;
                        }
                        WdicGroup group = this._item.getWdic().getGroup();
                        if (StringUtils.isBlank((String)gid)) {
                            gid = group.getGroupId();
                        } else {
                            group = group.getGroupList().getGroup(gid);
                        }
                        if (group != null) {
                            Wdic wdic = group.getWdic(head);
                            if (wdic != null) {
                                refid = "WDIC:" + gid + ":" + head;
                            } else {
                                this._log.error((Object)("undefined word: " + gid + "/" + head));
                            }
                        } else {
                            this._log.error((Object)("undefined group: " + gid));
                        }
                    }
                    if (buf.length() > 0) {
                        x = this._drawRawText(g2, buf.toString(), x, y);
                        buf.delete(0, buf.length());
                    }
                    Color origColor = g2.getColor();
                    g2.setColor(Color.BLUE);
                    int start = x;
                    x = this._drawText(g2, name, x, y);
                    g2.setColor(origColor);
                    i = idx2 + 1;
                    if (!StringUtils.isNotBlank(refid)) continue;
                    FontMetrics fm = g2.getFontMetrics();
                    int h = fm.getAscent() + fm.getDescent();
                    Rectangle rect = new Rectangle(start, y, x, y + h);
                    continue;
                }
                buf.append("[[");
                i = idx1;
                continue;
            }
            if (ch != '\\') {
                buf.append(ch);
                continue;
            }
            if (i + 1 >= len) {
                buf.append(ch);
                continue;
            }
            char ch1 = str.charAt(i + 1);
            if (ch1 >= '!' && ch1 <= '~' && !CharUtils.isAsciiAlphanumeric((char)ch1)) {
                ++i;
                buf.append(ch1);
                continue;
            }
            int idx = WdicUtil.indexOf(str, ";", i + 1);
            if (idx < 0) {
                this._log.error((Object)("unexpected format: " + str));
                buf.append(ch);
                continue;
            }
            String ref = str.substring(i + 1, idx);
            i = idx;
            int sep1 = WdicUtil.indexOf(ref, "{", 0);
            int sep2 = WdicUtil.indexOf(ref, ":", 0);
            if (sep1 == -1 && sep2 == -1) {
                buf.append(WdicUtil.getCharacter(ref));
                continue;
            }
            String name = null;
            ArrayList<String> param = new ArrayList<String>();
            if (sep1 != -1 && sep2 != -1) {
                if (sep2 < sep1) {
                    sep1 = -1;
                } else {
                    sep2 = -1;
                }
            }
            if (sep1 != -1) {
                name = ref.substring(0, sep1);
                int idx1 = sep1;
                int idx2 = -1;
                while (idx1 != -1) {
                    idx2 = ref.indexOf(125, idx1 + 1);
                    if (idx2 == -1) {
                        idx2 = ref.length();
                    }
                    param.add(ref.substring(idx1 + 1, idx2));
                    idx1 = ref.indexOf(123, idx2 + 1);
                }
            } else {
                name = ref.substring(0, sep2);
                String[] arg = ref.substring(sep2 + 1).split(":");
                int n = arg.length;
                for (int j = 0; j < n; ++j) {
                    param.add(arg[j]);
                }
            }
            if (buf.length() > 0) {
                x = this._drawRawText(g2, buf.toString(), x, y);
                buf.delete(0, buf.length());
            }
            if ("x".equals(name)) {
                String code = (String)param.get(0);
                try {
                    int codePoint = Integer.parseInt(code, 16);
                    buf.appendCodePoint(codePoint);
                }
                catch (Exception e) {
                    this._log.error((Object)("unknown character code: " + code));
                }
                continue;
            }
            if ("sup".equals(name)) {
                Font origFont = g2.getFont();
                float size = origFont.getSize() - 2;
                Font font = origFont.deriveFont(size);
                g2.setFont(font);
                int sy2 = y - 2;
                x = this._drawText(g2, (String)param.get(0), x, sy2);
                g2.setFont(origFont);
                continue;
            }
            if ("sub".equals(name)) {
                FontMetrics fm1 = g2.getFontMetrics();
                Font origFont = g2.getFont();
                float size = origFont.getSize() - 2;
                Font font = origFont.deriveFont(size);
                g2.setFont(font);
                fm2 = g2.getFontMetrics(font);
                btm = y + fm1.getAscent() + fm1.getDescent() + 2;
                sy = btm - fm2.getAscent() - fm2.getDescent();
                x = this._drawText(g2, (String)param.get(0), x, sy);
                g2.setFont(origFont);
                continue;
            }
            if ("ruby".equals(name)) {
                x = this._drawText(g2, (String)param.get(0), x, y);
                if (param.size() <= 1) continue;
                FontMetrics fm1 = g2.getFontMetrics();
                Font origFont = g2.getFont();
                float size = origFont.getSize() - 2;
                Font font = origFont.deriveFont(size);
                g2.setFont(font);
                fm2 = g2.getFontMetrics(font);
                btm = y + fm1.getAscent() + fm1.getDescent() + 2;
                sy = btm - fm2.getAscent() - fm2.getDescent();
                x = this._drawText(g2, "(" + (String)param.get(1) + ")", x, sy);
                g2.setFont(origFont);
                continue;
            }
            if ("asin".equals(name)) {
                String asin = (String)param.get(0);
                String url = null;
                switch (asin.charAt(0)) {
                    case '4': {
                        url = "http://www.amazon.co.jp/exec/obidos/ASIN/";
                        break;
                    }
                    case '3': {
                        url = "http://www.amazon.de/exec/obidos/ASIN/";
                        break;
                    }
                    case '2': {
                        url = "http://www.amazon.fr/exec/obidos/ASIN/";
                        break;
                    }
                    case '1': {
                        url = "http://www.amazon.co.uk/exec/obidos/ASIN/";
                        break;
                    }
                    default: {
                        url = "http://www.amazon.com/exec/obidos/ASIN/";
                    }
                }
                buf.append(url + asin);
                continue;
            }
            if ("flag".equals(name)) continue;
            if ("mex".equals(name)) {
                buf.append("[" + (String)param.get(0) + "]");
                continue;
            }
            if ("oline".equals(name)) {
                int start = x;
                x = this._drawText(g2, (String)param.get(0), x, y);
                g2.drawLine(start, y, x, y);
                continue;
            }
            if ("uline".equals(name)) {
                int start = x;
                x = this._drawText(g2, (String)param.get(0), x, y);
                FontMetrics fm = g2.getFontMetrics();
                int yy = y + fm.getAscent() + fm.getDescent() - 1;
                g2.drawLine(start, yy, x, yy);
                continue;
            }
            if ("sout".equals(name)) {
                int start = x;
                x = this._drawText(g2, (String)param.get(0), x, y);
                FontMetrics fm = g2.getFontMetrics();
                int yy = y + (fm.getAscent() + fm.getDescent()) / 2;
                g2.drawLine(start, yy, x, yy);
                continue;
            }
            if (!("unit".equals(name) || "date".equals(name) || "dt".equals(name))) {
                this._log.error((Object)("unknown function name: " + name));
            }
            x = this._drawText(g2, (String)param.get(0), x, y);
        }
        if (buf.length() > 0) {
            x = this._drawRawText(g2, buf.toString(), x, y);
        }
        return x;
    }

    private int _drawRawText(Graphics2D g2, String str, int x, int y) {
        Font origFont = g2.getFont();
        while (StringUtils.isNotEmpty((String)str)) {
            int codePoint = str.codePointAt(0);
            Font font = WdicUtil.getFont(codePoint);
            font = font.deriveFont(origFont.getStyle(), origFont.getSize2D());
            String drawStr = str;
            int yy = y;
            int n = font.canDisplayUpTo(str);
            if (n == -1) {
                str = null;
            } else if (n == 0) {
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
                if (Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS.equals(unicodeBlock)) {
                    codePoint = WdicUtil.toLargeKatakana(codePoint);
                    font = WdicUtil.getFont(codePoint);
                    font = font.deriveFont(origFont.getStyle(), origFont.getSize2D() - 2.0f);
                    FontMetrics fm1 = g2.getFontMetrics(origFont);
                    FontMetrics fm2 = g2.getFontMetrics(font);
                    int btm = y + fm1.getAscent() + fm1.getDescent();
                    yy = btm - fm2.getAscent() - fm2.getDescent();
                    drawStr = String.valueOf(Character.toChars(codePoint));
                } else {
                    String code = "U+" + HexUtil.toHexString((int)codePoint, (int)6);
                    this._log.warn((Object)("unavailable display font: [" + code + "]" + " " + unicodeBlock.toString()));
                    codePoint = 63;
                    drawStr = String.valueOf(Character.toChars(codePoint));
                    font = WdicUtil.getFont(codePoint);
                    font = font.deriveFont(origFont.getStyle(), origFont.getSize2D() - 2.0f);
                }
                str = str.substring(1);
            } else {
                drawStr = str.substring(0, n);
                str = str.substring(n);
            }
            g2.setFont(font);
            FontMetrics fm = g2.getFontMetrics(font);
            g2.drawString(drawStr, x, yy += fm.getAscent());
            x += fm.stringWidth(drawStr);
        }
        g2.setFont(origFont);
        return x;
    }
}

