package fuku.webbook;

import java.net.URL;
import java.net.MalformedURLException;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.Log;

import static fuku.webbook.WebBookConstants.KEY_WEBBOOK_CONFIG;

/**
 * WebBookコンテキストリスナ。
 *
 * @author Hisaya FUKUMOTO
 */
public class WebBookContextListener implements ServletContextListener {

    /** ログ */
    private transient Log _log = null;


    /**
     * コンストラクタ。
     *
     */
    public WebBookContextListener() {
        super();
        _log = LogFactory.getLog(getClass());
    }


    /**
     * Webアプリケーションが要求を処理する準備ができたときに呼び出されます。
     *
     * @param evt サーブレットコンテキストイベント
     */
    public void contextInitialized(ServletContextEvent evt) {
        ServletContext context = evt.getServletContext();
        String str = context.getInitParameter("config");
        URL url = null;
        try {
            url = context.getResource(str);
        } catch (MalformedURLException e) {
        }
        WebBookConfig config = new WebBookConfig();
        if (url != null) {
            _log.info("load configuration file [" + url.toString() + "]");
            try {
                config.load(url);
            } catch (Exception e) {
                _log.warn("failed to initialization", e);
            }
        } else {
            _log.warn("undefined config parameter");
        }
        context.setAttribute(KEY_WEBBOOK_CONFIG, config);
    }

    /**
     * サーブレットコンテキストがシャットダウン処理に入ると呼び出されます。
     *
     * @param evt サーブレットコンテキストイベント
     */
    public void contextDestroyed(ServletContextEvent evt) {
        ServletContext context = evt.getServletContext();
        context.removeAttribute(KEY_WEBBOOK_CONFIG);
    }
}

// end of WebBookContextListener.java
