package fuku.webbook.acl;

import org.springframework.mock.web.MockHttpServletRequest;

import junit.framework.TestCase;

public class RoleEntryTest extends TestCase {

    public void testAllowed() {
        MockHttpServletRequest req0 = new MockHttpServletRequest();
        req0.addUserRole("role0");
        MockHttpServletRequest req1 = new MockHttpServletRequest();
        req1.addUserRole("role1");

        String roleList = "role1, role2";
        RoleEntry entry = new RoleEntry(true, roleList);
        assertFalse(entry.isAllowed(req0));
        assertTrue(entry.isAllowed(req1));
    }

    public void testDenied() {
        MockHttpServletRequest req0 = new MockHttpServletRequest();
        req0.addUserRole("role0");
        MockHttpServletRequest req1 = new MockHttpServletRequest();
        req1.addUserRole("role1");

        String roleList = "role1, role2";
        RoleEntry entry = new RoleEntry(false, roleList);
        assertTrue(entry.isAllowed(req0));
        assertFalse(entry.isAllowed(req1));
    }
}

// end of RoleEntryTest.java
