/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.util.ByteUtil;

public class IndexStyle {
    protected static final int CONVERT = 0;
    protected static final int ASIS = 1;
    protected static final int REVERSE = 2;
    protected static final int DELETE = 2;
    private int _indexID = 0;
    private long _startPage = 0L;
    private long _endPage = 0L;
    private long _candidatePage = 0L;
    private int _space = 2;
    private int _katakana = 0;
    private int _lower = 0;
    private int _mark = 2;
    private int _longVowel = 0;
    private int _doubleConsonant = 0;
    private int _contractedSound = 0;
    private int _voicedConsonant = 0;
    private int _smallVowel = 0;
    private int _psound = 0;
    private String _label = null;

    protected IndexStyle() {
    }

    protected void setIndexID(int indexID) {
        this._indexID = indexID;
    }

    protected int getIndexID() {
        return this._indexID;
    }

    protected void setStartPage(long startPage) {
        this._startPage = startPage;
    }

    protected long getStartPage() {
        return this._startPage;
    }

    protected void setEndPage(long endPage) {
        this._endPage = endPage;
    }

    protected long getEndPage() {
        return this._endPage;
    }

    protected void setCandidatePage(long candidatePage) {
        this._candidatePage = candidatePage;
    }

    protected long getCandidatePage() {
        return this._candidatePage;
    }

    protected void setSpaceStyle(int style) {
        this._space = style;
    }

    protected void setKatakanaStyle(int style) {
        this._katakana = style;
    }

    protected void setLowerStyle(int style) {
        this._lower = style;
    }

    protected void setMarkStyle(int style) {
        this._mark = style;
    }

    protected void setLongVowelStyle(int style) {
        this._longVowel = style;
    }

    protected void setDoubleConsonantStyle(int style) {
        this._doubleConsonant = style;
    }

    protected void setContractedSoundStyle(int style) {
        this._contractedSound = style;
    }

    protected void setVoicedConsonantStyle(int style) {
        this._voicedConsonant = style;
    }

    protected void setSmallVowelStyle(int style) {
        this._smallVowel = style;
    }

    protected void setPSoundStyle(int style) {
        this._psound = style;
    }

    protected void setLabel(String label) {
        this._label = label;
    }

    protected String getLabel() {
        return this._label;
    }

    protected void fixWordLatin(byte[] b) {
        if (this._indexID == 161 && this._candidatePage != 0L) {
            return;
        }
        if (this._space == 2) {
            ByteUtil.deleteSpaceLatin(b);
        }
        if (this._lower == 0) {
            ByteUtil.lowerToUpperLatin(b);
        }
    }

    protected void fixWord(byte[] b) {
        if (this._indexID == 161 && this._candidatePage != 0L) {
            return;
        }
        if (this._space == 2) {
            ByteUtil.deleteSpace(b);
        }
        if (this._katakana == 0) {
            ByteUtil.katakanaToHiragana(b);
        } else if (this._katakana == 2) {
            ByteUtil.hiraganaToKatakana(b);
        }
        if (this._lower == 0) {
            ByteUtil.lowerToUpper(b);
        }
        if (this._mark == 2) {
            ByteUtil.deleteMark(b);
        }
        if (this._longVowel == 0) {
            ByteUtil.convertLongVowel(b);
        } else if (this._longVowel == 2) {
            ByteUtil.deleteLongVowel(b);
        }
        if (this._doubleConsonant == 0) {
            ByteUtil.convertDoubleConsonant(b);
        }
        if (this._contractedSound == 0) {
            ByteUtil.convertContractedSound(b);
        }
        if (this._smallVowel == 0) {
            ByteUtil.convertSmallVowel(b);
        }
        if (this._voicedConsonant == 0) {
            ByteUtil.convertVoicedConsonant(b);
        }
        if (this._psound == 0) {
            ByteUtil.convertPSound(b);
        }
    }
}

