/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.util;

public class CompareUtil {
    private CompareUtil() {
    }

    public static int compareToByte(byte[] key, byte[] pattern, boolean presearch) {
        int klen = key.length;
        int plen = pattern.length;
        for (int i = 0; i < klen; ++i) {
            if (i >= plen) {
                if (presearch) {
                    return 0;
                }
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                return 0;
            }
            int kByte = key[i] & 0xFF;
            int pByte = pattern[i] & 0xFF;
            if (kByte == pByte) continue;
            return kByte - pByte;
        }
        return 0;
    }

    public static int compareToJISX0208(byte[] key, byte[] pattern, boolean presearch) {
        int klen = key.length;
        int plen = pattern.length;
        for (int i = 0; i < klen; ++i) {
            if (i >= plen) {
                if (presearch) {
                    return 0;
                }
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                while (i < plen && pattern[i] == 0) {
                    ++i;
                }
                return i - plen;
            }
            int kByte = key[i] & 0xFF;
            int pByte = pattern[i] & 0xFF;
            if (kByte == pByte) continue;
            return kByte - pByte;
        }
        if (klen < plen) {
            while (klen < plen && pattern[klen] == 0) {
                ++klen;
            }
            return klen - plen;
        }
        return 0;
    }

    public static int compareToLatin(byte[] key, byte[] pattern, boolean presearch) {
        int klen = key.length;
        int plen = pattern.length;
        for (int i = 0; i < klen; ++i) {
            if (i >= plen) {
                if (presearch) {
                    return 0;
                }
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                while (i < plen && (pattern[i] == 32 || pattern[i] == 0)) {
                    ++i;
                }
                return i - plen;
            }
            int kByte = key[i] & 0xFF;
            int pByte = pattern[i] & 0xFF;
            if (kByte == pByte) continue;
            return kByte - pByte;
        }
        if (klen < plen) {
            while (klen < plen && (pattern[klen] == 32 || pattern[klen] == 0)) {
                ++klen;
            }
            return klen - plen;
        }
        return 0;
    }

    public static int compareToKanaGroup(byte[] key, byte[] pattern, boolean exact) {
        int klen = key.length;
        int plen = pattern.length;
        for (int i = 0; i < klen; i += 2) {
            if (i >= plen) {
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                if (exact) {
                    return -(pattern[i] & 0xFF);
                }
                return 0;
            }
            if (i + 1 >= klen || i + 1 >= plen) {
                return (key[i] & 0xFF) - (pattern[i] & 0xFF);
            }
            int kc0 = key[i] & 0xFF;
            int kc1 = key[i + 1] & 0xFF;
            int pc0 = pattern[i] & 0xFF;
            int pc1 = pattern[i + 1] & 0xFF;
            if (!(!(kc0 != 36 && kc0 != 37 || pc0 != 36 && pc0 != 37) ? kc1 != pc1 : kc0 != pc0 || kc1 != pc1)) continue;
            return (kc0 << 8) + kc1 - ((pc0 << 8) + pc1);
        }
        if (klen < plen && exact) {
            return -(pattern[klen] & 0xFF);
        }
        return 0;
    }

    public static int compareToKanaSingle(byte[] key, byte[] pattern, boolean exact) {
        int klen = key.length;
        int plen = pattern.length;
        for (int i = 0; i < klen; i += 2) {
            if (i >= plen) {
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                if (exact) {
                    return -(pattern[i] & 0xFF);
                }
                return 0;
            }
            if (i + 1 >= klen || i + 1 >= plen) {
                return (key[i] & 0xFF) - (pattern[i] & 0xFF);
            }
            int kc0 = key[i] & 0xFF;
            int kc1 = key[i + 1] & 0xFF;
            int pc0 = pattern[i] & 0xFF;
            int pc1 = pattern[i + 1] & 0xFF;
            if (!(kc0 != 36 && kc0 != 37 || pc0 != 36 && pc0 != 37)) {
                if (kc1 == pc1) continue;
                return kc1 - pc1;
            }
            if (kc0 == pc0 && kc1 == pc1) continue;
            return (kc0 << 8) + kc1 - ((pc0 << 8) + pc1);
        }
        if (klen < plen && exact) {
            return -(pattern[klen] & 0xFF);
        }
        return 0;
    }
}

