/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import java.io.UnsupportedEncodingException;

public class Word
implements Comparable<Word> {
    private byte[] _word = null;
    private String _tag = null;

    public Word(byte[] word, String tag) {
        int len = word.length;
        this._word = new byte[len];
        System.arraycopy(word, 0, this._word, 0, len);
        this._tag = tag;
    }

    public byte[] getWord() {
        int len = this._word.length;
        byte[] b = new byte[len];
        System.arraycopy(this._word, 0, b, 0, len);
        return b;
    }

    public int getWordLength() {
        return this._word.length;
    }

    public String getReferenceTag() {
        return this._tag;
    }

    public int hashCode() {
        int code = 0;
        int n = this._word.length;
        for (int i = 0; i < n; ++i) {
            code = code * 31 + this._word[n];
        }
        return code += this._tag.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Word && this.compareTo((Word)obj) == 0;
    }

    @Override
    public int compareTo(Word word) {
        int comp;
        byte[] b = word.getWord();
        int len1 = this._word.length;
        int len2 = b.length;
        int len = Math.min(len1, len2);
        for (int i = 0; i < len; ++i) {
            int c1 = this._word[i] & 0xFF;
            int c2 = b[i] & 0xFF;
            comp = c1 - c2;
            if (comp == 0) continue;
            return comp;
        }
        comp = len1 - len2;
        if (comp != 0) {
            return comp;
        }
        return this._tag.compareTo(word.getReferenceTag());
    }

    public String toString() {
        String str;
        try {
            str = new String(this._word, "x-JIS0208");
        }
        catch (UnsupportedEncodingException e) {
            str = "???";
        }
        str = str + " [" + this._tag + "]";
        return str;
    }
}

