/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.util;

import fuku.eb4j.util.HexUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FontUtil {
    private static final Log _log = LogFactory.getLog(FontUtil.class);

    private FontUtil() {
    }

    public static String getFontType(int codePoint) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
        if (Character.UnicodeBlock.BASIC_LATIN.equals(unicodeBlock) || Character.UnicodeBlock.LATIN_1_SUPPLEMENT.equals(unicodeBlock) || Character.UnicodeBlock.LATIN_EXTENDED_A.equals(unicodeBlock) || Character.UnicodeBlock.LATIN_EXTENDED_B.equals(unicodeBlock) || Character.UnicodeBlock.IPA_EXTENSIONS.equals(unicodeBlock) || Character.UnicodeBlock.SPACING_MODIFIER_LETTERS.equals(unicodeBlock) || Character.UnicodeBlock.GREEK.equals(unicodeBlock) || Character.UnicodeBlock.CYRILLIC.equals(unicodeBlock) || Character.UnicodeBlock.HEBREW.equals(unicodeBlock) || Character.UnicodeBlock.ARABIC.equals(unicodeBlock) || Character.UnicodeBlock.DEVANAGARI.equals(unicodeBlock) || Character.UnicodeBlock.THAI.equals(unicodeBlock) || Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL.equals(unicodeBlock) || Character.UnicodeBlock.GREEK_EXTENDED.equals(unicodeBlock) || Character.UnicodeBlock.GENERAL_PUNCTUATION.equals(unicodeBlock) || Character.UnicodeBlock.BLOCK_ELEMENTS.equals(unicodeBlock) || Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS.equals(unicodeBlock)) {
            return "narrow";
        }
        return "wide";
    }

    public static BufferedImage smallCharToImage(int codePoint, int width, int height, Font font) {
        int h2 = height * 4 / 5;
        font = font.deriveFont((float)height);
        String code = "U+" + HexUtil.toHexString((int)codePoint, (int)6);
        String str = String.valueOf(Character.toChars(codePoint));
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2 = img.createGraphics();
        FontMetrics fm = g2.getFontMetrics(font);
        int w = fm.charWidth(codePoint);
        int h = fm.getAscent() + fm.getDescent();
        if (w > width || h > h2) {
            for (int size = font.getSize() - 1; size > 0; --size) {
                font = font.deriveFont((float)size);
                fm = g2.getFontMetrics(font);
                w = fm.charWidth(codePoint);
                h = fm.getAscent() + fm.getDescent();
                if (w <= width && h <= h2) break;
            }
        }
        int x = (width - w) / 2;
        int y = height - h2 + (h2 - h) / 2 + fm.getAscent();
        _log.debug((Object)("display font: [" + code + "]" + " block:" + unicodeBlock.toString() + " font:" + font.getName() + " size:" + font.getSize()));
        g2.setFont(font);
        g2.setColor(Color.BLACK);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.drawString(str, x, y);
        g2.dispose();
        return img;
    }

    public static BufferedImage charToImage(int codePoint, int width, int height, Font font) {
        font = font.deriveFont((float)height);
        String code = "U+" + HexUtil.toHexString((int)codePoint, (int)6);
        String str = String.valueOf(Character.toChars(codePoint));
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2 = img.createGraphics();
        FontMetrics fm = g2.getFontMetrics(font);
        int w = fm.charWidth(codePoint);
        int h = fm.getAscent() + fm.getDescent();
        if (w > width || h > height) {
            for (int size = font.getSize() - 1; size > 0; --size) {
                font = font.deriveFont((float)size);
                fm = g2.getFontMetrics(font);
                w = fm.charWidth(codePoint);
                h = fm.getAscent() + fm.getDescent();
                if (w <= width && h <= height) break;
            }
        }
        int x = (width - w) / 2;
        int y = height - h + fm.getAscent();
        _log.debug((Object)("display font: [" + code + "]" + " block:" + unicodeBlock.toString() + " font:" + font.getName() + " size:" + font.getSize()));
        g2.setFont(font);
        g2.setColor(Color.BLACK);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.drawString(str, x, y);
        g2.dispose();
        return img;
    }

    public static BufferedImage stringToImage(String str, int height, Font font) {
        font = font.deriveFont((float)height);
        BufferedImage img = new BufferedImage(1, height, 2);
        Graphics2D g2 = img.createGraphics();
        FontMetrics fm = g2.getFontMetrics(font);
        int h = fm.getAscent() + fm.getDescent();
        if (h > height) {
            for (int size = font.getSize() - 1; size > 0 && (h = (fm = g2.getFontMetrics(font = font.deriveFont((float)size))).getAscent() + fm.getDescent()) > height; --size) {
            }
        }
        int width = fm.stringWidth(str) + 2;
        int y = (height - h) / 2 + fm.getAscent();
        img.flush();
        img = new BufferedImage(width, height, 2);
        g2 = img.createGraphics();
        g2.setFont(font);
        g2.setColor(Color.BLACK);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.drawString(str, 1, y);
        g2.dispose();
        return img;
    }

    public static byte[][] split(BufferedImage img, int width) {
        width += 7 - (width + 7) % 8;
        int w = img.getWidth();
        int h = img.getHeight();
        int n = (w + width - 1) / width;
        int pad = (width * n - w) / 2;
        int size = h * width / 8;
        byte[][] b = new byte[n][size];
        for (int i = 0; i < n; ++i) {
            Arrays.fill(b[i], (byte)0);
        }
        w += pad;
        int x = 0;
        int y = 0;
        while (y < h) {
            int idx1 = x / width;
            int idx2 = y * (width / 8) + (x - width * idx1) / 8;
            int bits = 0;
            int i = 0;
            while (i < 8) {
                int rgb = 0;
                if (x >= pad && x < w) {
                    rgb = img.getRGB(x - pad, y);
                }
                bits <<= 1;
                if (rgb != 0) {
                    bits |= 1;
                }
                ++i;
                ++x;
            }
            b[idx1][idx2] = (byte)bits;
            if (x < w) continue;
            x = 0;
            ++y;
        }
        return b;
    }

    public static void writeXbm(BufferedImage img, File file) throws IOException {
        int w = img.getWidth();
        int width = w + (7 - (w + 7) % 8);
        int height = img.getHeight();
        int size = width / 8 * height;
        byte[] b = new byte[size];
        Arrays.fill(b, (byte)0);
        int x = 0;
        int y = 0;
        int idx = 0;
        while (y < height) {
            int bits = 0;
            int i = 0;
            while (i < 8) {
                int rgb = 0;
                if (x < w) {
                    rgb = img.getRGB(x, y);
                }
                bits <<= 1;
                if (rgb != 0) {
                    bits |= 1;
                }
                ++i;
                ++x;
            }
            b[idx++] = (byte)bits;
            if (x < w) continue;
            x = 0;
            ++y;
        }
        FontUtil.writeXbm(b, width, height, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXbm(byte[] b, int width, int height, File file) throws IOException {
        BufferedWriter bw = null;
        try {
            Charset cs = Charset.forName("ISO-8859-1");
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), cs));
            String name = "font" + width + "x" + height;
            String line = "#define " + name + "_width " + width;
            bw.write(line);
            bw.newLine();
            line = "#define " + name + "_height " + height;
            bw.write(line);
            bw.newLine();
            line = "static char " + name + "_bits[] = {";
            bw.write(line);
            int len = b.length;
            for (int i = 0; i < len; ++i) {
                byte bits1 = b[i];
                int bits2 = 0;
                int mask = 1;
                int val = 128;
                for (int j = 0; j < 8; ++j) {
                    if ((bits1 & mask) != 0) {
                        bits2 |= val;
                    }
                    mask <<= 1;
                    val >>>= 1;
                }
                if (i > 0) {
                    bw.write(", ");
                }
                if (i % 8 == 0) {
                    bw.newLine();
                    bw.write("  ");
                }
                if (bits2 < 16) {
                    bw.write("0x0" + Integer.toHexString(bits2));
                    continue;
                }
                bw.write("0x" + Integer.toHexString(bits2));
            }
            bw.newLine();
            line = "};";
            bw.write(line);
            bw.newLine();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bw);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)bw);
    }
}

