/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.xml2eb.converter.wdic.WdicUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WdicBib {
    private static final String ENCODING = "UTF-8";
    private static final Pattern SEC_PATTERN = Pattern.compile("^-+\\s\u25a0\\s(\\S*)\\s\u25a0\\s-+$");
    private Log _log = LogFactory.getLog(this.getClass());
    private File _file = null;
    private List<String> _bibList = null;

    public WdicBib(File file) {
        this._file = file;
        this._bibList = new ArrayList<String>();
        this._load();
    }

    public String[] getBibliography() {
        return this._bibList.toArray(new String[this._bibList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        this._log.info((Object)("load file: " + this._file.getPath()));
        LineIterator it = null;
        try {
            it = FileUtils.lineIterator((File)this._file, (String)ENCODING);
            while (it.hasNext()) {
                String sec;
                String line = WdicUtil.sanitize(it.nextLine());
                Matcher m = SEC_PATTERN.matcher(line);
                if (!m.matches() || !"\u57fa\u790e\u6587\u732e".equals(sec = m.group(1))) continue;
                this._loadBibliography(it);
            }
        }
        catch (IOException e) {
            try {
                this._log.fatal((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                LineIterator.closeQuietly(it);
                throw throwable;
            }
            LineIterator.closeQuietly((LineIterator)it);
        }
        LineIterator.closeQuietly((LineIterator)it);
    }

    private void _loadBibliography(LineIterator it) {
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return;
            }
            if (StringUtils.isBlank((String)line)) {
                if (buf.length() <= 0) continue;
                this._bibList.add(buf.toString());
                this._bibList.add("");
                buf.delete(0, buf.length());
                continue;
            }
            String str = StringUtils.stripStart((String)line, (String)" ");
            if (buf.length() > 0) {
                String tmp = buf.toString();
                if (str.startsWith("\u30fb") || str.startsWith("RFC ")) {
                    this._bibList.add(buf.toString());
                    buf.delete(0, buf.length());
                } else if (!tmp.startsWith("\u30fb") && !tmp.startsWith("RFC ")) {
                    this._bibList.add(buf.toString());
                    buf.delete(0, buf.length());
                } else {
                    buf.append(" ");
                }
            }
            buf.append(str);
        }
    }
}

