/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.tool;

import fuku.eb4j.Book;
import fuku.eb4j.EBException;
import fuku.eb4j.ExtFont;
import fuku.eb4j.SubBook;
import fuku.eb4j.util.HexUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.ArrayUtils;

public class EBInfo {
    private static final String _COPYRIGHT = "Copyright (c) 2002-2007 by Hisaya FUKUMOTO.";
    private static final String _EMAIL = "fukumoto@users.sourceforge.jp";
    private static final String _PROGRAM = EBInfo.class.getName();
    private static final String DEFAULT_BOOK_DIR = ".";
    private Book _book = null;

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("m", "multi-serarch", false, "also output multi-search information");
        options.addOption("h", "help", false, "display this help and exit");
        options.addOption("v", "version", false, "output version information and exit");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(_PROGRAM + ": " + e.getMessage());
            System.exit(1);
        }
        boolean multi = cmd.hasOption("m");
        if (cmd.hasOption("h")) {
            EBInfo._usage(options);
            System.exit(0);
        }
        if (cmd.hasOption("v")) {
            EBInfo._version();
            System.exit(0);
        }
        String path = null;
        String[] paths = cmd.getArgs();
        int len = ArrayUtils.getLength((Object)paths);
        switch (len) {
            case 0: {
                path = DEFAULT_BOOK_DIR;
                break;
            }
            case 1: {
                path = paths[0];
                break;
            }
            default: {
                System.err.println(_PROGRAM + ": too many arguments");
                EBInfo._usage();
                System.exit(1);
            }
        }
        try {
            EBInfo ebinfo = new EBInfo(path);
            ebinfo._show(multi);
        }
        catch (EBException e) {
            System.err.println(_PROGRAM + ": " + e.getMessage());
        }
    }

    private static void _usage() {
        System.out.println("Try `java " + _PROGRAM + " --help' for more information");
    }

    private static void _usage(Options options) {
        HelpFormatter fmt = new HelpFormatter();
        fmt.printHelp("java " + _PROGRAM + " [option...] [book-directory]", "\nOptions:", options, "\nReport bugs to <fukumoto@users.sourceforge.jp>.", false);
    }

    private static void _version() {
        Package pkg = EBInfo.class.getPackage();
        System.out.println(_PROGRAM + " " + pkg.getImplementationVersion());
        System.out.println(_COPYRIGHT);
        System.out.println("All right reserved.");
    }

    private EBInfo(String path) throws EBException {
        this._book = new Book(path);
    }

    private void _show(boolean multi) {
        String text = null;
        System.out.print("disc type: ");
        text = this._book.getBookType() == 0 ? "EB/EBG/EBXA/EBXA-C/S-EBXA" : (this._book.getBookType() == 1 ? "EPWING V" + this._book.getVersion() : "unknown");
        System.out.println(text);
        System.out.print("character code: ");
        switch (this._book.getCharCode()) {
            case 1: {
                text = "ISO 8859-1";
                break;
            }
            case 2: {
                text = "JIS X 0208";
                break;
            }
            case 3: {
                text = "JIS X 0208 + GB 2312";
                break;
            }
            default: {
                text = "unknown";
            }
        }
        System.out.println(text);
        System.out.print("the number of subbooks: ");
        System.out.println(this._book.getSubBookCount());
        System.out.println("");
        SubBook[] subs = this._book.getSubBooks();
        for (int i = 0; i < subs.length; ++i) {
            String hex;
            System.out.println("subbook " + (i + 1) + ":");
            System.out.println("  title: " + subs[i].getTitle());
            System.out.println("  directory: " + subs[i].getName());
            System.out.print("  search methods:");
            if (subs[i].hasWordSearch()) {
                System.out.print(" word");
            }
            if (subs[i].hasEndwordSearch()) {
                System.out.print(" endword");
            }
            if (subs[i].hasExactwordSearch()) {
                System.out.print(" exactword");
            }
            if (subs[i].hasKeywordSearch()) {
                System.out.print(" keyword");
            }
            if (subs[i].hasCrossSearch()) {
                System.out.print(" cross");
            }
            if (subs[i].hasMultiSearch()) {
                System.out.print(" multi");
            }
            if (subs[i].hasMenu()) {
                System.out.print(" menu");
            }
            if (subs[i].hasImageMenu()) {
                System.out.print(" image-menu");
            }
            if (subs[i].hasCopyright()) {
                System.out.print(" copyright");
            }
            System.out.println("");
            System.out.print("  font sizes:");
            for (int j = 0; j < 4; ++j) {
                ExtFont font = subs[i].getFont(j);
                if (!font.hasFont()) continue;
                System.out.print(" " + font.getFontHeight());
            }
            System.out.println("");
            ExtFont font = subs[i].getFont();
            System.out.print("  narrow font characters:");
            if (font.hasNarrowFont()) {
                int code = font.getNarrowFontStart();
                hex = HexUtil.toHexString((int)code);
                System.out.print("0x" + hex + " -- ");
                code = font.getNarrowFontEnd();
                hex = HexUtil.toHexString((int)code);
                System.out.print("0x" + hex);
            }
            System.out.println("");
            System.out.print("  wide font characters:");
            if (font.hasWideFont()) {
                int code = font.getWideFontStart();
                hex = HexUtil.toHexString((int)code);
                System.out.print("0x" + hex + " -- ");
                code = font.getWideFontEnd();
                hex = HexUtil.toHexString((int)code);
                System.out.print("0x" + hex);
            }
            System.out.println("");
            if (!multi) continue;
            this._showMulti(subs[i]);
        }
    }

    private void _showMulti(SubBook sub) {
        if (!sub.hasMultiSearch()) {
            return;
        }
        System.out.println("");
        int count = sub.getMultiCount();
        for (int i = 0; i < count; ++i) {
            System.out.println("  multi search " + Integer.toString(i + 1) + ":");
            int entry = sub.getMultiEntryCount(i);
            for (int j = 0; j < entry; ++j) {
                System.out.println("    label " + Integer.toString(j + 1) + ": " + sub.getMultiEntryLabel(i, j));
                String text = null;
                text = sub.hasMultiEntryCandidate(i, j) ? "exist" : "not-exist";
                System.out.println("     candidates: " + text);
            }
        }
    }
}

