/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.SubBook;
import fuku.eb4j.hook.Hook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;

public class BookReader<T> {
    private static final int TEXT = 0;
    private static final int HEADING = 1;
    private SubBook _sub = null;
    private EBFile _file = null;
    private BookInputStream _bis = null;
    private Hook<T> _hook = null;
    private int _autoStopCode = -1;
    private int _skipCode = -1;

    public BookReader(SubBook sub, Hook<T> hook) throws EBException {
        this._sub = sub;
        this._file = sub.getTextFile();
        this._bis = this._file.getInputStream();
        this._hook = hook;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this._bis != null) {
            this._bis.close();
        }
    }

    public T readHeading(long page, int offset) throws EBException {
        this._hook.clear();
        this._read(BookInputStream.getPosition(page, offset), 1, false);
        return this._hook.getObject();
    }

    public T readHeading(long pos) throws EBException {
        this._hook.clear();
        this._read(pos, 1, false);
        return this._hook.getObject();
    }

    public long nextHeadingPosition(long pos) throws EBException {
        return this._read(pos, 1, true);
    }

    public T readText(long page, int offset) throws EBException {
        this._hook.clear();
        this._read(BookInputStream.getPosition(page, offset), 0, false);
        return this._hook.getObject();
    }

    public T readText(long pos) throws EBException {
        this._hook.clear();
        this._read(pos, 0, false);
        return this._hook.getObject();
    }

    private long _read(long pos, int type, boolean skip) throws EBException {
        this._bis.seek(pos);
        byte[] b = new byte[2048];
        int len = this._bis.read(b, 0, b.length);
        if (len < 0) {
            return -1L;
        }
        if (len == 0) {
            throw new EBException(5, this._file.getPath());
        }
        int off = 0;
        boolean eof = false;
        boolean printable = false;
        while (!eof) {
            block151: {
                block150: {
                    if (off + 2 > len) {
                        int n = this._readRaw(b, off, len - off);
                        len = len - off + n;
                        off = 0;
                    }
                    if ((b[off] & 0xFF) != 31) break block150;
                    int code = ByteUtil.getInt2(b, off);
                    switch (b[off + 1] & 0xFF) {
                        case 2: {
                            off += 2;
                            break;
                        }
                        case 3: {
                            eof = true;
                            break;
                        }
                        case 4: {
                            off += 2;
                            if (!skip) {
                                this._hook.beginNarrow();
                                break;
                            }
                            break block151;
                        }
                        case 5: {
                            off += 2;
                            if (!skip) {
                                this._hook.endNarrow();
                                break;
                            }
                            break block151;
                        }
                        case 6: {
                            off += 2;
                            if (!skip) {
                                this._hook.beginSubscript();
                                break;
                            }
                            break block151;
                        }
                        case 7: {
                            off += 2;
                            if (!skip) {
                                this._hook.endSubscript();
                                break;
                            }
                            break block151;
                        }
                        case 9: {
                            int n;
                            if (off + 4 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (printable && type == 0 && this._isStopCode(code, ByteUtil.getInt2(b, off + 2))) {
                                eof = true;
                            } else if (!skip) {
                                this._hook.setIndent(ByteUtil.getInt2(b, off + 2));
                            }
                            off += 4;
                            break;
                        }
                        case 10: {
                            off += 2;
                            if (type == 1) {
                                eof = true;
                                break;
                            }
                            if (!skip) {
                                this._hook.newLine();
                                break;
                            }
                            break block151;
                        }
                        case 14: {
                            off += 2;
                            if (!skip) {
                                this._hook.beginSuperscript();
                                break;
                            }
                            break block151;
                        }
                        case 15: {
                            off += 2;
                            if (!skip) {
                                this._hook.endSuperscript();
                                break;
                            }
                            break block151;
                        }
                        case 16: {
                            off += 2;
                            if (!skip) {
                                this._hook.beginNoNewLine();
                                break;
                            }
                            break block151;
                        }
                        case 17: {
                            off += 2;
                            if (!skip) {
                                this._hook.endNoNewLine();
                                break;
                            }
                            break block151;
                        }
                        case 18: {
                            off += 2;
                            if (!skip) {
                                this._hook.beginEmphasis();
                                break;
                            }
                            break block151;
                        }
                        case 19: {
                            off += 2;
                            if (!skip) {
                                this._hook.endEmphasis();
                                break;
                            }
                            break block151;
                        }
                        case 20: {
                            off += 4;
                            this._skipCode = 21;
                            break;
                        }
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: {
                            int n;
                            if (off + 4 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (this._sub.getBook().getBookType() == 0 && (b[off + 2] & 0xFF) >= 31) {
                                off += 2;
                                break;
                            }
                            off += 4;
                            break;
                        }
                        case 50: {
                            off += 2;
                            if (!skip) {
                                this._hook.beginMonoGraphic(0, 0);
                                break;
                            }
                            break block151;
                        }
                        case 57: {
                            int width;
                            int format;
                            int n;
                            if (off + 46 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                format = ByteUtil.getInt2(b, off + 2);
                                width = ByteUtil.getBCD2(b, off + 10);
                                int height = ByteUtil.getBCD2(b, off + 12);
                                int n2 = 8;
                                int[] args = new int[n2];
                                for (int i = 0; i < n2; ++i) {
                                    args[i] = ByteUtil.getInt2(b, off + 22 + i * 2);
                                }
                                byte[] name = new byte[n2];
                                int size = n2;
                                for (int i = 0; i < n2; ++i) {
                                    int high = args[i] >>> 8 & 0xFF;
                                    int low = args[i] & 0xFF;
                                    if (high == 33 && low == 33 || high == 0 && low == 0) {
                                        size = i;
                                        break;
                                    }
                                    if (high == 35) {
                                        if (low >= 48 && low <= 57 || low >= 97 && low <= 122) {
                                            name[i] = (byte)low;
                                            continue;
                                        }
                                        if (low >= 65 && low <= 90) {
                                            name[i] = (byte)(low | 0x20);
                                            continue;
                                        }
                                        size = 0;
                                        break;
                                    }
                                    size = 0;
                                    break;
                                }
                                if (size != 0) {
                                    this._hook.beginMovie(format >>> 12, width, height, new String(name, 0, size));
                                }
                            }
                            off += 46;
                            break;
                        }
                        case 60: {
                            int page;
                            int format;
                            int n;
                            if (off + 20 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                format = ByteUtil.getInt2(b, off + 2);
                                page = ByteUtil.getBCD4(b, off + 14);
                                int offset = ByteUtil.getBCD2(b, off + 18);
                                long imgpos = BookInputStream.getPosition(page, offset);
                                this._hook.beginInlineColorGraphic(format >>> 12, imgpos);
                            }
                            off += 20;
                            break;
                        }
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 58: 
                        case 59: 
                        case 61: 
                        case 62: 
                        case 63: {
                            this._skipCode = (b[(off += 2) - 1] & 0xFF) + 32;
                            break;
                        }
                        case 65: {
                            int n;
                            if (off + 4 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (printable && type == 0 && this._isStopCode(code, ByteUtil.getInt2(b, off + 2))) {
                                eof = true;
                            } else {
                                if (this._autoStopCode < 0) {
                                    this._autoStopCode = ByteUtil.getInt2(b, off + 2);
                                }
                                if (!skip) {
                                    this._hook.beginKeyword();
                                }
                            }
                            off += 4;
                            break;
                        }
                        case 66: {
                            int n;
                            if (off + 4 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            off = (b[off + 2] & 0xFF) != 0 ? (off += 2) : (off += 4);
                            if (!skip) {
                                this._hook.beginReference();
                                break;
                            }
                            break block151;
                        }
                        case 67: {
                            off += 2;
                            if (!skip) {
                                this._hook.beginCandidate();
                                break;
                            }
                            break block151;
                        }
                        case 68: {
                            int width;
                            int n;
                            if (off + 12 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                int height = ByteUtil.getBCD4(b, off + 4);
                                width = ByteUtil.getBCD4(b, off + 8);
                                if (width > 0 && height > 0) {
                                    this._hook.beginMonoGraphic(width, height);
                                }
                            }
                            off += 12;
                            break;
                        }
                        case 69: {
                            int n;
                            if (off + 4 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if ((b[off + 2] & 0xFF) != 31) {
                                off += 4;
                                break;
                            }
                            off += 6;
                            break;
                        }
                        case 74: {
                            int format;
                            int n;
                            if (off + 18 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                format = ByteUtil.getInt2(b, off + 2);
                                int page1 = ByteUtil.getBCD4(b, off + 6);
                                int offset1 = ByteUtil.getBCD2(b, off + 10);
                                int page2 = ByteUtil.getBCD4(b, off + 12);
                                int offset2 = ByteUtil.getBCD2(b, off + 16);
                                long pos1 = BookInputStream.getPosition(page1, offset1);
                                long pos2 = BookInputStream.getPosition(page2, offset2);
                                this._hook.beginSound(format & 0xF, pos1, pos2);
                            }
                            off += 18;
                            break;
                        }
                        case 75: {
                            int n;
                            if (off + 10 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            int page = ByteUtil.getBCD4(b, 2);
                            int offset = ByteUtil.getBCD2(b, 6);
                            long refpos = BookInputStream.getPosition(page, offset);
                            if ((b[off += 8] & 0xFF) == 31 && (b[off + 1] & 0xFF) == 107) {
                                off += 2;
                                eof = true;
                                if (!skip) {
                                    this._hook.setGraphicReference(refpos);
                                    break;
                                }
                            } else if (!skip) {
                                this._hook.beginGraphicReference(refpos);
                                break;
                            }
                            break block151;
                        }
                        case 76: {
                            int n;
                            if (off + 4 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            off += 4;
                            if (!skip) {
                                this._hook.beginImagePage();
                                break;
                            }
                            break block151;
                        }
                        case 77: {
                            int page;
                            int format;
                            int n;
                            if (off + 20 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                format = ByteUtil.getInt2(b, off + 2);
                                page = ByteUtil.getBCD4(b, off + 14);
                                int offset = ByteUtil.getBCD2(b, off + 18);
                                long imgpos = BookInputStream.getPosition(page, offset);
                                this._hook.beginColorGraphic(format >>> 12, imgpos);
                            }
                            off += 20;
                            break;
                        }
                        case 79: {
                            int n;
                            if (off + 34 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                int x = ByteUtil.getBCD2(b, off + 8);
                                int y = ByteUtil.getBCD2(b, off + 10);
                                int w = ByteUtil.getBCD2(b, off + 12);
                                int h = ByteUtil.getBCD2(b, off + 14);
                                int page = ByteUtil.getBCD4(b, off + 28);
                                int offset = ByteUtil.getBCD2(b, off + 32);
                                long refpos = BookInputStream.getPosition(page, offset);
                                this._hook.beginClickableArea(x, y, w, h, refpos);
                            }
                            off += 34;
                            break;
                        }
                        case 73: 
                        case 78: {
                            this._skipCode = (b[(off += 2) - 1] & 0xFF) + 32;
                            break;
                        }
                        case 82: {
                            int offset;
                            int page;
                            int n;
                            if (off + 8 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                page = ByteUtil.getBCD4(b, off + 2);
                                offset = ByteUtil.getBCD2(b, off + 6);
                                long imgpos = BookInputStream.getPosition(page, offset);
                                this._hook.endMonoGraphic(imgpos);
                            }
                            off += 8;
                            break;
                        }
                        case 83: {
                            int n;
                            if (off + 10 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            off += 10;
                            break;
                        }
                        case 89: {
                            off += 2;
                            if (!skip) {
                                this._hook.endMovie();
                                break;
                            }
                            break block151;
                        }
                        case 92: {
                            off += 2;
                            if (!skip) {
                                this._hook.endInlineColorGraphic();
                                break;
                            }
                            break block151;
                        }
                        case 97: {
                            off += 2;
                            if (!skip) {
                                this._hook.endKeyword();
                                break;
                            }
                            break block151;
                        }
                        case 98: {
                            int offset;
                            int page;
                            int n;
                            if (off + 8 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                page = ByteUtil.getBCD4(b, off + 2);
                                offset = ByteUtil.getBCD2(b, off + 6);
                                long refpos = BookInputStream.getPosition(page, offset);
                                this._hook.endReference(refpos);
                            }
                            off += 8;
                            break;
                        }
                        case 99: {
                            int offset;
                            int page;
                            int n;
                            if (off + 8 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                page = ByteUtil.getBCD4(b, off + 2);
                                offset = ByteUtil.getBCD2(b, off + 6);
                                if (page == 0 && offset == 0) {
                                    this._hook.endCandidateLeaf();
                                } else {
                                    long grppos = BookInputStream.getPosition(page, offset);
                                    this._hook.endCandidateGroup(grppos);
                                }
                            }
                            off += 8;
                            break;
                        }
                        case 100: {
                            int offset;
                            int page;
                            int n;
                            if (off + 8 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                page = ByteUtil.getBCD4(b, off + 2);
                                offset = ByteUtil.getBCD2(b, off + 6);
                                long imgpos = BookInputStream.getPosition(page, offset);
                                this._hook.endMonoGraphic(imgpos);
                            }
                            off += 8;
                            break;
                        }
                        case 106: {
                            off += 2;
                            if (!skip) {
                                this._hook.endSound();
                                break;
                            }
                            break block151;
                        }
                        case 107: {
                            off += 2;
                            if (!skip) {
                                this._hook.endGraphicReference();
                                break;
                            }
                            break block151;
                        }
                        case 108: {
                            off += 2;
                            eof = true;
                            if (!skip) {
                                this._hook.endImagePage();
                                break;
                            }
                            break block151;
                        }
                        case 109: {
                            off += 2;
                            if (!skip) {
                                this._hook.endColorGraphic();
                                break;
                            }
                            break block151;
                        }
                        case 111: {
                            off += 2;
                            if (!skip) {
                                this._hook.endClickableArea();
                                break;
                            }
                            break block151;
                        }
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 128: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: {
                            this._skipCode = (b[(off += 2) - 1] & 0xFF) + 32;
                            break;
                        }
                        case 224: {
                            int n;
                            if (off + 4 > len) {
                                n = this._readRaw(b, off, len - off);
                                len = len - off + n;
                                off = 0;
                            }
                            if (!skip) {
                                this._hook.beginDecoration(ByteUtil.getInt2(b, off + 2));
                            }
                            if (this._sub.getBook().getBookType() == 0 && (b[off + 2] & 0xFF) >= 31) {
                                off += 2;
                                break;
                            }
                            off += 4;
                            break;
                        }
                        case 225: {
                            off += 2;
                            if (!skip) {
                                this._hook.endDecoration();
                                break;
                            }
                            break block151;
                        }
                        case 228: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 236: 
                        case 238: 
                        case 240: 
                        case 242: 
                        case 244: 
                        case 246: 
                        case 248: 
                        case 250: 
                        case 252: 
                        case 254: {
                            this._skipCode = (b[(off += 2) - 1] & 0xFF) + 1;
                            break;
                        }
                        default: {
                            if ((b[(off += 2) - 1] & 0xFF) == this._skipCode) {
                                this._skipCode = -1;
                                break;
                            }
                            break block151;
                        }
                    }
                    break block151;
                }
                if (this._sub.getBook().getCharCode() == 1) {
                    printable = true;
                    if (this._skipCode == -1) {
                        int ch = b[off] & 0xFF;
                        if (ch >= 32 && ch <= 127 || ch >= 160 && ch <= 255) {
                            if (!skip) {
                                this._hook.append((char)ch);
                            }
                            ++off;
                        } else {
                            int code = ByteUtil.getInt2(b, off);
                            if (!skip) {
                                this._hook.append(code);
                            }
                            off += 2;
                        }
                    }
                } else {
                    printable = true;
                    if (this._skipCode == -1) {
                        int high = b[off] & 0xFF;
                        int low = b[off + 1] & 0xFF;
                        if (high > 32 && high < 127 && low > 32 && low < 127) {
                            if (!skip) {
                                this._hook.append(ByteUtil.jisx0208ToString(b, off, 2));
                            }
                        } else if (high > 32 && high > 127 && low > 160 && low < 255) {
                            if (!skip) {
                                this._hook.append(ByteUtil.gb2312ToString(b, off, 2));
                            }
                        } else if (high > 160 && high < 255 && low > 32 && low < 127) {
                            int code = ByteUtil.getInt2(b, off);
                            if (!skip) {
                                this._hook.append(code);
                            }
                        }
                    }
                    off += 2;
                }
            }
            if (skip || this._hook.isMoreInput()) continue;
            break;
        }
        return pos + (long)off;
    }

    private int _readRaw(byte[] b, int off, int len) throws EBException {
        System.arraycopy(b, off, b, 0, len);
        int n = this._bis.read(b, len, b.length - len);
        if (n == 0) {
            throw new EBException(5, this._file.getPath());
        }
        return n;
    }

    private boolean _isStopCode(int code0, int code1) {
        if (this._sub.getSubAppendix() != null && this._sub.getSubAppendix().hasStopCode()) {
            return this._sub.getSubAppendix().isStopCode(code0, code1);
        }
        return code0 == 8001 && code1 == this._autoStopCode;
    }
}

