package fuku.webbook;

import java.io.File;
import java.net.URL;
import java.net.MalformedURLException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.springframework.web.util.WebUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.Log;

import static fuku.webbook.WebBookConstants.KEY_WEBBOOK_CONFIG;

/**
 * WebBookコンテキストリスナ。
 *
 * @author Hisaya FUKUMOTO
 */
public class WebBookContextListener implements ServletContextListener {

    /** ログ */
    private Log _log = null;


    /**
     * コンストラクタ。
     *
     */
    public WebBookContextListener() {
        super();
        _log = LogFactory.getLog(getClass());
    }


    /**
     * Webアプリケーションが要求を処理する準備ができたときに呼び出されます。
     *
     * @param evt サーブレットコンテキストイベント
     */
    @Override
    public void contextInitialized(ServletContextEvent evt) {
        ServletContext context = evt.getServletContext();
        String config = context.getInitParameter("config");
        URL configUrl = null;
        try {
            configUrl = context.getResource(config);
        } catch (MalformedURLException e) {
        }
        String schema = context.getInitParameter("schema");
        URL schemaUrl = null;
        try {
            schemaUrl = context.getResource(schema);
        } catch (MalformedURLException e) {
        }
        File workdir = WebUtils.getTempDir(context);
        WebBookConfig webbookConfig = new WebBookConfig(workdir);
        if (configUrl != null && schemaUrl != null) {
            _log.info("load configuration file [" + configUrl.toString() + "]");
            try {
                webbookConfig.load(configUrl, schemaUrl);
            } catch (Exception e) {
                _log.warn("failed to initialization", e);
            }
        } else {
            if (configUrl == null) {
                _log.warn("undefined config parameter");
            }
            if (schemaUrl == null) {
                _log.warn("undefined schema parameter");
            }
        }
        context.setAttribute(KEY_WEBBOOK_CONFIG, webbookConfig);
    }

    /**
     * サーブレットコンテキストがシャットダウン処理に入ると呼び出されます。
     *
     * @param evt サーブレットコンテキストイベント
     */
    @Override
    public void contextDestroyed(ServletContextEvent evt) {
        ServletContext context = evt.getServletContext();
        context.removeAttribute(KEY_WEBBOOK_CONFIG);
    }
}

// end of WebBookContextListener.java
