package fuku.webbook.acl;

import junit.framework.TestCase;

public class HostEntryTest extends TestCase {

    public void testAllowed() {
        String hostList = "example1\\.com, example2\\.com, .*\\.example3\\.com";
        HostEntry entry = new HostEntry(true, hostList);
        assertFalse(entry.isAllowed("example0.com"));
        assertTrue(entry.isAllowed("example1.com"));
        assertTrue(entry.isAllowed("example2.com"));
        assertFalse(entry.isAllowed("aaa.example2.com"));
        assertTrue(entry.isAllowed("aaa.example3.com"));
    }

    public void testDenied() {
        String hostList = "example1\\.com, example2\\.com, .*\\.example3\\.com";
        HostEntry entry = new HostEntry(false, hostList);
        assertTrue(entry.isAllowed("example0.com"));
        assertFalse(entry.isAllowed("example1.com"));
        assertFalse(entry.isAllowed("example2.com"));
        assertTrue(entry.isAllowed("aaa.example2.com"));
        assertFalse(entry.isAllowed("aaa.example3.com"));
    }
}

// end of HostEntryTest.java
