/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import fuku.xml2eb.Index;
import fuku.xml2eb.IndexLayer;
import fuku.xml2eb.Reference;
import fuku.xml2eb.Word;
import fuku.xml2eb.WordSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexWriter {
    private Log _log = LogFactory.getLog(this.getClass());
    private File _file = null;
    private List<IndexLayer> _layerList = null;
    private List<OutputStream> _streamList = null;
    private int _depth = 0;
    private Reference _ref = null;

    public IndexWriter(File file) {
        this._file = file;
        this._layerList = new ArrayList<IndexLayer>();
        this._streamList = new ArrayList<OutputStream>();
    }

    public void setReference(Reference ref) {
        this._ref = ref;
    }

    public void close() {
        if (this._layerList.isEmpty()) {
            return;
        }
        try {
            int i;
            IndexLayer layer = this._layerList.get(0);
            Index lastIndex = layer.getLastIndex();
            for (i = 1; i < this._depth; ++i) {
                layer = this._layerList.get(i - 1);
                Index upperIndex = new Index(lastIndex.getWord(), layer.getBlock());
                this._addUpperLayer(i, upperIndex);
            }
            this._writeLeafLayer(true);
            for (i = 1; i < this._depth; ++i) {
                this._writeUpperLayer(i, true);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int i = 0; i < this._depth; ++i) {
            OutputStream out = this._streamList.get(i);
            try {
                out.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void write(WordSet set) throws IOException {
        if (set.isEmpty()) {
            return;
        }
        IndexLayer layer = new IndexLayer(this._file, this._depth++);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(layer.getFile()));
        this._layerList.add(layer);
        this._streamList.add(stream);
        for (Word word : set) {
            int n = layer.getBlockLength() + word.getWordLength() + 13;
            if (n > 2048) {
                this._writeLeafLayer();
                if (this._depth == 1) {
                    IndexLayer upperLayer = new IndexLayer(this._file, this._depth++);
                    BufferedOutputStream upperStream = new BufferedOutputStream(new FileOutputStream(upperLayer.getFile()));
                    this._layerList.add(upperLayer);
                    this._streamList.add(upperStream);
                }
                Index upperIndex = layer.getLastIndex();
                this._addUpperLayer(1, upperIndex);
                layer.clear();
            }
            Index index = new Index(word, layer.getBlock());
            layer.add(index);
        }
    }

    private void _addUpperLayer(int level, Index index) throws IOException {
        this._log.trace((Object)("level=" + level + ", word=" + index.getWord()));
        IndexLayer layer = this._layerList.get(level);
        int wordLen = index.getWord().getWordLength();
        int curLen = layer.getWordLength();
        int n = 0;
        n = curLen < wordLen ? (layer.size() + 2) * (wordLen + 4) + 4 : (layer.size() + 2) * (curLen + 4) + 4;
        if (n > 2048) {
            this._writeUpperLayer(level);
            if (this._depth == level + 1) {
                IndexLayer upperLayer = new IndexLayer(this._file, this._depth++);
                BufferedOutputStream upperStream = new BufferedOutputStream(new FileOutputStream(upperLayer.getFile()));
                this._layerList.add(upperLayer);
                this._streamList.add(upperStream);
            }
            Index lastIndex = layer.getLastIndex();
            Index upperIndex = new Index(lastIndex.getWord(), layer.getBlock());
            this._addUpperLayer(level + 1, upperIndex);
            layer.clear();
            curLen = layer.getWordLength();
        }
        layer.add(index);
        if (curLen < wordLen) {
            layer.setWordLength(wordLen);
        }
    }

    private void _writeLeafLayer() throws IOException {
        this._writeLeafLayer(false);
    }

    private void _writeLeafLayer(boolean last) throws IOException {
        IndexLayer layer = this._layerList.get(0);
        if (layer.isEmpty()) {
            return;
        }
        int id = 128;
        if (layer.getBlock() == 1L) {
            id |= 0x40;
        }
        if (last) {
            id |= 0x20;
        }
        byte[] buf = new byte[2048];
        Arrays.fill(buf, (byte)0);
        buf[0] = (byte)id;
        int size = layer.size();
        buf[2] = (byte)(size >>> 8 & 0xFF);
        buf[3] = (byte)(size & 0xFF);
        long pos = (layer.getBlock() - 1L) * 2048L;
        int off = 4;
        for (int i = 0; i < size; ++i) {
            Index index = (Index)layer.get(i);
            Word word = index.getWord();
            byte[] b = word.getWord();
            int len = b.length;
            buf[off++] = (byte)(len & 0xFF);
            System.arraycopy(b, 0, buf, off, len);
            String name = word.getReferenceTag();
            this._ref.putBodyRef(layer.getFile(), pos + (long)(off += len), name);
            this._ref.putHeadRef(layer.getFile(), pos + (long)(off += 6), name);
            off += 6;
        }
        OutputStream out = this._streamList.get(0);
        out.write(buf, 0, buf.length);
        out.flush();
    }

    private void _writeUpperLayer(int level) throws IOException {
        this._writeUpperLayer(level, false);
    }

    private void _writeUpperLayer(int level, boolean last) throws IOException {
        IndexLayer layer = this._layerList.get(level);
        if (layer.isEmpty()) {
            return;
        }
        int len = layer.getWordLength();
        if (last) {
            byte[] b = new byte[len];
            Arrays.fill(b, (byte)-1);
            Index lastIndex = layer.getLastIndex();
            Word dummyWord = new Word(b, "");
            long lastBlock = lastIndex.getLowerBlock();
            Index dummy = new Index(dummyWord, lastBlock);
            layer.add(dummy);
        }
        int id = 0;
        if (layer.getBlock() == 1L) {
            id |= 0x40;
        }
        if (last) {
            id |= 0x20;
        }
        byte[] buf = new byte[2048];
        Arrays.fill(buf, (byte)0);
        buf[0] = (byte)id;
        buf[1] = (byte)(len & 0xFF);
        int size = layer.size();
        buf[2] = (byte)(size >>> 8 & 0xFF);
        buf[3] = (byte)(size & 0xFF);
        long pos = (layer.getBlock() - 1L) * 2048L;
        int off = 4;
        for (int i = 0; i < size; ++i) {
            Index index = (Index)layer.get(i);
            Word word = index.getWord();
            byte[] b = word.getWord();
            System.arraycopy(b, 0, buf, off, b.length);
            String name = Long.toString(index.getLowerBlock());
            this._ref.putIndexRef(layer.getFile(), pos + (long)(off += len), name);
            off += 4;
        }
        OutputStream out = this._streamList.get(level);
        out.write(buf, 0, buf.length);
        out.flush();
        if (last) {
            layer.remove(size - 1);
        }
    }
}

