/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.xml2eb.converter.wdic.WdicGroup;
import fuku.xml2eb.converter.wdic.WdicItem;
import fuku.xml2eb.converter.wdic.WdicUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Wdic {
    private static final String ENCODING = "UTF-8";
    private Log _log = LogFactory.getLog(this.getClass());
    private WdicGroup _group = null;
    private File _file = null;
    private String _partId = null;
    private String _part = null;
    private List<WdicItem> _itemList = null;
    private Map<String, Set<WdicItem>> _pluginMap = null;

    public Wdic(WdicGroup group, String part, File file) {
        this._group = group;
        if (part.endsWith("\u7de8")) {
            int len = part.length();
            this._part = part.substring(0, len - 1);
        } else {
            this._part = part;
        }
        this._file = file;
        this._partId = this._file.getName();
        int idx = this._partId.indexOf(".");
        if (idx > 0) {
            this._partId = this._partId.substring(0, idx);
        }
        this._itemList = new ArrayList<WdicItem>();
        this._pluginMap = new HashMap<String, Set<WdicItem>>();
        this._load();
    }

    public WdicGroup getGroup() {
        return this._group;
    }

    public String getGroupId() {
        return this._group.getGroupId();
    }

    public String getGroupName() {
        return this._group.getGroupName();
    }

    public String getPartId() {
        return this._partId;
    }

    public String getPartName() {
        return this._part;
    }

    public boolean exists(String word) {
        if (StringUtils.isBlank((String)word)) {
            return false;
        }
        int len = this._itemList.size();
        for (int i = 0; i < len; ++i) {
            WdicItem item = this._itemList.get(i);
            if (!word.equals(item.getHead())) continue;
            return true;
        }
        return false;
    }

    public WdicItem getWdicItem(String word) {
        if (StringUtils.isBlank((String)word)) {
            return null;
        }
        int len = this._itemList.size();
        for (int i = 0; i < len; ++i) {
            WdicItem item = this._itemList.get(i);
            if (!word.equals(item.getHead())) continue;
            return item;
        }
        return null;
    }

    public List<WdicItem> getWdicItems() {
        return new ArrayList<WdicItem>(this._itemList);
    }

    protected void getWdicItem(String dir, List<WdicItem> list) {
        int len = this._itemList.size();
        for (int i = 0; i < len; ++i) {
            WdicItem item = this._itemList.get(i);
            List<String> dirs = item.getDir();
            if (!dirs.contains(dir)) continue;
            list.add(item);
        }
    }

    protected void getPluginMap(Map<String, Set<WdicItem>> map) {
        for (Map.Entry<String, Set<WdicItem>> item : this._pluginMap.entrySet()) {
            String key = item.getKey();
            Set<WdicItem> set = item.getValue();
            Set<WdicItem> pset = map.get(key);
            if (pset == null) {
                pset = new TreeSet<WdicItem>();
                map.put(key, pset);
            }
            pset.addAll(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        this._log.info((Object)("load file: " + this._file.getPath()));
        LineNumberReader lnr = null;
        try {
            Charset cs = Charset.forName(ENCODING);
            lnr = new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), cs)));
            String line = null;
            WdicItem item = null;
            block5: while ((line = lnr.readLine()) != null) {
                line = WdicUtil.sanitize(line);
                StringBuilder tmpLine = new StringBuilder(line);
                while (line.endsWith("\\")) {
                    int len = tmpLine.length();
                    int cnt = 1;
                    for (int idx = len - 2; idx >= 0 && tmpLine.charAt(idx) == '\\'; --idx) {
                        ++cnt;
                    }
                    if (cnt % 2 == 0) break;
                    tmpLine.delete(len - 1, len);
                    line = WdicUtil.sanitize(lnr.readLine());
                    line = WdicUtil.deleteTab(line);
                    tmpLine.append(line);
                }
                if ((line = tmpLine.toString()).startsWith("%")) {
                    item = null;
                    continue;
                }
                if (line.startsWith("#")) {
                    String head = line.substring(1).trim();
                    item = new WdicItem(this, head, this._itemList.size());
                    this._itemList.add(item);
                    continue;
                }
                if (line.startsWith("\t")) {
                    int idx;
                    if (StringUtils.isBlank((String)(line = line.substring(1)))) continue;
                    if (item == null) {
                        this._log.warn((Object)("unknown context: " + this._file.getName() + "[" + lnr.getLineNumber() + "] " + "'" + line + "'"));
                        continue;
                    }
                    String block = WdicUtil.deleteTab(line);
                    if (block.startsWith("yomi:")) {
                        idx = "yomi:".length();
                        String yomi = block.substring(idx).trim();
                        item.addYomi(yomi);
                        continue;
                    }
                    if (block.startsWith("qyomi:")) {
                        idx = "qyomi:".length();
                        String yomi = block.substring(idx).trim();
                        item.addYomi(yomi);
                        continue;
                    }
                    if (block.startsWith("spell:")) {
                        idx = "spell:".length();
                        String str = block.substring(idx).trim();
                        if ((idx = str.indexOf(":")) == -1) {
                            this._log.warn((Object)("undefined language: " + this._file.getName() + "[" + lnr.getLineNumber() + "] " + "'" + line + "'"));
                            item.addSpell("en", str);
                            continue;
                        }
                        String lang = str.substring(0, idx).trim();
                        String spell = str.substring(idx + 1).trim();
                        item.addSpell(lang, spell);
                        continue;
                    }
                    if (block.startsWith("pron:")) {
                        idx = "pron:".length();
                        String str = block.substring(idx).trim();
                        idx = str.indexOf(":");
                        String lang = str.substring(0, idx).trim();
                        String pron = str.substring(idx + 1).trim();
                        item.addPronounce(lang, pron);
                        continue;
                    }
                    if (block.startsWith("pos:")) {
                        idx = "pos:".length();
                        String pos = block.substring(idx).trim();
                        item.addSpeech(pos);
                        continue;
                    }
                    if (block.startsWith("dir:")) {
                        idx = "dir:".length();
                        String dir = block.substring(idx).trim();
                        item.addDir(dir);
                        continue;
                    }
                    if (block.startsWith("flag:") || block.startsWith("author:") || block.startsWith("valid:") || block.startsWith("expire:") || block.startsWith("anniv:")) continue;
                    boolean ignore = false;
                    if (!block.startsWith("= ")) {
                        if (block.startsWith("* ")) {
                            if (block.contains("\\elmtable{")) {
                                ignore = true;
                            }
                        } else if (!(block.startsWith("+ ") || block.startsWith("- ") || block.startsWith("-! ") || block.startsWith(":") || block.startsWith("|") || block.startsWith("))") || block.startsWith(">>"))) {
                            if (block.startsWith("%%")) {
                                ignore = true;
                            } else if (!block.startsWith("=> ") && !block.startsWith("//LINK")) {
                                ignore = true;
                                this._log.warn((Object)("unknown block: " + this._file.getName() + "[" + lnr.getLineNumber() + "] " + "'" + line + "'"));
                            }
                        }
                    }
                    if (ignore) continue;
                    item.addBody(line);
                    int idx1 = WdicUtil.indexOf(block, "[[", 0);
                    int idx2 = -1;
                    while (idx1 != -1) {
                        idx2 = WdicUtil.indexOf(block, "]]", idx1 + 2);
                        if (idx2 < 0) {
                            this._log.warn((Object)("not found reference end tag: " + this._file.getName() + "[" + lnr.getLineNumber() + "] " + "'" + line + "'"));
                            continue block5;
                        }
                        if (idx1 + 2 == idx2) {
                            this._log.warn((Object)("not found reference context: " + this._file.getName() + "[" + lnr.getLineNumber() + "] " + "'" + line + "'"));
                        } else {
                            int idx3;
                            String str = block.substring(idx1 + 2, idx2);
                            if (str.charAt(0) == '<' && (idx3 = WdicUtil.indexOf(str, ">", 1)) != -1) {
                                str = str.substring(idx3 + 1);
                            }
                            if (str.startsWith("//")) {
                                String name;
                                Set<WdicItem> set;
                                idx3 = str.indexOf("|");
                                if (idx3 > 0) {
                                    str = str.substring(0, idx3).trim();
                                }
                                if ((set = this._pluginMap.get(name = str.substring((idx3 = str.lastIndexOf("/")) + 1))) == null) {
                                    set = new HashSet<WdicItem>();
                                    this._pluginMap.put(name, set);
                                }
                                set.add(item);
                            }
                        }
                        idx1 = WdicUtil.indexOf(block, "[[", idx2 + 2);
                    }
                    continue;
                }
                item = null;
            }
            this._log.info((Object)("loaded " + this._itemList.size() + " items"));
            IOUtils.closeQuietly((Reader)lnr);
        }
        catch (IOException e) {
            this._log.fatal((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(lnr);
        }
    }
}

