/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.eb4j.util.HexUtil;
import fuku.xml2eb.util.FontUtil;
import fuku.xml2eb.util.UnicodeUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WdicUtil {
    private static final Log _log;
    private static final Map<String, String> _charMap;
    private static final Map<Character.UnicodeBlock, Font[]> _fontBlockMap;
    private static final Map<Integer, Font> _fontCodeMap;
    private static Font[] DEFAULT_FONT;
    private static final Font[] LOGICAL_FONT;
    private static final int TOP = 0;
    private static final int MIDDLE = 1;
    private static final int BOTTOM = 2;

    private WdicUtil() {
    }

    public static int getTabCount(String str) {
        int tab = 0;
        int len = str.length();
        for (int i = 0; i < len && str.charAt(i) == '\t'; ++i) {
            ++tab;
        }
        return tab;
    }

    public static String deleteTab(String str) {
        if (str == null) {
            return "";
        }
        return str.substring(WdicUtil.getTabCount(str));
    }

    public static String sanitize(String str) {
        if (str != null && str.length() > 0) {
            switch (str.charAt(0)) {
                case '\u001a': 
                case '\ufeff': {
                    str = str.substring(1);
                    break;
                }
            }
        }
        return UnicodeUtil.sanitizeUnicode((String)str);
    }

    public static int indexOf(String str, String searchStr, int offset) {
        int len = str.length();
        while (offset < len) {
            int idx1 = str.indexOf(searchStr, offset);
            if (idx1 <= offset) {
                return idx1;
            }
            if (str.charAt(idx1 - 1) != '\\') {
                return idx1;
            }
            int cnt = 1;
            for (int idx2 = idx1 - 2; idx2 >= offset && str.charAt(idx2) == '\\'; --idx2) {
                ++cnt;
            }
            if (cnt % 2 == 0) {
                return idx1;
            }
            offset = idx1 + 1;
        }
        return -1;
    }

    public static String unescape(String str) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int codePoint = str.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                buf.appendCodePoint(codePoint);
                i = i + Character.charCount(codePoint) - 1;
                continue;
            }
            char ch = (char)codePoint;
            if (ch != '\\') {
                buf.append(ch);
                continue;
            }
            if (i + 1 >= len) {
                buf.append(ch);
                continue;
            }
            char ch1 = str.charAt(i + 1);
            if (ch1 >= '!' && ch1 <= '~' && !CharUtils.isAsciiAlphanumeric((char)ch1)) {
                ++i;
                buf.append(ch1);
                continue;
            }
            int idx = WdicUtil.indexOf(str, ";", i + 1);
            if (idx < 0) {
                _log.error((Object)("unexpected format: " + str));
                buf.append(ch);
                continue;
            }
            String ref = str.substring(i + 1, idx);
            i = idx;
            int sep1 = WdicUtil.indexOf(ref, "{", 0);
            int sep2 = WdicUtil.indexOf(ref, ":", 0);
            if (sep1 == -1 && sep2 == -1) {
                buf.append(WdicUtil.getCharacter(ref));
                continue;
            }
            String name = null;
            ArrayList<String> param = new ArrayList<String>();
            if (sep1 != -1 && sep2 != -1) {
                if (sep2 < sep1) {
                    sep1 = -1;
                } else {
                    sep2 = -1;
                }
            }
            if (sep1 != -1) {
                name = ref.substring(0, sep1);
                int idx1 = sep1;
                int idx2 = -1;
                while (idx1 != -1) {
                    idx2 = ref.indexOf(125, idx1 + 1);
                    if (idx2 == -1) {
                        idx2 = ref.length();
                    }
                    param.add(ref.substring(idx1 + 1, idx2));
                    idx1 = ref.indexOf(123, idx2 + 1);
                }
            } else {
                name = ref.substring(0, sep2);
                String[] arg = ref.substring(sep2 + 1).split(":");
                int n = arg.length;
                for (int j = 0; j < n; ++j) {
                    param.add(arg[j]);
                }
            }
            if ("x".equals(name)) {
                String code = (String)param.get(0);
                try {
                    codePoint = Integer.parseInt(code, 16);
                    buf.appendCodePoint(codePoint);
                }
                catch (NumberFormatException e) {
                    _log.error((Object)("unknown character code: " + code));
                }
                continue;
            }
            if (!"sup".equals(name) && !"sub".equals(name)) {
                _log.error((Object)("unknown function name: " + name));
            }
            buf.append(WdicUtil.unescape((String)param.get(0)));
        }
        return buf.toString();
    }

    public static String getCharacter(String name) {
        String ch = _charMap.get(name);
        if (ch != null) {
            return ch;
        }
        _log.error((Object)("unknown character reference: " + name));
        return name;
    }

    public static int toLargeKatakana(int codePoint) {
        switch (codePoint) {
            case 12784: {
                codePoint = 12463;
                break;
            }
            case 12785: {
                codePoint = 12471;
                break;
            }
            case 12786: {
                codePoint = 12473;
                break;
            }
            case 12787: {
                codePoint = 12488;
                break;
            }
            case 12788: {
                codePoint = 12492;
                break;
            }
            case 12789: {
                codePoint = 12495;
                break;
            }
            case 12790: {
                codePoint = 12498;
                break;
            }
            case 12791: {
                codePoint = 12501;
                break;
            }
            case 12792: {
                codePoint = 12504;
                break;
            }
            case 12793: {
                codePoint = 12507;
                break;
            }
            case 12794: {
                codePoint = 12512;
                break;
            }
            case 12795: {
                codePoint = 12521;
                break;
            }
            case 12796: {
                codePoint = 12522;
                break;
            }
            case 12797: {
                codePoint = 12523;
                break;
            }
            case 12798: {
                codePoint = 12524;
                break;
            }
            case 12799: {
                codePoint = 12525;
                break;
            }
        }
        return codePoint;
    }

    public static BufferedImage toImage(String str) {
        Font font = WdicUtil.getFont(str.codePointAt(0));
        return FontUtil.stringToImage((String)str, (int)16, (Font)font);
    }

    public static BufferedImage toImage(int codePoint) {
        String type = FontUtil.getFontType((int)codePoint);
        Font font = WdicUtil.getFont(codePoint);
        BufferedImage img = null;
        if (font.canDisplay(codePoint)) {
            img = "narrow".equals(type) ? FontUtil.charToImage((int)codePoint, (int)8, (int)16, (Font)font) : FontUtil.charToImage((int)codePoint, (int)16, (int)16, (Font)font);
        } else {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
            if (Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS.equals(unicodeBlock)) {
                codePoint = WdicUtil.toLargeKatakana(codePoint);
                font = WdicUtil.getFont(codePoint);
                img = FontUtil.smallCharToImage((int)codePoint, (int)8, (int)16, (Font)font);
            } else {
                String code = "U+" + HexUtil.toHexString((int)codePoint, (int)6);
                if (unicodeBlock == null) {
                    _log.warn((Object)("unavailable display font: [" + code + "]" + " UNKNOWN_UNICODE_BLOCK"));
                } else {
                    _log.warn((Object)("unavailable display font: [" + code + "]" + " " + unicodeBlock.toString()));
                }
                codePoint = 63;
                font = WdicUtil.getFont(codePoint);
                img = "narrow".equals(type) ? FontUtil.charToImage((int)codePoint, (int)8, (int)16, (Font)font) : FontUtil.charToImage((int)codePoint, (int)16, (int)16, (Font)font);
            }
        }
        return img;
    }

    public static BufferedImage toOverLineImage(int codePoint) {
        return WdicUtil.toLineImage(codePoint, 0);
    }

    public static BufferedImage toUnderLineImage(int codePoint) {
        return WdicUtil.toLineImage(codePoint, 2);
    }

    public static BufferedImage toLineThroughImage(int codePoint) {
        return WdicUtil.toLineImage(codePoint, 1);
    }

    private static BufferedImage toLineImage(int codePoint, int pos) {
        BufferedImage img = WdicUtil.toImage(codePoint);
        Graphics2D g2 = img.createGraphics();
        int w = img.getWidth();
        int h = img.getHeight();
        g2.setColor(Color.BLACK);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        switch (pos) {
            case 0: {
                g2.drawLine(0, 1, w, 1);
                break;
            }
            case 1: {
                g2.drawLine(0, h / 2, w, h / 2);
                break;
            }
            case 2: {
                g2.drawLine(0, h - 2, w, h - 2);
                break;
            }
        }
        g2.dispose();
        return img;
    }

    public static Font getFont(int codePoint) {
        int i;
        Font font = _fontCodeMap.get(codePoint);
        if (font != null && font.canDisplay(codePoint)) {
            return font;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
        Font[] fonts = _fontBlockMap.get(unicodeBlock);
        int len = ArrayUtils.getLength((Object)fonts);
        for (int i2 = 0; i2 < len; ++i2) {
            if (!fonts[i2].canDisplay(codePoint)) continue;
            return fonts[i2];
        }
        String code = "U+" + HexUtil.toHexString((int)codePoint, (int)6);
        if (unicodeBlock == null) {
            _log.info((Object)("undefined font: [" + code + "]" + " UNKNOWN_UNICODE_BLOCK"));
        } else {
            _log.info((Object)("undefined font: [" + code + "]" + " " + unicodeBlock.toString()));
        }
        len = ArrayUtils.getLength((Object)DEFAULT_FONT);
        for (i = 0; i < len; ++i) {
            if (!DEFAULT_FONT[i].canDisplay(codePoint)) continue;
            return DEFAULT_FONT[i];
        }
        len = LOGICAL_FONT.length;
        for (i = 0; i < len; ++i) {
            if (!LOGICAL_FONT[i].canDisplay(codePoint)) continue;
            return LOGICAL_FONT[i];
        }
        return LOGICAL_FONT[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ExtendedProperties prop;
        FileInputStream fis;
        File file;
        String propFile;
        block24: {
            _log = LogFactory.getLog(WdicUtil.class);
            _charMap = new HashMap<String, String>();
            _fontBlockMap = new HashMap<Character.UnicodeBlock, Font[]>();
            _fontCodeMap = new HashMap<Integer, Font>();
            DEFAULT_FONT = null;
            LOGICAL_FONT = new Font[]{new Font("SansSerif", 0, 1), new Font("Serif", 0, 1), new Font("Monospaced", 0, 1), new Font("Dialog", 0, 1), new Font("DialogInput", 0, 1)};
            HashMap<String, Font> fontMap = new HashMap<String, Font>();
            int len = LOGICAL_FONT.length;
            for (int i = 0; i < len; ++i) {
                fontMap.put(LOGICAL_FONT[i].getFamily(Locale.ENGLISH), LOGICAL_FONT[i]);
            }
            propFile = System.getProperty("wdic-fonts.properties");
            if (!StringUtils.isNotBlank((String)propFile)) break block24;
            file = new File(propFile);
            fis = null;
            prop = new ExtendedProperties();
            try {
                fis = new FileInputStream(file);
                prop.load((InputStream)fis, "UTF-8");
            }
            catch (IOException e) {
                try {
                    _log.warn((Object)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
            ArrayList<Font> fontList = new ArrayList<Font>();
            Iterator it = prop.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String[] family = prop.getStringArray(key);
                int n = ArrayUtils.getLength((Object)family);
                if (n == 0) continue;
                fontList.clear();
                for (int i = 0; i < n; ++i) {
                    Font font = (Font)fontMap.get(family[i]);
                    if (font == null) {
                        font = new Font(family[i], 0, 1);
                        if (font.getName().equals(family[i])) {
                            fontMap.put(family[i], font);
                            fontList.add(font);
                            continue;
                        }
                        _log.error((Object)("unknown font name: " + family[i]));
                        continue;
                    }
                    fontList.add(font);
                }
                Font[] fonts = fontList.toArray(new Font[fontList.size()]);
                if ("default".equals(key)) {
                    DEFAULT_FONT = fonts;
                    continue;
                }
                try {
                    Integer codePoint = Integer.decode(key);
                    _fontCodeMap.put(codePoint, fonts[0]);
                }
                catch (NumberFormatException e1) {
                    try {
                        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.forName(key);
                        _fontBlockMap.put(unicodeBlock, fonts);
                    }
                    catch (IllegalArgumentException e2) {
                        _log.error((Object)("unknown UnicodeBlock: " + key));
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((String)(propFile = System.getProperty("wdic-chars.properties")))) {
            file = new File(propFile);
            fis = null;
            prop = new ExtendedProperties();
            try {
                fis = new FileInputStream(file);
                prop.load((InputStream)fis, "UTF-8");
            }
            catch (IOException e) {
                _log.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
            }
            Iterator it = prop.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = prop.getString(key);
                if (StringUtils.isBlank((String)value)) continue;
                try {
                    Integer codePoint = Integer.decode(value);
                    String str = String.valueOf(Character.toChars(codePoint));
                    _charMap.put(key, str);
                }
                catch (NumberFormatException e1) {
                    _charMap.put(key, value);
                }
            }
        }
    }
}

