/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import java.util.Collections;
import java.util.List;

public class HuffmanNode
implements Comparable<HuffmanNode> {
    protected static final int LEAF_EOF = 0;
    protected static final int LEAF_8 = 1;
    protected static final int LEAF_16 = 2;
    protected static final int LEAF_32 = 3;
    private int _leafType = -1;
    private long _value = -1L;
    private int _frequency = 0;
    private HuffmanNode _left = null;
    private HuffmanNode _right = null;

    protected HuffmanNode(long value, int frequency, int leafType) {
        this._value = value;
        this._frequency = frequency;
        this._leafType = leafType;
    }

    protected HuffmanNode(HuffmanNode left, HuffmanNode right) {
        this._left = left;
        this._right = right;
        this._frequency = this._left.getFrequency() + this._right.getFrequency();
    }

    protected int getLeafType() {
        return this._leafType;
    }

    protected long getValue() {
        return this._value;
    }

    protected int getFrequency() {
        return this._frequency;
    }

    protected HuffmanNode getLeft() {
        return this._left;
    }

    protected HuffmanNode getRight() {
        return this._right;
    }

    protected boolean isLeaf() {
        return this._right == null && this._left == null;
    }

    public int hashCode() {
        return (int)(this._value + (long)this._frequency);
    }

    public boolean equals(Object obj) {
        HuffmanNode node;
        return obj instanceof HuffmanNode && (node = (HuffmanNode)obj).getLeafType() == this.getLeafType() && node.getValue() == this.getValue() && node.getFrequency() == this.getFrequency();
    }

    @Override
    public int compareTo(HuffmanNode node) {
        int ret = this.getFrequency() - node.getFrequency();
        return ret;
    }

    protected static HuffmanNode makeTree(List<HuffmanNode> list) {
        HuffmanNode tmp;
        HuffmanNode node1;
        int size = list.size();
        for (int i = 0; i < size - 1; ++i) {
            node1 = list.get(i);
            int n = i;
            for (int j = i + 1; j < size; ++j) {
                tmp = list.get(j);
                if (node1.compareTo(tmp) >= 0) continue;
                node1 = tmp;
                n = j;
            }
            if (i == n) continue;
            Collections.swap(list, i, n);
        }
        while (list.size() > 1) {
            int i;
            size = list.size();
            node1 = list.get(0);
            int n = 0;
            for (i = 1; i < size; ++i) {
                tmp = list.get(i);
                if (node1.compareTo(tmp) < 0) continue;
                node1 = tmp;
                n = i;
            }
            list.remove(n);
            size = list.size();
            HuffmanNode node2 = list.get(0);
            n = 0;
            for (i = 1; i < size; ++i) {
                tmp = list.get(i);
                if (node2.compareTo(tmp) < 0) continue;
                node2 = tmp;
                n = i;
            }
            list.remove(n);
            list.add(new HuffmanNode(node1, node2));
        }
        return list.get(0);
    }
}

