package fuku.webbook.acl;

import junit.framework.TestCase;

public class UserEntryTest extends TestCase {

    public void testAllowed() {
        String userList = "user1, user2";
        UserEntry entry = new UserEntry(true, userList);
        assertFalse(entry.isAllowed("user0"));
        assertTrue(entry.isAllowed("user1"));
        assertTrue(entry.isAllowed("user2"));
    }

    public void testDenied() {
        String userList = "user1, user2";
        UserEntry entry = new UserEntry(false, userList);
        assertTrue(entry.isAllowed("user0"));
        assertFalse(entry.isAllowed("user1"));
        assertFalse(entry.isAllowed("user2"));
    }
}

// end of UserEntryTest.java
