/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.FileInfo;
import fuku.eb4j.util.ByteUtil;
import java.io.IOException;

public class SEBXAInputStream
extends BookInputStream {
    private static final int SEBXA_SLICE_SIZE = 4096;

    protected SEBXAInputStream(FileInfo info) throws EBException {
        super(info);
        this.open();
        this.cache = new byte[4096];
    }

    @Override
    protected void initFileInfo() throws EBException {
        try {
            this.info.setRealFileSize(this.stream.length());
        }
        catch (IOException e) {
            throw new EBException(4, this.info.getPath(), e);
        }
        super.initFileInfo();
    }

    @Override
    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            int n;
            if (this.info.getFileSize() <= this.filePos) {
                if (rlen == 0) {
                    return -1;
                }
                return rlen;
            }
            if (this.filePos < this.info.getSebxaStartPosition()) {
                n = 0;
                n = this.info.getSebxaStartPosition() - this.filePos < (long)(len - rlen) ? (int)(this.info.getSebxaStartPosition() - this.filePos) : len - rlen;
                try {
                    this.stream.seek(this.filePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this.info.getPath(), e);
                }
                n = this.readRaw(b, off + rlen, n);
                rlen += n;
                this.filePos += (long)n;
                continue;
            }
            if (this.filePos >= this.info.getSebxaEndPosition()) {
                try {
                    this.stream.seek(this.filePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this.info.getPath(), e);
                }
                this.readRawFully(b, off + rlen, len - rlen);
                this.filePos += (long)(len - rlen);
                rlen = len;
                continue;
            }
            if (this.cachePos < 0L || this.filePos < this.cachePos || this.cachePos + 4096L <= this.filePos) {
                long slicePos;
                this.cachePos = this.filePos - this.filePos % 4096L;
                long sliceIndex = (this.filePos - this.info.getSebxaStartPosition()) / 4096L;
                if (sliceIndex == 0L) {
                    slicePos = this.info.getSebxaBasePosition();
                } else {
                    long pos = (sliceIndex - 1L) * 4L + this.info.getSebxaIndexPosition();
                    try {
                        this.stream.seek(pos);
                    }
                    catch (IOException e) {
                        throw new EBException(6, this.info.getPath(), e);
                    }
                    byte[] tmp = new byte[4];
                    this.readRawFully(tmp, 0, tmp.length);
                    slicePos = this.info.getSebxaBasePosition() + ByteUtil.getLong4(tmp, 0);
                }
                try {
                    this.stream.seek(slicePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this.info.getPath(), e);
                }
                this._decode();
            }
            if (len - rlen < (n = (int)(4096L - this.filePos % 4096L))) {
                n = len - rlen;
            }
            if (this.info.getFileSize() - this.filePos < (long)n) {
                n = (int)(this.info.getFileSize() - this.filePos);
            }
            int p = (int)(this.filePos - this.cachePos);
            System.arraycopy(this.cache, p, b, off + rlen, n);
            rlen += n;
            this.filePos += (long)n;
        }
        return rlen;
    }

    private void _decode() throws EBException {
        int inRest = 0;
        int inOff = 0;
        int outLen = 0;
        int outOff = 0;
        byte[] b = new byte[4096];
        int len = 8;
        boolean[] flags = new boolean[len];
        boolean loop = true;
        block0: while (loop) {
            int i;
            if (inRest <= 0) {
                inRest = this.readRaw(b, 0, b.length);
                if (inRest <= 0) {
                    throw new EBException(6, this.info.getPath());
                }
                inOff = 0;
            }
            int mask = 1;
            for (i = 0; i < len; ++i) {
                flags[i] = (b[inOff] & mask) == 0;
                mask <<= 1;
            }
            ++inOff;
            --inRest;
            for (i = 0; i < len; ++i) {
                if (flags[i]) {
                    if (inRest <= 1) {
                        throw new EBException(6, this.info.getPath());
                    }
                    int c0 = b[inOff] & 0xFF;
                    int c1 = b[inOff + 1] & 0xFF;
                    int copyOff = (((c1 & 0xF0) << 4) + c0 + 18) % 4096;
                    int copyLen = (c1 & 0xF) + 3;
                    if (outLen + copyLen > 4096) {
                        copyLen = 4096 - outLen;
                    }
                    for (int j = 0; j < copyLen; ++j) {
                        this.cache[outOff++] = copyOff < outOff ? this.cache[copyOff] : (byte)0;
                        if (++copyOff < 4096) continue;
                        copyOff = 0;
                    }
                    inRest -= 2;
                    inOff += 2;
                    outLen += copyLen;
                } else {
                    --inRest;
                    this.cache[outOff++] = b[inOff++];
                    ++outLen;
                }
                if (outLen < 4096) continue;
                loop = false;
                continue block0;
            }
        }
    }
}

