/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBZipConstants;
import fuku.eb4j.io.FileInfo;
import fuku.eb4j.util.ByteUtil;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class EBZipInputStream
extends BookInputStream
implements EBZipConstants {
    protected EBZipInputStream(FileInfo info) throws EBException {
        super(info);
        this.open();
        this.cache = new byte[info.getSliceSize()];
    }

    @Override
    protected void initFileInfo() throws EBException {
        try {
            this.info.setRealFileSize(this.stream.length());
        }
        catch (IOException e) {
            throw new EBException(4, this.info.getPath(), e);
        }
        byte[] b = new byte[22];
        this.readRawFully(b, 0, b.length);
        int mode = b[5] >>> 4;
        this.info.setZipLevel(b[5] & 0xF);
        this.info.setSliceSize(2048 << this.info.getZipLevel());
        this.info.setFileSize(ByteUtil.getLong5(b, 9));
        this.info.setZipCRC(ByteUtil.getLong4(b, 14));
        if (this.info.getFileSize() < 65536L) {
            this.info.setZipIndexSize(2);
        } else if (this.info.getFileSize() < 0x1000000L) {
            this.info.setZipIndexSize(3);
        } else if (this.info.getFileSize() < 0x100000000L) {
            this.info.setZipIndexSize(4);
        } else {
            this.info.setZipIndexSize(5);
        }
        String str = new String(b, 0, 5);
        if (!str.equals("EBZip") || this.info.getSliceSize() > 65536) {
            throw new EBException(5, this.info.getPath());
        }
        if (mode != 1 && mode != 2) {
            throw new EBException(5, this.info.getPath());
        }
        super.initFileInfo();
    }

    public int getLevel() {
        return this.info.getZipLevel();
    }

    public long getCRC() {
        return this.info.getZipCRC();
    }

    @Override
    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            int n;
            if (this.info.getFileSize() <= this.filePos) {
                if (rlen == 0) {
                    return -1;
                }
                return rlen;
            }
            if (this.cachePos < 0L || this.filePos < this.cachePos || this.cachePos + (long)this.info.getSliceSize() <= this.filePos) {
                this.cachePos = this.filePos - this.filePos % (long)this.info.getSliceSize();
                long pos = this.filePos / (long)this.info.getSliceSize() * (long)this.info.getZipIndexSize() + 22L;
                try {
                    this.stream.seek(pos);
                }
                catch (IOException e) {
                    throw new EBException(6, this.info.getPath(), e);
                }
                byte[] buf = new byte[this.info.getZipIndexSize() * 2];
                this.readRawFully(buf, 0, buf.length);
                long slicePos = 0L;
                long nextSlicePos = 0L;
                switch (this.info.getZipIndexSize()) {
                    case 2: {
                        slicePos = ByteUtil.getInt2(buf, 0);
                        nextSlicePos = ByteUtil.getInt2(buf, 2);
                        break;
                    }
                    case 3: {
                        slicePos = ByteUtil.getInt3(buf, 0);
                        nextSlicePos = ByteUtil.getInt3(buf, 3);
                        break;
                    }
                    case 4: {
                        slicePos = ByteUtil.getLong4(buf, 0);
                        nextSlicePos = ByteUtil.getLong4(buf, 4);
                        break;
                    }
                    case 5: {
                        slicePos = ByteUtil.getLong5(buf, 0);
                        nextSlicePos = ByteUtil.getLong5(buf, 5);
                        break;
                    }
                }
                int sliceSize = (int)(nextSlicePos - slicePos);
                if (sliceSize <= 0 || this.info.getSliceSize() < sliceSize) {
                    return -1;
                }
                try {
                    this.stream.seek(slicePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this.info.getPath(), e);
                }
                this._decode(sliceSize);
            }
            if (len - rlen < (n = (int)((long)this.info.getSliceSize() - this.filePos % (long)this.info.getSliceSize()))) {
                n = len - rlen;
            }
            if (this.info.getFileSize() - this.filePos < (long)n) {
                n = (int)(this.info.getFileSize() - this.filePos);
            }
            int p = (int)(this.filePos % (long)this.info.getSliceSize());
            System.arraycopy(this.cache, p, b, off + rlen, n);
            rlen += n;
            this.filePos += (long)n;
        }
        return rlen;
    }

    private void _decode(int size) throws EBException {
        if (size == this.info.getSliceSize()) {
            this.readRawFully(this.cache, 0, size);
        } else {
            byte[] b = new byte[size];
            Inflater inf = new Inflater();
            try {
                this.readRawFully(b, 0, size);
                inf.setInput(b, 0, size);
                inf.inflate(this.cache, 0, this.info.getSliceSize());
            }
            catch (DataFormatException e) {
                throw new EBException(5, this.info.getPath(), e);
            }
            finally {
                inf.end();
            }
        }
    }
}

