/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.zipcode;

import fuku.xml2eb.converter.zipcode.ZipCodeUtil;
import fuku.xml2eb.util.UnicodeUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipCodeKen {
    private static final String ENCODING = "MS932";
    private Logger _logger = null;
    private File _file = null;
    private List<Item> _itemList = new ArrayList<Item>();

    public ZipCodeKen(File file) {
        this._logger = LoggerFactory.getLogger(this.getClass());
        this._file = file;
        this._load();
    }

    public List<Item> getItemList() {
        return this._itemList;
    }

    public Date getDate() {
        long time = this._file.lastModified();
        return new Date(time);
    }

    public Map<String, List<Item>> getZipcodeMap() {
        TreeMap<String, List<Item>> map = new TreeMap<String, List<Item>>();
        int size = this._itemList.size();
        for (int i = 0; i < size; ++i) {
            Item item = this._itemList.get(i);
            String key = item.getZipcode();
            ArrayList<Item> list = (ArrayList<Item>)map.get(key);
            if (list == null) {
                list = new ArrayList<Item>();
                map.put(key, list);
            }
            list.add(item);
        }
        return map;
    }

    public Map<String, Map<String, List<Item>>> getAddressMap() {
        LinkedHashMap<String, Map<String, List<Item>>> map = new LinkedHashMap<String, Map<String, List<Item>>>();
        int size = this._itemList.size();
        for (int i = 0; i < size; ++i) {
            String key2;
            ArrayList<Item> list;
            Item item = this._itemList.get(i);
            String key1 = item.getPrefecture();
            LinkedHashMap<String, ArrayList<Item>> map1 = (LinkedHashMap<String, ArrayList<Item>>)map.get(key1);
            if (map1 == null) {
                map1 = new LinkedHashMap<String, ArrayList<Item>>();
                map.put(key1, map1);
            }
            if ((list = (ArrayList<Item>)map1.get(key2 = item.getCity())) == null) {
                list = new ArrayList<Item>();
                map1.put(key2, list);
            }
            list.add(item);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        this._logger.info("load file: " + this._file.getPath());
        LineNumberReader lnr = null;
        try {
            Charset cs = Charset.forName(ENCODING);
            lnr = new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), cs)));
            String line = null;
            Item item = null;
            while ((line = lnr.readLine()) != null) {
                StrTokenizer st = StrTokenizer.getCSVInstance((String)(line = UnicodeUtil.sanitizeUnicode((String)line)));
                int n = st.size();
                if (n != 15) {
                    this._logger.error("unexpected token count: " + this._file.getName() + "[" + lnr.getLineNumber() + "] " + n);
                    continue;
                }
                String[] tokens = st.getTokenArray();
                int empty = -1;
                for (int i = 0; i < n; ++i) {
                    if (!StringUtils.isBlank((String)tokens[i])) continue;
                    empty = i;
                    break;
                }
                if (empty != -1) {
                    this._logger.warn("empty token found: " + this._file.getName() + "[" + lnr.getLineNumber() + "] " + empty);
                    continue;
                }
                if (item != null && !item.isClosed()) {
                    item.appendArea(tokens[5], tokens[8]);
                    continue;
                }
                item = new Item(tokens[0], tokens[2], tokens[3], tokens[4], tokens[5], tokens[6], tokens[7], tokens[8]);
                this._itemList.add(item);
            }
            this._logger.info("loaded " + this._itemList.size() + " items");
            IOUtils.closeQuietly((Reader)lnr);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(lnr);
        }
    }

    public static class Item {
        private String _code = null;
        private String _zipcode = null;
        private String _kanaPrefecture = null;
        private String _prefecture = null;
        private String _kanaCity = null;
        private String _city = null;
        private String _kanaTown = null;
        private String _town = null;
        private String _kanaArea = null;
        private String _area = null;
        private boolean _exception = false;
        private boolean _closed = true;

        protected Item(String code, String zipcode, String kanaPrefecture, String kanaCity, String kanaTown, String prefecture, String city, String town) {
            this._code = code;
            this._zipcode = zipcode.substring(0, 3) + "-" + zipcode.substring(3);
            this._kanaPrefecture = ZipCodeUtil.toFullwidth(kanaPrefecture, prefecture);
            this._prefecture = prefecture;
            this._kanaCity = ZipCodeUtil.toFullwidth(kanaCity, city);
            this._city = city;
            if ("\u4ee5\u4e0b\u306b\u63b2\u8f09\u304c\u306a\u3044\u5834\u5408".equals(town)) {
                this._exception = true;
            } else if (town.endsWith("\u306e\u6b21\u306b\u756a\u5730\u304c\u304f\u308b\u5834\u5408")) {
                this._exception = true;
                this._town = town;
            } else if (town.length() > 3 && (town.endsWith("\u5e02\u4e00\u5186") || town.endsWith("\u753a\u4e00\u5186") || town.endsWith("\u6751\u4e00\u5186"))) {
                this._exception = true;
                this._town = town;
            } else {
                int idx2;
                int idx1 = (kanaTown = ZipCodeUtil.toFullwidth(kanaTown, town)).indexOf("\uff08");
                if (idx1 == -1) {
                    this._kanaTown = kanaTown;
                } else {
                    this._kanaTown = kanaTown.substring(0, idx1);
                    idx2 = kanaTown.indexOf("\uff09", idx1 + 1);
                    if (idx2 == -1) {
                        this._closed = false;
                        this._kanaArea = kanaTown.substring(idx1 + 1);
                    } else {
                        this._kanaArea = kanaTown.substring(idx1 + 1, idx2);
                    }
                }
                idx1 = town.indexOf("\uff08");
                if (idx1 == -1) {
                    this._town = town;
                } else {
                    this._town = town.substring(0, idx1);
                    idx2 = town.indexOf("\uff09", idx1 + 1);
                    if (idx2 == -1) {
                        this._closed = false;
                        this._area = town.substring(idx1 + 1);
                    } else {
                        this._area = town.substring(idx1 + 1, idx2);
                    }
                }
            }
        }

        public String getCode() {
            return this._code;
        }

        public String getZipcode() {
            return this._zipcode;
        }

        public String getKanaPrefecture() {
            return this._kanaPrefecture;
        }

        public String getKanaCity() {
            return this._kanaCity;
        }

        public String getKanaTown() {
            return this._kanaTown;
        }

        public String getKanaArea() {
            return this._kanaArea;
        }

        public String getPrefecture() {
            return this._prefecture;
        }

        public String getCity() {
            return this._city;
        }

        public String getTown() {
            return this._town;
        }

        public String getArea() {
            return this._area;
        }

        public boolean isException() {
            return this._exception;
        }

        protected boolean isClosed() {
            return this._closed;
        }

        protected void appendArea(String kanaStr, String str) {
            int idx = (kanaStr = ZipCodeUtil.toFullwidth(kanaStr, str)).indexOf("\uff09");
            if (idx == -1) {
                this._kanaArea = this._kanaArea + kanaStr;
            } else {
                this._closed = true;
                this._kanaArea = this._kanaArea + kanaStr.substring(0, idx);
            }
            idx = str.indexOf("\uff09");
            if (idx == -1) {
                this._area = this._area + str;
            } else {
                this._closed = true;
                this._area = this._area + str.substring(0, idx);
            }
        }
    }
}

