/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import fuku.eb4j.util.ByteUtil;
import fuku.xml2eb.BlockOutputStream;
import fuku.xml2eb.InvalidCharacterException;
import fuku.xml2eb.Reference;
import fuku.xml2eb.util.UnicodeUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Stack;
import javax.sound.sampled.AudioFormat;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextOutputStream
extends BlockOutputStream {
    public static final int BOLD = 3;
    public static final int ITALIC = 1;
    private static final Integer NARROW = 0;
    private static final Integer SUBSCRIPT = 1;
    private static final Integer SUPERSCRIPT = 2;
    private static final Integer NOBR = 3;
    private static final Integer EMPHASIS = 4;
    private static final Integer DECORATION = 5;
    private static final Integer KEYWORD = 6;
    private static final Integer REFERENCE = 7;
    private static final Integer ICGRAPHIC = 8;
    private static final Integer CGRAPHIC = 9;
    private static final Integer SOUND = 10;
    private Logger _logger = null;
    private Stack<Integer> _stack = new Stack();
    private Reference _ref = null;
    private File _file = null;
    private int _indent = -1;

    public TextOutputStream(File file, OutputStream out) {
        super(out);
        this._logger = LoggerFactory.getLogger(this.getClass());
        this._file = file;
    }

    public void setReference(Reference ref) {
        this._ref = ref;
    }

    private boolean _isModifier(Integer mod) {
        if (this._stack.empty()) {
            return false;
        }
        return this._stack.peek().equals(mod);
    }

    @Override
    public void close() throws IOException {
        if (this._indent > 0) {
            byte[] val = new byte[]{31, 9, (byte)(this._indent >>> 8 & 0xFF), (byte)(this._indent & 0xFF)};
            super.write(val, 0, val.length);
            this._indent = -1;
        }
        super.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._indent > 0) {
            byte[] val = new byte[]{31, 9, (byte)(this._indent >>> 8 & 0xFF), (byte)(this._indent & 0xFF)};
            super.write(val, 0, val.length);
            this._indent = -1;
        }
        super.write(b, off, len);
    }

    @Override
    public long getSize() {
        long size = super.getSize();
        if (this._indent > 0) {
            size += 4L;
        }
        return size;
    }

    public void setIndent(int level) throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        this._indent = level;
    }

    public void append(String text) throws IOException {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        String str = text.replace('\t', ' ');
        str = UnicodeUtil.sanitizeUnicode(str);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int c2;
            int c;
            int codePoint = str.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                throw new InvalidCharacterException(codePoint);
            }
            String s = String.valueOf(Character.toChars(codePoint));
            byte[] b = s.getBytes("EUC-JP");
            if (ArrayUtils.isEmpty((byte[])b)) {
                throw new InvalidCharacterException(codePoint);
            }
            int c1 = b[0] & 0xFF;
            if (c1 == 63 && codePoint != 63) {
                throw new InvalidCharacterException(codePoint);
            }
            if (c1 == 10 || c1 == 13) continue;
            if (c1 >= 32 && c1 <= 126) {
                c = ByteUtil.asciiToJISX0208((int)c1);
                if (!this._isModifier(NARROW)) {
                    this.beginNarrow();
                }
                this.write(c >>> 8 & 0xFF);
                this.write(c & 0xFF);
                continue;
            }
            if (c1 >= 161 && c1 <= 254) {
                c2 = b[1] & 0xFF;
                if (c2 >= 161 && c2 <= 254) {
                    c1 &= 0x7F;
                    c2 &= 0x7F;
                    if (this._isModifier(NARROW)) {
                        this.endNarrow();
                    }
                    this.write(c1);
                    this.write(c2);
                    continue;
                }
                throw new InvalidCharacterException(codePoint);
            }
            if (c1 == 142) {
                c2 = b[1] & 0xFF;
                if (c2 >= 161 && c2 <= 223) {
                    c = ByteUtil.jisx0201ToJISX0208((int)c2);
                    if (!this._isModifier(NARROW)) {
                        this.beginNarrow();
                    }
                    this.write(c >>> 8 & 0xFF);
                    this.write(c & 0xFF);
                    continue;
                }
                throw new InvalidCharacterException(codePoint);
            }
            throw new InvalidCharacterException(codePoint);
        }
    }

    public void appendNarrowChar(String name) throws IOException {
        int code = this._ref.getNarrowChar(name);
        if (code < 0) {
            throw new IOException("narrow character name not defined: " + name);
        }
        if (!this._isModifier(NARROW)) {
            this.beginNarrow();
        }
        this.write(code >>> 8 & 0xFF);
        this.write(code & 0xFF);
    }

    public void appendWideChar(String name) throws IOException {
        int code = this._ref.getWideChar(name);
        if (code < 0) {
            throw new IOException("wide character name not defined: " + name);
        }
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        this.write(code >>> 8 & 0xFF);
        this.write(code & 0xFF);
    }

    public void beginContext() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        this.write(31);
        this.write(2);
    }

    public void endContext() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        this.write(31);
        this.write(3);
    }

    public void beginNarrow() throws IOException {
        if (this._stack.search(NARROW) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(4);
        this._stack.push(NARROW);
    }

    public void endNarrow() throws IOException {
        if (!this._isModifier(NARROW)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(5);
        this._stack.pop();
    }

    public void beginSubscript() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(SUBSCRIPT) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(6);
        this._stack.push(SUBSCRIPT);
    }

    public void endSubscript() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(SUBSCRIPT)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(7);
        this._stack.pop();
    }

    public void beginSuperscript() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(SUPERSCRIPT) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(14);
        this._stack.push(SUPERSCRIPT);
    }

    public void endSuperscript() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(SUPERSCRIPT)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(15);
        this._stack.pop();
    }

    public void newLine() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._stack.empty()) {
            throw new IOException("modifier not terminated before newline");
        }
        this.write(31);
        this.write(10);
    }

    public void beginNoNewLine() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(NOBR) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(16);
        this._stack.push(NOBR);
    }

    public void endNoNewLine() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(NOBR)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(17);
        this._stack.pop();
    }

    public void beginEmphasis() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(EMPHASIS) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(18);
        this._stack.push(EMPHASIS);
    }

    public void endEmphasis() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(EMPHASIS)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(19);
        this._stack.pop();
    }

    public void beginDecoration(int type) throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(DECORATION) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(224);
        this.write(type >>> 8 & 0xFF);
        this.write(type & 0xFF);
        this._stack.push(DECORATION);
    }

    public void endDecoration() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(DECORATION)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(225);
        this._stack.pop();
    }

    public void beginKeyword() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(KEYWORD) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(65);
        this.write(1);
        this.write(0);
        this._stack.push(KEYWORD);
    }

    public void endKeyword() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(KEYWORD)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(97);
        this._stack.pop();
    }

    public void beginReference() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(REFERENCE) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(66);
        this._stack.push(REFERENCE);
    }

    public void endReference(String name) throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(REFERENCE)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(98);
        byte[] b = new byte[6];
        Arrays.fill(b, (byte)0);
        this.write(b, 0, b.length);
        this._ref.putBodyRef(this._file, this.getSize() - 6L, name);
        this._stack.pop();
    }

    public void beginInlineColorGraphic(String name, String format) throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(ICGRAPHIC) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(60);
        if ("bmp".equals(format)) {
            this.write(0);
            this.write(9);
        } else {
            this.write(18);
            this.write(9);
        }
        this.write(0);
        this.write(1);
        byte[] b = new byte[14];
        Arrays.fill(b, (byte)0);
        this.write(b, 0, b.length);
        this._ref.putGraphicRef(this._file, this.getSize() - 6L, name);
        this._stack.push(ICGRAPHIC);
    }

    public void endInlineColorGraphic() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(ICGRAPHIC)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(92);
        this._stack.pop();
    }

    public void beginColorGraphic(String name, String format) throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(CGRAPHIC) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(77);
        if ("bmp".equals(format)) {
            this.write(0);
            this.write(9);
        } else {
            this.write(18);
            this.write(9);
        }
        this.write(0);
        this.write(1);
        byte[] b = new byte[14];
        Arrays.fill(b, (byte)0);
        this.write(b, 0, b.length);
        this._ref.putGraphicRef(this._file, this.getSize() - 6L, name);
        this._stack.push(CGRAPHIC);
    }

    public void endColorGraphic() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(CGRAPHIC)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(109);
        this._stack.pop();
    }

    public void beginSound(String name, String format) throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (this._stack.search(SOUND) > 0) {
            throw new IOException("duplicate modifier");
        }
        this.write(31);
        this.write(74);
        if ("wav".equals(format)) {
            this.write(0);
            this.write(1);
        } else {
            this.write(0);
            this.write(2);
        }
        int flags = 0;
        AudioFormat audioFormat = this._ref.getAudioFormat(name);
        if (audioFormat != null) {
            int channels = audioFormat.getChannels();
            if (channels == 2) {
                flags |= 0x1000;
            } else if (channels != 1) {
                this._logger.warn("unsupported channnels: " + channels + " [" + name + "]");
            }
            int bits = audioFormat.getSampleSizeInBits();
            if (bits == 8) {
                flags |= 0x10;
            } else if (bits != 16) {
                this._logger.warn("unsupported bits per sample: " + bits + " [" + name + "]");
            }
            float sampleRate = audioFormat.getSampleRate();
            if (sampleRate == 22050.0f) {
                flags |= 1;
            } else if (sampleRate == 11025.0f) {
                flags |= 2;
            } else if (sampleRate != 44100.0f) {
                this._logger.warn("unsupported sample rate: " + sampleRate + " [" + name + "]");
            }
        } else {
            flags = 18;
        }
        this.write(flags >>> 8);
        this.write(flags);
        byte[] b = new byte[12];
        Arrays.fill(b, (byte)0);
        this.write(b, 0, b.length);
        this._ref.putSoundRef(this._file, this.getSize() - 12L, name);
        this._stack.push(SOUND);
    }

    public void endSound() throws IOException {
        if (this._isModifier(NARROW)) {
            this.endNarrow();
        }
        if (!this._isModifier(SOUND)) {
            throw new IOException("unexpected the end of modifier");
        }
        this.write(31);
        this.write(106);
        this._stack.pop();
    }
}

