/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import fuku.eb4j.util.ByteUtil;
import fuku.xml2eb.InvalidCharacterException;
import fuku.xml2eb.Word;
import fuku.xml2eb.util.UnicodeUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordSet
extends TreeSet<Word> {
    public static final int DIRECTION_WORD = 0;
    public static final int DIRECTION_ENDWORD = 1;
    private transient Logger _logger = LoggerFactory.getLogger(this.getClass());
    private int _direction = 0;

    public WordSet(int direction) {
        this._direction = direction;
    }

    public void add(String word, String tag) throws InvalidCharacterException, UnsupportedEncodingException, IOException {
        if (StringUtils.isBlank((String)word)) {
            return;
        }
        String str = UnicodeUtil.sanitizeUnicode(word);
        int len = str.length();
        byte[] tmp = new byte[len * 2];
        int idx = 0;
        for (int i = 0; i < len; ++i) {
            int c2;
            int c;
            int codePoint = str.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                throw new InvalidCharacterException(codePoint);
            }
            String s = String.valueOf(Character.toChars(codePoint));
            byte[] b = s.getBytes("EUC-JP");
            if (ArrayUtils.isEmpty((byte[])b)) {
                throw new InvalidCharacterException(codePoint);
            }
            int c1 = b[0] & 0xFF;
            if (c1 == 63 && codePoint != 63) {
                throw new InvalidCharacterException(codePoint);
            }
            if (c1 == 32 || c1 == 39 || c1 == 45) continue;
            if (c1 >= 33 && c1 <= 126) {
                if (c1 >= 97 && c1 <= 122) {
                    c1 -= 32;
                }
                c = ByteUtil.asciiToJISX0208((int)c1);
                tmp[idx++] = (byte)(c >>> 8 & 0xFF);
                tmp[idx++] = (byte)(c & 0xFF);
                continue;
            }
            if (c1 >= 161 && c1 <= 254) {
                c2 = b[1] & 0xFF;
                if (c2 >= 161 && c2 <= 254) {
                    if (c1 == 163 && c2 >= 225 && c2 <= 250) {
                        c2 = c2 - 32 & 0x7F;
                        tmp[idx++] = (byte)((c1 &= 0x7F) & 0xFF);
                        tmp[idx++] = (byte)(c2 & 0xFF);
                        continue;
                    }
                    if (c1 == 161 && (c2 == 161 || c2 == 199 || c2 == 221 || c2 == 166 || c2 == 190)) continue;
                    tmp[idx++] = (byte)((c1 &= 0x7F) & 0xFF);
                    tmp[idx++] = (byte)((c2 &= 0x7F) & 0xFF);
                    continue;
                }
                throw new InvalidCharacterException(codePoint);
            }
            if (c1 == 142) {
                c2 = b[1] & 0xFF;
                if (c2 >= 161 && c2 <= 223) {
                    c = ByteUtil.jisx0201ToJISX0208((int)c2);
                    tmp[idx++] = (byte)(c >>> 8 & 0xFF);
                    tmp[idx++] = (byte)(c & 0xFF);
                    continue;
                }
                throw new InvalidCharacterException(codePoint);
            }
            throw new InvalidCharacterException(codePoint);
        }
        if (idx == 0) {
            this._logger.warn("word is empty: '" + word + "' [id=" + tag + "]");
            return;
        }
        if (idx > 255) {
            throw new IOException("too long word: '" + word + "' [id=" + tag + "]");
        }
        byte[] buf = new byte[idx];
        System.arraycopy(tmp, 0, buf, 0, idx);
        if (this._direction == 1) {
            ByteUtil.reverseWord((byte[])buf);
        }
        try {
            this._logger.trace("add word: " + new String(buf, "x-JIS0208") + " [" + word + "]");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        Word wd = new Word(buf, tag);
        if (!this.contains(wd)) {
            this.add(wd);
        }
        boolean katakana = false;
        for (int i = 0; i < idx; i += 2) {
            int c = buf[i] & 0xFF;
            if (c != 37) continue;
            buf[i] = 36;
            katakana = true;
        }
        if (katakana) {
            try {
                this._logger.trace("add word: " + new String(buf, "x-JIS0208") + " [" + word + "]");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            wd = new Word(buf, tag);
            if (!this.contains(wd)) {
                this.add(wd);
            }
        }
    }
}

