/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.xml2eb.converter.wdic.Wdic;
import fuku.xml2eb.converter.wdic.WdicBib;
import fuku.xml2eb.converter.wdic.WdicGroupList;
import fuku.xml2eb.converter.wdic.WdicItem;
import fuku.xml2eb.converter.wdic.WdicUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdicGroup {
    private static final String ENCODING = "UTF-8";
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    private WdicGroupList _groupList = null;
    private File _file = null;
    private String _groupId = null;
    private String _name = null;
    private List<Wdic> _list = null;
    private WdicBib _bib = null;

    public WdicGroup(WdicGroupList groupList, String id, File file) {
        this._groupList = groupList;
        this._groupId = id;
        this._file = file;
        this._list = new ArrayList<Wdic>();
        this._load();
    }

    public WdicGroupList getGroupList() {
        return this._groupList;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getGroupName() {
        return this._name;
    }

    public Wdic getWdic(String word) {
        int len = this._list.size();
        for (int i = 0; i < len; ++i) {
            Wdic dic = this._list.get(i);
            if (!dic.exists(word)) continue;
            return dic;
        }
        return null;
    }

    protected WdicItem getWdicItem(String word) {
        int len = this._list.size();
        for (int i = 0; i < len; ++i) {
            Wdic dic = this._list.get(i);
            WdicItem item = dic.getWdicItem(word);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public List<Wdic> getWdics() {
        ArrayList<Wdic> list = new ArrayList<Wdic>();
        list.addAll(this._list);
        return list;
    }

    public WdicBib getWdicBib() {
        return this._bib;
    }

    protected void getWdicItem(String dir, List<WdicItem> list) {
        int len = this._list.size();
        for (int i = 0; i < len; ++i) {
            Wdic dic = this._list.get(i);
            dic.getWdicItem(dir, list);
        }
    }

    protected void getPluginMap(Map<String, Set<WdicItem>> map) {
        int len = this._list.size();
        for (int i = 0; i < len; ++i) {
            Wdic dic = this._list.get(i);
            dic.getPluginMap(map);
        }
    }

    public int hashCode() {
        return this._groupId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WdicGroup) {
            WdicGroup group = (WdicGroup)obj;
            return this._groupId.equals(group.getGroupId());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        this._logger.info("load file: " + this._file.getPath());
        File dir = this._file.getParentFile();
        Pattern attrPattern = Pattern.compile("^(\\S+)\\s*=\\s*(.+)$");
        LineIterator it = null;
        try {
            it = FileUtils.lineIterator((File)this._file, (String)ENCODING);
            int section = 0;
            block8: while (it.hasNext()) {
                String line = WdicUtil.sanitize(it.nextLine());
                if (line.length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("[")) {
                    int idx = line.indexOf("]");
                    if (idx <= 1) continue;
                    String sec = line.substring(1, idx);
                    if ("GROUP".equals(sec)) {
                        section = 1;
                        continue;
                    }
                    if (!"FILES".equals(sec)) continue;
                    section = 2;
                    continue;
                }
                switch (section) {
                    case 1: {
                        Matcher m = attrPattern.matcher(line);
                        if (!m.matches()) break;
                        String name = m.group(1);
                        String val = m.group(2);
                        if ("NAME".equals(name)) {
                            int idx = val.indexOf("\u7528\u8a9e\u306e\u57fa\u790e\u77e5\u8b58");
                            if (idx > 0) {
                                this._name = val.substring(0, idx);
                                break;
                            }
                            this._name = val;
                            break;
                        }
                        if ("CONTENT".equals(name)) break;
                        if (!"CONTACT".equals(name)) continue block8;
                    }
                    case 2: {
                        String[] str = line.split("\\t");
                        if (str.length < 2) break;
                        File file = new File(dir, str[0]);
                        Wdic dic = new Wdic(this, str[1], file);
                        this._list.add(dic);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            try {
                this._logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                LineIterator.closeQuietly(it);
                throw throwable;
            }
            LineIterator.closeQuietly((LineIterator)it);
        }
        LineIterator.closeQuietly((LineIterator)it);
        String name = this._groupId + ".MAN";
        File bibfile = new File(dir, name);
        this._bib = new WdicBib(bibfile);
    }
}

