/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.xml2eb.converter.wdic.WdicGroup;
import fuku.xml2eb.converter.wdic.WdicItem;
import fuku.xml2eb.converter.wdic.WdicUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdicGroupList {
    private static final String ENCODING = "UTF-8";
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    private File _file = null;
    private String _name = null;
    private String _edition = null;
    private Map<String, WdicGroup> _map = null;

    public WdicGroupList(File file) {
        this._file = file;
        this._map = new LinkedHashMap<String, WdicGroup>();
        this._load();
    }

    public String getName() {
        return this._name;
    }

    public String getEdition() {
        return this._edition;
    }

    public Collection<WdicGroup> getGroups() {
        return this._map.values();
    }

    public WdicGroup getGroup(String group) {
        return this._map.get(group);
    }

    public List<WdicItem> getWdicItem(String dir) {
        ArrayList<WdicItem> list = new ArrayList<WdicItem>();
        for (WdicGroup group : this._map.values()) {
            group.getWdicItem(dir, list);
        }
        return list;
    }

    public Map<String, Set<WdicItem>> getPluginMap() {
        TreeMap<String, Set<WdicItem>> pmap = new TreeMap<String, Set<WdicItem>>();
        for (WdicGroup grp : this._map.values()) {
            grp.getPluginMap(pmap);
        }
        return pmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        this._logger.info("load file: " + this._file.getPath());
        Pattern attrPattern = Pattern.compile("^(\\S+)\\s*=\\s*(.+)$");
        LineIterator it = null;
        try {
            it = FileUtils.lineIterator((File)this._file, (String)ENCODING);
            int section = 0;
            block8: while (it.hasNext()) {
                String line = WdicUtil.sanitize(it.nextLine());
                if (line.length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("[")) {
                    int idx = line.indexOf("]");
                    if (idx <= 1) continue;
                    String sec = line.substring(1, idx);
                    if ("INFO".equals(sec)) {
                        section = 1;
                        continue;
                    }
                    if (!"GROUP".equals(sec)) continue;
                    section = 2;
                    continue;
                }
                switch (section) {
                    case 1: {
                        Matcher m = attrPattern.matcher(line);
                        if (!m.matches()) break;
                        String name = m.group(1);
                        String val = m.group(2);
                        if ("NAME".equals(name)) {
                            this._name = val;
                            break;
                        }
                        if ("EDITION".equals(name)) {
                            this._edition = val;
                            break;
                        }
                        if (!"CONTACT".equals(name)) continue block8;
                    }
                    case 2: {
                        String[] str = line.split("\\t");
                        if (str.length < 2) break;
                        File dir = this._file.getParentFile();
                        WdicGroup group = new WdicGroup(this, str[0], new File(dir, str[1]));
                        this._map.put(group.getGroupId(), group);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            try {
                this._logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                LineIterator.closeQuietly(it);
                throw throwable;
            }
            LineIterator.closeQuietly((LineIterator)it);
        }
        LineIterator.closeQuietly((LineIterator)it);
    }
}

