/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.xml2eb.converter.wdic.WdicUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdicMan {
    private static final String ENCODING = "UTF-8";
    private static final Pattern SEC_PATTERN = Pattern.compile("^-+\\s\\u25a0\\s(\\S*)\\s\\u25a0\\s-+$");
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    private File _file = null;
    private List<String> _copyList = null;
    private Map<String, List<String>> _map = null;

    public WdicMan(File file) {
        this._file = file;
        this._copyList = new ArrayList<String>();
        this._map = new LinkedHashMap<String, List<String>>();
        this._load();
    }

    public String[] getCopyright() {
        return this._copyList.toArray(new String[this._copyList.size()]);
    }

    public String[] getSections() {
        return this._map.keySet().toArray(new String[this._map.size()]);
    }

    public String[] getContents(String sec) {
        List<String> list = this._map.get(sec);
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        this._logger.info("load file: " + this._file.getPath());
        LineIterator it = null;
        try {
            it = FileUtils.lineIterator((File)this._file, (String)ENCODING);
            while (it.hasNext()) {
                String line = WdicUtil.sanitize(it.nextLine());
                String sec = null;
                Matcher m = SEC_PATTERN.matcher(line);
                if (m.matches()) {
                    sec = m.group(1);
                }
                while (sec != null) {
                    List<String> list = this._map.get(sec);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this._map.put(sec, list);
                    }
                    if ("\u5404\u8f9e\u66f8\u306e\u7279\u8272".equals(sec)) {
                        sec = this._loadFeature(it, list);
                        continue;
                    }
                    if ("\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u305d\u306e\u4ed6".equals(sec)) {
                        sec = this._loadFormat(it, list);
                        continue;
                    }
                    if ("\u54c1\u8a5e\u540d\u306b\u3064\u3044\u3066".equals(sec)) {
                        sec = this._loadPartOfSpeech(it, list);
                        continue;
                    }
                    if ("\u8aad\u307f\u306b\u3064\u3044\u3066".equals(sec) || "\u767a\u97f3\u306b\u3064\u3044\u3066".equals(sec)) {
                        sec = this._loadReading(it, list);
                        continue;
                    }
                    if ("\u305d\u306e\u4ed6\u306e\u898f\u5b9a".equals(sec)) {
                        sec = this._loadRules(it, list);
                        continue;
                    }
                    if ("\u6539\u8a02\u5c65\u6b74".equals(sec)) {
                        sec = this._loadHistory(it, list);
                        continue;
                    }
                    if ("\u57f7\u7b46\u74b0\u5883".equals(sec)) {
                        sec = this._loadEnvironment(it, list);
                        continue;
                    }
                    if ("\u30b5\u30dd\u30fc\u30c8".equals(sec)) {
                        sec = this._loadSupport(it, list);
                        continue;
                    }
                    if ("\u5965\u4ed8".equals(sec) || "\u9023\u7d61\u5148".equals(sec)) {
                        sec = this._loadCopyright(it, list);
                        continue;
                    }
                    sec = this._loadSection(it, list);
                }
            }
        }
        catch (IOException e) {
            try {
                this._logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                LineIterator.closeQuietly(it);
                throw throwable;
            }
            LineIterator.closeQuietly((LineIterator)it);
        }
        LineIterator.closeQuietly((LineIterator)it);
    }

    private String _loadSection(LineIterator it, List<String> list) {
        Pattern footnote = Pattern.compile("^\\(%[0-9]+\\)\\s+.+$");
        Pattern numlist = Pattern.compile("^[0-9]+\\..+$");
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            if (StringUtils.isBlank((String)line)) {
                if (buf.length() <= 0) continue;
                list.add(buf.toString());
                list.add("");
                buf.delete(0, buf.length());
                continue;
            }
            String str = StringUtils.stripStart((String)line, (String)" ");
            if (buf.length() > 0) {
                if (str.startsWith("\u30fb")) {
                    list.add(buf.toString());
                    list.add("");
                    buf.delete(0, buf.length());
                } else if (footnote.matcher(str).matches()) {
                    list.add(buf.toString());
                    buf.delete(0, buf.length());
                } else if (numlist.matcher(str).matches()) {
                    list.add(buf.toString());
                    buf.delete(0, buf.length());
                }
            }
            if (str.startsWith("\u30fb")) {
                str = "\u25c6 " + str.substring(1);
            }
            buf.append(str);
        }
        return null;
    }

    private String _loadFeature(LineIterator it, List<String> list) {
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            if (StringUtils.isBlank((String)line)) {
                if (buf.length() <= 0) continue;
                list.add(buf.toString());
                list.add("");
                buf.delete(0, buf.length());
                continue;
            }
            String str = StringUtils.stripStart((String)line, (String)" ");
            if (str.startsWith("\u25a0")) {
                str = str.substring(1);
            } else {
                if (str.startsWith("(\u5730\u7406)") || str.startsWith("(\u9053\u8def)") || str.startsWith("(\u8eca)") || str.startsWith("(\u6d77\u4e8b)") || str.startsWith("(\u822a\u7a7a)")) {
                    int size = list.size();
                    str = list.get(size - 1);
                    if (str.length() != 0) continue;
                    list.remove(size - 1);
                    continue;
                }
                if (line.startsWith("     ")) {
                    if (buf.length() > 0) {
                        list.add(buf.toString());
                        buf.delete(0, buf.length());
                    }
                    buf.append("\t");
                }
            }
            buf.append(str);
        }
        return null;
    }

    private String _loadFormat(LineIterator it, List<String> list) {
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            if (StringUtils.isBlank((String)line)) {
                if (buf.length() <= 0) continue;
                list.add(buf.toString());
                list.add("");
                buf.delete(0, buf.length());
                continue;
            }
            String str = StringUtils.stripStart((String)line, (String)" ");
            if (str.startsWith("\u30fb")) {
                str = "\u25a0 " + str.substring(1);
            } else if (str.startsWith("#")) {
                buf.append("\t");
            } else if (str.startsWith("[")) {
                if (buf.length() > 0) {
                    list.add(buf.toString());
                    buf.delete(0, buf.length());
                }
                buf.append("\t        ");
            } else if (str.startsWith("\u3010")) {
                buf.append("\t");
            } else if (line.startsWith("                  ")) {
                if (buf.length() > 0) {
                    list.add(buf.toString());
                    buf.delete(0, buf.length());
                }
                buf.append("\t          ");
            }
            buf.append(str);
        }
        return null;
    }

    private String _loadPartOfSpeech(LineIterator it, List<String> list) {
        StringBuilder buf = new StringBuilder();
        String subsec = null;
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            if (StringUtils.isBlank((String)line)) {
                if (buf.length() <= 0) continue;
                list.add(buf.toString());
                list.add("");
                buf.delete(0, buf.length());
                continue;
            }
            String str = StringUtils.stripStart((String)line, (String)" ");
            if (str.startsWith("\u25a0")) {
                subsec = str.substring(1);
                str = "\u25a0 " + subsec;
            } else if (str.startsWith("\u250f") || str.startsWith("\u2503") || str.startsWith("\u2517")) {
                if (buf.length() > 0) {
                    list.add(buf.toString());
                    buf.delete(0, buf.length());
                }
            } else if ("\u4ed8\u5c5e\u8a9e\u54c1\u8a5e".equals(subsec)) {
                if (line.startsWith("         ")) {
                    if (buf.length() > 0) {
                        list.add(buf.toString());
                        buf.delete(0, buf.length());
                    }
                    buf.append("\t");
                }
            } else if ("\u610f\u5473\u54c1\u8a5e".equals(subsec)) {
                if (str.startsWith("+") || str.startsWith("|")) {
                    if (buf.length() > 0) {
                        list.add(buf.toString());
                        buf.delete(0, buf.length());
                    }
                    buf.append("\t");
                    if (line.startsWith("          ")) {
                        buf.append("    ");
                    }
                }
            } else if ("\u62e1\u5f35\u54c1\u8a5e".equals(subsec)) {
                if (buf.toString().startsWith("\u25a0 ")) {
                    list.add(buf.toString());
                    list.add("");
                    buf.delete(0, buf.length());
                }
                if ("\u7528\u8a9e".equals(str)) {
                    buf.append("\t");
                } else if (line.startsWith("      ")) {
                    if (buf.length() > 0) {
                        list.add(buf.toString());
                        buf.delete(0, buf.length());
                    }
                    buf.append("\t");
                    str = line.substring(6);
                }
            }
            buf.append(str);
        }
        return null;
    }

    private String _loadReading(LineIterator it, List<String> list) {
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            String tmp;
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            if (StringUtils.isBlank((String)line)) {
                if (buf.length() <= 0) continue;
                list.add(buf.toString());
                list.add("");
                buf.delete(0, buf.length());
                continue;
            }
            String str = StringUtils.stripStart((String)line, (String)" ");
            if (str.startsWith("\u30fb")) {
                if (line.startsWith("      ")) {
                    if (buf.length() > 0) {
                        list.add(buf.toString());
                        buf.delete(0, buf.length());
                    }
                    buf.append("\t");
                } else {
                    str = "\u25a0 " + str.substring(1);
                }
            } else if (line.startsWith("        ")) {
                if (buf.length() == 0) {
                    buf.append("\t");
                    if (str.startsWith("\u4f8b") || str.startsWith("\u30e1\u30fc\u30c8\u30eb") || str.startsWith("[\u4f8b]")) {
                        buf.append("\t");
                    } else if (str.startsWith("(\u901a\u5e38\u306e\u4ee3\u7528\u65b9\u6cd5)")) {
                        str = line.substring(6);
                    }
                } else {
                    tmp = buf.toString().trim();
                    if (!tmp.startsWith("\u30fb") && !tmp.startsWith("\u306a\u305c")) {
                        list.add(buf.toString());
                        buf.delete(0, buf.length());
                        buf.append("\t");
                    }
                }
            } else if (line.startsWith("     ") && !(tmp = buf.toString().trim()).startsWith("\u25a0 ") && !tmp.startsWith("\u306a\u305c") && !tmp.startsWith("\u7701\u7565\u3067\u304d\u308b")) {
                if (buf.length() > 0) {
                    list.add(buf.toString());
                    buf.delete(0, buf.length());
                }
                buf.append("\t");
            }
            buf.append(str);
        }
        return null;
    }

    private String _loadRules(LineIterator it, List<String> list) {
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            if (StringUtils.isBlank((String)line)) {
                if (buf.length() <= 0) continue;
                list.add(buf.toString());
                list.add("");
                buf.delete(0, buf.length());
                continue;
            }
            String str = StringUtils.stripStart((String)line, (String)" ");
            if (str.startsWith("\u30fb")) {
                str = list.isEmpty() ? str.substring(1) : "\u25a0 " + str.substring(1);
            } else if (str.indexOf(" ") >= 0) {
                if (buf.length() > 0) {
                    list.add(buf.toString());
                    buf.delete(0, buf.length());
                }
                buf.append("\t");
            } else if (buf.length() == 0) {
                buf.append("\t");
            }
            buf.append(str);
        }
        return null;
    }

    private String _loadHistory(LineIterator it, List<String> list) {
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            if (StringUtils.isBlank((String)line)) {
                if (list.isEmpty()) continue;
                list.add("");
                continue;
            }
            if (line.startsWith("\uff03 ")) {
                line = "\u25c6 " + line.substring(2);
            }
            list.add(line);
        }
        return null;
    }

    private String _loadEnvironment(LineIterator it, List<String> list) {
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            if (StringUtils.isBlank((String)line)) {
                if (buf.length() <= 0) continue;
                list.add(buf.toString());
                list.add("");
                buf.delete(0, buf.length());
                continue;
            }
            String str = StringUtils.stripStart((String)line, (String)" ");
            if ("\u5e02\u8ca9".equals(str) || "\u30aa\u30f3\u30e9\u30a4\u30f3\u6d41\u901a".equals(str)) {
                buf.append("\t\u25a0 ");
            } else if (!"\u656c\u79f0\u7565".equals(str) && line.startsWith("     ")) {
                if (buf.length() > 0) {
                    list.add(buf.toString());
                    buf.delete(0, buf.length());
                }
                buf.append("\t");
            }
            buf.append(str);
        }
        return null;
    }

    private String _loadSupport(LineIterator it, List<String> list) {
        Pattern numlist = Pattern.compile("^\\([0-9]+\\).+$");
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            if (StringUtils.isBlank((String)line)) {
                if (buf.length() <= 0) continue;
                list.add(buf.toString());
                list.add("");
                buf.delete(0, buf.length());
                continue;
            }
            String str = StringUtils.stripStart((String)line, (String)" ");
            if (buf.length() == 0 && !numlist.matcher(str).matches()) {
                buf.append("\t");
            }
            buf.append(str);
        }
        return null;
    }

    private String _loadCopyright(LineIterator it, List<String> list) {
        Pattern endPattern = Pattern.compile("^-+$");
        Pattern itemPattern = Pattern.compile("^\\s+(\\S+)\\s+(\\S+)$");
        while (it.hasNext()) {
            String line = WdicUtil.sanitize(it.nextLine());
            Matcher m = SEC_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
            m = endPattern.matcher(line);
            if (m.matches()) {
                return null;
            }
            m = itemPattern.matcher(line);
            if (m.matches()) {
                String name = m.group(1);
                String val = m.group(2);
                StringBuilder buf = new StringBuilder();
                buf.append(name);
                int len = 14 - this._getLength(name);
                for (int i = 0; i < len; ++i) {
                    buf.append(" ");
                }
                buf.append(val);
                this._copyList.add(buf.toString());
            }
            list.add(line.trim());
        }
        return null;
    }

    private int _getLength(String str) {
        int len = 0;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (CharUtils.isAscii((char)ch)) {
                ++len;
                continue;
            }
            len += 2;
        }
        return len;
    }
}

