package fuku.player;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import javax.sound.sampled.*;
import javax.swing.*;

/**
 * 饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class AudioPlayerApplet
    extends JApplet implements ActionListener, LineListener {

    /**  */
    private static final int PLAY = 0;
    /**  */
    private static final int PAUSE = 1;
    /**  */
    private static final int STOP = 2;

    /** ե̾ */
    private static final String[] ICON = {
        "fuku/player/resources/play16x16.png",
        "fuku/player/resources/pause16x16.png",
        "fuku/player/resources/stop16x16.png"
    };
    /** Υ */
    private static final Dimension ICON_SIZE = new Dimension(16, 16);

    /**  */
    private ImageIcon[] _icon = null;

    /** ǥå */
    private Clip _clip = null;

    /** ܥ */
    private JButton _playBtn = null;
    /** ߥܥ */
    private JButton _stopBtn = null;

    /** ϰ */
    private int _pos = 0;
    /** ꥻåȥե饰 */
    private boolean _reset = false;


    /**
     * ΥץåȤޤ
     *
     */
    public void init() {
        // ǥåפμ
        try {
            URL url = new URL(getDocumentBase(), getParameter("file"));
            AudioInputStream ais = AudioSystem.getAudioInputStream(url);
            DataLine.Info info = new DataLine.Info(Clip.class, ais.getFormat());
            _clip = (Clip)AudioSystem.getLine(info);
            _clip.addLineListener(this);
            _clip.open(ais);
        } catch (MalformedURLException e) {
            System.err.println(e.getMessage());
        } catch (LineUnavailableException e) {
            System.err.println(e.getMessage());
        } catch (UnsupportedAudioFileException e) {
            System.err.println(e.getMessage());
        } catch (IOException e) {
            System.err.println(e.getMessage());
        }

        // κ
        _icon = new ImageIcon[ICON.length];
        for (int i=0; i<ICON.length; i++) {
            URL url = getClass().getClassLoader().getResource(ICON[i]);
            _icon[i] = new ImageIcon(url);
        }

        // ܥκ
        _playBtn = new JButton(_icon[PLAY]);
        _playBtn.setMargin(new Insets(0, 0, 0, 0));
        _playBtn.setPreferredSize(ICON_SIZE);
        _playBtn.setMaximumSize(ICON_SIZE);
        _playBtn.setMinimumSize(ICON_SIZE);
        _playBtn.addActionListener(this);
        _stopBtn = new JButton(_icon[STOP]);
        _stopBtn.setMargin(new Insets(0, 0, 0, 0));
        _stopBtn.setPreferredSize(ICON_SIZE);
        _stopBtn.setMaximumSize(ICON_SIZE);
        _stopBtn.setMinimumSize(ICON_SIZE);
        _stopBtn.addActionListener(this);

        // 
        getContentPane().setLayout(new BorderLayout(0, 0));
        getContentPane().add(_playBtn, BorderLayout.WEST);
        getContentPane().add(_stopBtn, BorderLayout.EAST);
    }

    /**
     * ץåȤϤȸƤӽФޤ
     *
     */
    public void start() {
        super.start();
    }

    /**
     * ץåȤߤȸƤӽФޤ
     *
     */
    public void stop() {
        if (_clip.isRunning()) {
            _clip.stop();
        }
        super.stop();
    }

    /**
     * ٤ƤΥ꥽ޤ
     *
     */
    public void destroy() {
        getContentPane().removeAll();
        if (_clip != null) {
            _clip.close();
            _clip = null;
        }
        super.destroy();
    }

    /**
     * ȯȸƤӽФޤ
     *
     * @param evt 󥤥٥
     */
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj instanceof JButton) {
            JButton btn = (JButton)obj;
            if (obj.equals(_playBtn)) {
                if (_clip.isRunning()) {
                    _clip.stop();
                } else {
                    _clip.setFramePosition(_pos);
                    _clip.start();
                }
            } else if (obj.equals(_stopBtn)) {
                if (_clip.isRunning()) {
                    _clip.stop();
                    _reset = true;
                }
                _pos = 0;
            }
        }
    }

    /**
     * 饤ξ֤ѲȸƤӽФޤ
     *
     * @param evt 饤󥤥٥
     */
    public void update(LineEvent evt) {
        LineEvent.Type type = evt.getType();
        if (type.equals(LineEvent.Type.START)) {
            _playBtn.setIcon(_icon[PAUSE]);
        } else if (type.equals(LineEvent.Type.STOP)) {
            if (_reset) {
                _pos = 0;
                _reset = false;
            } else if (_pos == _clip.getFramePosition()) {
                // ߤʤɳϰ֤ꤵƤ
                // ϰ֤äƤгϰ֤ǽ
                _pos = 0;
            } else {
                _pos = _clip.getFramePosition();
                if (_pos < 0 || _pos >= _clip.getFrameLength()) {
                    // ۾ͤǤгϰ֤ǽ
                    _pos = 0;
                }
            }
            _playBtn.setIcon(_icon[PLAY]);
        }
    }
}

// end of AudioPlayerApplet.java
